/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi.jaxb;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.util.List;
import org.iplass.mtp.impl.metadata.MetaDataRuntimeException;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebApiJaxbService
implements Service {
    private static Logger logger = LoggerFactory.getLogger(WebApiJaxbService.class);
    private JAXBContext context;
    private List<String> classesToBeBound;

    public void init(Config config) {
        try {
            this.classesToBeBound = config.getValues("classToBeBound");
            Class[] classes = new Class[this.classesToBeBound.size()];
            for (int i = 0; i < this.classesToBeBound.size(); ++i) {
                classes[i] = Class.forName(this.classesToBeBound.get(i));
                logger.debug("Add to JAXBContext:" + String.valueOf(classes[i]));
            }
            this.context = JAXBContext.newInstance((Class[])classes);
        }
        catch (JAXBException e) {
            throw new MetaDataRuntimeException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new MetaDataRuntimeException((Throwable)e);
        }
    }

    public void destroy() {
        this.context = null;
    }

    public JAXBContext getJAXBContext() {
        return this.context;
    }
}

