/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.template;

import java.util.HashMap;
import java.util.Map;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.definition.TypedDefinitionManager;
import org.iplass.mtp.impl.definition.AbstractTypedMetaDataService;
import org.iplass.mtp.impl.definition.DefinitionMetaDataTypeMap;
import org.iplass.mtp.impl.web.template.MetaTemplate;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.iplass.mtp.web.template.definition.TemplateDefinition;
import org.iplass.mtp.web.template.definition.TemplateDefinitionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateService
extends AbstractTypedMetaDataService<MetaTemplate, MetaTemplate.TemplateRuntime>
implements Service {
    private static Logger logger = LoggerFactory.getLogger(TemplateService.class);
    public static final String TEMPLATE_META_PATH = "/template/";
    private Map<Class<? extends TemplateDefinition>, Class<? extends MetaTemplate>> metaTemplateClassMap;

    public void destroy() {
    }

    public void init(Config config) {
        this.metaTemplateClassMap = new HashMap<Class<? extends TemplateDefinition>, Class<? extends MetaTemplate>>();
        Map classPathMap = (Map)config.getValue("templateClassMap", Map.class);
        if (classPathMap == null) {
            logger.debug("No template classes config found.");
            return;
        }
        for (Map.Entry defMetaEntry : classPathMap.entrySet()) {
            try {
                Class<?> defClass = Class.forName((String)defMetaEntry.getKey());
                if (!TemplateDefinition.class.isAssignableFrom(defClass)) {
                    throw new ClassCastException("Incompatible class: " + (String)defMetaEntry.getKey() + " is not a subclass of TemplateDefinition.");
                }
                Class<?> metaClass = Class.forName((String)defMetaEntry.getValue());
                if (!MetaTemplate.class.isAssignableFrom(metaClass)) {
                    throw new ClassCastException("Incompatible class: " + (String)defMetaEntry.getValue() + " is not a subclass of MetaTemplate.");
                }
                this.metaTemplateClassMap.put(defClass, metaClass);
            }
            catch (ClassCastException | ClassNotFoundException e) {
                throw new ServiceConfigrationException("templateClass: Failed to get class entries from the service config.", (Throwable)e);
            }
        }
    }

    public Class<? extends MetaTemplate> getMetaTemplateClassByDef(TemplateDefinition definition) {
        return this.metaTemplateClassMap.get(definition.getClass());
    }

    public static String getFixedPath() {
        return TEMPLATE_META_PATH;
    }

    public Class<MetaTemplate> getMetaDataType() {
        return MetaTemplate.class;
    }

    public Class<MetaTemplate.TemplateRuntime> getRuntimeType() {
        return MetaTemplate.TemplateRuntime.class;
    }

    public static class TypeMap
    extends DefinitionMetaDataTypeMap<TemplateDefinition, MetaTemplate> {
        public TypeMap() {
            super(TemplateService.getFixedPath(), MetaTemplate.class, TemplateDefinition.class);
        }

        public TypedDefinitionManager<TemplateDefinition> typedDefinitionManager() {
            return (TypedDefinitionManager)ManagerLocator.getInstance().getManager(TemplateDefinitionManager.class);
        }
    }
}

