/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.staticresource;

import jakarta.activation.MimetypesFileTypeMap;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.definition.binary.ArchiveBinaryDefinition;
import org.iplass.mtp.definition.binary.BinaryDefinition;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.metadata.BaseMetaDataRuntime;
import org.iplass.mtp.impl.metadata.BaseRootMetaData;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.metadata.binary.ArchiveBinaryMetaData;
import org.iplass.mtp.impl.metadata.binary.BinaryMetaData;
import org.iplass.mtp.impl.metadata.binary.SimpleBinaryMetaData;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.web.RangeHeader;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.WebUtil;
import org.iplass.mtp.impl.web.staticresource.MetaEntryPathTranslator;
import org.iplass.mtp.impl.web.staticresource.MetaLocalizedStaticResource;
import org.iplass.mtp.impl.web.staticresource.MetaMimeTypeMapping;
import org.iplass.mtp.web.actionmapping.definition.result.ContentDispositionType;
import org.iplass.mtp.web.staticresource.EntryPathTranslator;
import org.iplass.mtp.web.staticresource.definition.LocalizedStaticResourceDefinition;
import org.iplass.mtp.web.staticresource.definition.MimeTypeMappingDefinition;
import org.iplass.mtp.web.staticresource.definition.StaticResourceDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStaticResource
extends BaseRootMetaData
implements DefinableMetaData<StaticResourceDefinition> {
    private static final long serialVersionUID = -1254930892273250498L;
    private static Logger logger = LoggerFactory.getLogger(MetaStaticResource.class);
    private BinaryMetaData resource;
    private List<MetaLocalizedStaticResource> localizedResourceList;
    private String contentType;
    private List<MetaMimeTypeMapping> mimeTypeMapping;
    private String entryTextCharset;
    private MetaEntryPathTranslator entryPathTranslator;

    public BinaryMetaData getResource() {
        return this.resource;
    }

    public void setResource(BinaryMetaData resource) {
        this.resource = resource;
    }

    public List<MetaLocalizedStaticResource> getLocalizedResourceList() {
        return this.localizedResourceList;
    }

    public void setLocalizedResourceList(List<MetaLocalizedStaticResource> localizedResourceList) {
        this.localizedResourceList = localizedResourceList;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getEntryTextCharset() {
        return this.entryTextCharset;
    }

    public void setEntryTextCharset(String entryTextCharset) {
        this.entryTextCharset = entryTextCharset;
    }

    public List<MetaMimeTypeMapping> getMimeTypeMapping() {
        return this.mimeTypeMapping;
    }

    public void setMimeTypeMapping(List<MetaMimeTypeMapping> mimeTypeMapping) {
        this.mimeTypeMapping = mimeTypeMapping;
    }

    public MetaEntryPathTranslator getEntryPathTranslator() {
        return this.entryPathTranslator;
    }

    public void setEntryPathTranslator(MetaEntryPathTranslator entryPathTranslator) {
        this.entryPathTranslator = entryPathTranslator;
    }

    public StaticResourceRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new StaticResourceRuntime();
    }

    public MetaStaticResource copy() {
        return (MetaStaticResource)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    public void applyConfig(StaticResourceDefinition def) {
        this.name = def.getName();
        this.description = def.getDescription();
        this.displayName = def.getDisplayName();
        this.localizedDisplayNameList = I18nUtil.toMeta(def.getLocalizedDisplayNameList());
        this.resource = def.getResource() == null ? null : (def.getResource() instanceof ArchiveBinaryDefinition ? new ArchiveBinaryMetaData((ArchiveBinaryDefinition)def.getResource()) : new SimpleBinaryMetaData(def.getResource()));
        if (def.getLocalizedResourceList() != null) {
            this.localizedResourceList = new ArrayList<MetaLocalizedStaticResource>(def.getLocalizedResourceList().size());
            for (LocalizedStaticResourceDefinition lr : def.getLocalizedResourceList()) {
                MetaLocalizedStaticResource mlr = new MetaLocalizedStaticResource();
                mlr.setLocaleName(lr.getLocaleName());
                if (lr.getResource() instanceof ArchiveBinaryDefinition) {
                    mlr.setResource((BinaryMetaData)new ArchiveBinaryMetaData((ArchiveBinaryDefinition)lr.getResource()));
                } else if (lr.getResource() instanceof BinaryDefinition) {
                    mlr.setResource((BinaryMetaData)new SimpleBinaryMetaData(lr.getResource()));
                }
                this.localizedResourceList.add(mlr);
            }
        }
        this.contentType = def.getContentType();
        if (def.getMimeTypeMapping() == null) {
            this.mimeTypeMapping = null;
        } else {
            this.mimeTypeMapping = new ArrayList<MetaMimeTypeMapping>(def.getMimeTypeMapping().size());
            for (MimeTypeMappingDefinition md : def.getMimeTypeMapping()) {
                this.mimeTypeMapping.add(new MetaMimeTypeMapping(md.getExtension(), md.getMimeType()));
            }
        }
        this.entryTextCharset = def.getEntryTextCharset();
        this.entryPathTranslator = MetaEntryPathTranslator.toMeta(def.getEntryPathTranslator());
    }

    public StaticResourceDefinition currentConfig() {
        StaticResourceDefinition def = new StaticResourceDefinition();
        def.setName(this.name);
        def.setDescription(this.description);
        def.setDisplayName(this.displayName);
        def.setLocalizedDisplayNameList(I18nUtil.toDef((List)this.localizedDisplayNameList));
        if (this.resource != null) {
            def.setResource(this.resource.currentConfig());
        }
        if (this.localizedResourceList != null && this.localizedResourceList.size() > 0) {
            def.setLocalizedResourceList(new ArrayList<LocalizedStaticResourceDefinition>(this.localizedResourceList.size()));
            for (MetaLocalizedStaticResource mlr : this.localizedResourceList) {
                LocalizedStaticResourceDefinition lr = new LocalizedStaticResourceDefinition();
                lr.setLocaleName(mlr.getLocaleName());
                if (mlr.getResource() != null) {
                    lr.setResource(mlr.getResource().currentConfig());
                }
                def.getLocalizedResourceList().add(lr);
            }
        }
        def.setContentType(this.contentType);
        if (this.mimeTypeMapping != null && this.mimeTypeMapping.size() > 0) {
            def.setMimeTypeMapping(new ArrayList<MimeTypeMappingDefinition>(this.mimeTypeMapping.size()));
            for (MetaMimeTypeMapping mm : this.mimeTypeMapping) {
                MimeTypeMappingDefinition md = new MimeTypeMappingDefinition();
                md.setExtension(mm.getExtension());
                md.setMimeType(mm.getMimeType());
                def.getMimeTypeMapping().add(md);
            }
        }
        def.setEntryTextCharset(this.entryTextCharset);
        if (this.entryPathTranslator != null) {
            def.setEntryPathTranslator(this.entryPathTranslator.currentConfig());
        }
        return def;
    }

    public class StaticResourceRuntime
    extends BaseMetaDataRuntime {
        private Map<String, String> mimeMap;
        private EntryPathTranslator eptInstance;
        private Map<String, BinaryMetaData> langMap;

        public StaticResourceRuntime() {
            try {
                if (MetaStaticResource.this.mimeTypeMapping != null && MetaStaticResource.this.mimeTypeMapping.size() > 0) {
                    this.mimeMap = new HashMap<String, String>();
                    for (MetaMimeTypeMapping mm : MetaStaticResource.this.mimeTypeMapping) {
                        this.mimeMap.put(mm.getExtension(), mm.getMimeType());
                    }
                }
                if (MetaStaticResource.this.entryPathTranslator != null) {
                    this.eptInstance = MetaStaticResource.this.entryPathTranslator.createEntryPathTranslator(MetaStaticResource.this.getName());
                }
                if (MetaStaticResource.this.localizedResourceList != null) {
                    this.langMap = new HashMap<String, BinaryMetaData>();
                    for (MetaLocalizedStaticResource mls : MetaStaticResource.this.localizedResourceList) {
                        this.langMap.put(mls.getLocaleName(), mls.getResource());
                    }
                }
            }
            catch (RuntimeException e) {
                this.setIllegalStateException(e);
            }
        }

        public MetaStaticResource getMetaData() {
            return MetaStaticResource.this;
        }

        public boolean isArchive() {
            return this.resource() instanceof ArchiveBinaryMetaData;
        }

        private String resolveContentType(String entryPath, WebRequestStack requestStack) {
            Object mimeType = null;
            int lioDot = entryPath.lastIndexOf(46);
            if (lioDot >= 0) {
                String ext = entryPath.substring(lioDot + 1);
                if (this.mimeMap != null) {
                    mimeType = this.mimeMap.get(ext);
                }
                if (mimeType == null) {
                    mimeType = requestStack.getServletContext().getMimeType(entryPath);
                }
                if (mimeType == null) {
                    mimeType = MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(entryPath);
                }
            }
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            if (MetaStaticResource.this.entryTextCharset != null && ((String)mimeType).toLowerCase().startsWith("text/")) {
                mimeType = (String)mimeType + "; charset=" + MetaStaticResource.this.entryTextCharset;
            }
            return mimeType;
        }

        private String transratePath(String entryPath) {
            if (this.eptInstance != null) {
                return this.eptInstance.translate(entryPath);
            }
            return entryPath;
        }

        private boolean isGetHeadRequest(String method) {
            switch (method) {
                case "HEAD": 
                case "GET": {
                    return true;
                }
            }
            return false;
        }

        private BinaryMetaData resource() {
            String lang;
            BinaryMetaData ret;
            if (this.langMap != null && (ret = this.langMap.get(lang = ExecuteContext.getCurrentContext().getLanguage())) != null) {
                return ret;
            }
            return MetaStaticResource.this.resource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(WebRequestStack requestStack, String entryPath, boolean useContentDisposition, ContentDispositionType contentDispositionType) throws IOException, ServletException {
            this.checkState();
            InputStream is = null;
            try {
                String method = requestStack.getRequest().getMethod();
                boolean isHead = "HEAD".equals(method);
                long size = -1L;
                String contentType = null;
                BinaryMetaData _resource = this.resource();
                if (_resource instanceof ArchiveBinaryMetaData) {
                    ArchiveBinaryMetaData archive = (ArchiveBinaryMetaData)_resource;
                    String pathTrans = this.transratePath(entryPath);
                    if (!archive.hasEntry(pathTrans)) {
                        requestStack.getResponse().sendError(404);
                        return;
                    }
                    size = archive.getEntrySize(pathTrans);
                    contentType = this.resolveContentType(pathTrans, requestStack);
                    if (!isHead) {
                        is = archive.getEntryAsStream(pathTrans);
                    }
                } else if (_resource == null) {
                    size = 0L;
                } else {
                    size = _resource.getSize();
                    contentType = MetaStaticResource.this.contentType;
                    if (!isHead) {
                        is = _resource.getInputStream();
                    }
                }
                if (useContentDisposition) {
                    String fileName = entryPath.substring(entryPath.lastIndexOf(47) + 1);
                    WebUtil.setContentDispositionHeader(requestStack, contentDispositionType, fileName);
                }
                if (contentType != null) {
                    requestStack.getResponse().setContentType(contentType);
                }
                RangeHeader range = null;
                if (this.isGetHeadRequest(method)) {
                    range = RangeHeader.getRangeHeader(requestStack, size);
                    size = RangeHeader.writeResponseHeader(requestStack, range, size);
                }
                requestStack.getResponse().setHeader("Content-Length", String.valueOf(size));
                if (is != null) {
                    ServletOutputStream os = requestStack.getResponse().getOutputStream();
                    requestStack.getRequestContext().setAttribute("org.iplass.mtp.markUseOutputStream", (Object)"org.iplass.mtp.markUseOutputStream");
                    RangeHeader.writeResponseBody(is, (OutputStream)os, range);
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        logger.warn("can not close staticResource's inputstream:" + String.valueOf(is), (Throwable)e);
                    }
                }
            }
        }
    }
}

