/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.interceptors;

import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.tenant.MetaTenant;
import org.iplass.mtp.impl.tenant.MetaTenantService;
import org.iplass.mtp.impl.tenant.web.MetaTenantWebInfo;
import org.iplass.mtp.impl.web.ErrorUrlSelector;
import org.iplass.mtp.impl.web.WebFrontendService;
import org.iplass.mtp.impl.web.WebUtil;
import org.iplass.mtp.impl.web.actionmapping.ActionMappingService;
import org.iplass.mtp.impl.web.actionmapping.WebInvocationImpl;
import org.iplass.mtp.impl.web.template.MetaTemplate;
import org.iplass.mtp.impl.web.template.TemplateService;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceInitListener;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.web.interceptor.RequestInterceptor;
import org.iplass.mtp.web.interceptor.RequestInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionInterceptor
implements RequestInterceptor,
ServiceInitListener<ActionMappingService> {
    private static Logger logger = LoggerFactory.getLogger(ExceptionInterceptor.class);
    private List<String> noHande;
    private List<String> eliminate;
    private List<Class<?>[]> noHandeClass;
    private List<Class<?>[]> eliminateClass;
    private WebFrontendService wfService = (WebFrontendService)ServiceRegistry.getRegistry().getService(WebFrontendService.class);
    private MetaTenantService metaTenantService = (MetaTenantService)ServiceRegistry.getRegistry().getService(MetaTenantService.class);
    private TemplateService tService = (TemplateService)ServiceRegistry.getRegistry().getService(TemplateService.class);

    public void inited(ActionMappingService service, Config config) {
        if (this.noHande != null) {
            this.noHandeClass = ExceptionInterceptor.toClassList(this.noHande);
        }
        if (this.eliminate != null) {
            this.eliminateClass = ExceptionInterceptor.toClassList(this.eliminate);
        }
    }

    public static List<Class<?>[]> toClassList(List<String> classNames) {
        ArrayList<Class<?>[]> ret = new ArrayList<Class<?>[]>(classNames.size());
        for (String cn : classNames) {
            String[] splits = cn.split(":");
            try {
                Class[] cl = new Class[splits.length];
                for (int i = 0; i < splits.length; ++i) {
                    cl[i] = Class.forName(splits[i]);
                }
                ret.add(cl);
            }
            catch (ClassNotFoundException e) {
                logger.warn("ignore cause ClassNotFoundException:" + cn);
            }
        }
        return ret;
    }

    public void destroyed() {
    }

    public List<String> getEliminate() {
        return this.eliminate;
    }

    public void setEliminate(List<String> eliminate) {
        this.eliminate = eliminate;
    }

    public List<String> getNoHande() {
        return this.noHande;
    }

    public void setNoHande(List<String> noHande) {
        this.noHande = noHande;
    }

    public static boolean match(List<Class<?>[]> classList, Throwable e) {
        if (classList == null) {
            return false;
        }
        for (Class<?>[] nha : classList) {
            Throwable current = e;
            for (int i = 0; i < nha.length && current != null && nha[i].isAssignableFrom(current.getClass()); ++i) {
                if (i == nha.length - 1) {
                    return true;
                }
                current = e.getCause();
            }
        }
        return false;
    }

    @Override
    public void intercept(RequestInvocation invocation) {
        block17: {
            try {
                invocation.proceedRequest();
            }
            catch (RuntimeException e) {
                WebInvocationImpl webInvocation = (WebInvocationImpl)invocation;
                if (!webInvocation.getRequestStack().isClientDirectRequest()) {
                    throw e;
                }
                if (ExceptionInterceptor.match(this.noHandeClass, e)) {
                    throw e;
                }
                if (ExceptionInterceptor.match(this.eliminateClass, e)) {
                    logger.debug("eliminate exception:" + String.valueOf(e));
                    return;
                }
                try {
                    if (!webInvocation.getRequestStack().getResponse().isCommitted() && invocation.getRequest().getAttribute("org.iplass.mtp.markUseOutputStream") == null) {
                        webInvocation.getRequestStack().getResponse().resetBuffer();
                        if (!(e instanceof ApplicationException)) {
                            webInvocation.getRequestStack().getResponse().setStatus(500);
                        }
                        webInvocation.getRequest().setAttribute("mtp.web.exception", (Object)e);
                        WebUtil.setCacheControlHeader(webInvocation.getRequestStack(), false, -1L);
                        Tenant tenant = ExecuteContext.getCurrentContext().getCurrentTenant();
                        MetaTenant.MetaTenantHandler th = this.metaTenantService.getRuntimeByName(tenant.getName());
                        MetaTenantWebInfo.MetaTenantWebInfoRuntime twebr = (MetaTenantWebInfo.MetaTenantWebInfoRuntime)th.getConfigRuntime(MetaTenantWebInfo.MetaTenantWebInfoRuntime.class);
                        String errorTemplateName = twebr != null ? twebr.errorUrlSelector(e, webInvocation.getRequest(), webInvocation.getRequestStack().getRequestPath().getTargetPath(true)) : null;
                        MetaTemplate.TemplateRuntime tr = null;
                        if (StringUtil.isNotEmpty(errorTemplateName) && (tr = (MetaTemplate.TemplateRuntime)this.tService.getRuntimeByName(errorTemplateName)) == null) {
                            logger.error("can not find error template:" + errorTemplateName + ", so use default error template");
                        }
                        if (tr == null) {
                            String defaultErrorTemplate = null;
                            ErrorUrlSelector defaultSelector = this.wfService.getErrorUrlSelector();
                            if (defaultSelector != null) {
                                defaultErrorTemplate = defaultSelector.getErrorTemplateName(e, webInvocation.getRequest(), webInvocation.getRequestStack().getRequestPath().getTargetPath(true));
                            }
                            if (defaultErrorTemplate != null) {
                                tr = (MetaTemplate.TemplateRuntime)this.tService.getRuntimeByName(defaultErrorTemplate);
                            }
                            if (tr == null) {
                                logger.error("can not find default error template:" + defaultErrorTemplate);
                            }
                        }
                        if (tr == null) {
                            logger.error("can not find error template, so throw exception.");
                            throw e;
                        }
                        tr.handle(webInvocation.getRequestStack());
                    } else {
                        logger.warn("response already commited, so can not show error page of " + String.valueOf(e));
                    }
                }
                catch (ServletException | IOException e1) {
                    e1.addSuppressed(e);
                    if (ExceptionInterceptor.match(this.eliminateClass, e1)) {
                        logger.debug("eliminate exception(at exception handling):" + String.valueOf(e1));
                        break block17;
                    }
                    logger.error(e1.getMessage(), e1);
                }
            }
        }
    }
}

