/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.interceptors;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.StringTokenizer;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.web.WebProcessRuntimeException;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.actionmapping.MetaActionMapping;
import org.iplass.mtp.impl.web.actionmapping.WebInvocationImpl;
import org.iplass.mtp.impl.web.actionmapping.cache.CachableHttpServletResponse;
import org.iplass.mtp.impl.web.actionmapping.cache.ContentCache;
import org.iplass.mtp.impl.web.actionmapping.cache.ContentCacheContext;
import org.iplass.mtp.impl.web.actionmapping.cache.MetaCacheCriteria;
import org.iplass.mtp.impl.web.actionmapping.cache.blocks.IncludeActionBlock;
import org.iplass.mtp.impl.web.preview.PreviewHandler;
import org.iplass.mtp.web.interceptor.RequestInterceptor;
import org.iplass.mtp.web.interceptor.RequestInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionCacheInterceptor
implements RequestInterceptor {
    private static Logger logger = LoggerFactory.getLogger(ActionCacheInterceptor.class);
    private PreviewHandler preview = new PreviewHandler();

    @Override
    public void intercept(RequestInvocation invocation) {
        if (this.preview.isPreview(invocation.getRequest())) {
            invocation.proceedRequest();
            return;
        }
        WebInvocationImpl webInvocation = (WebInvocationImpl)invocation;
        WebRequestStack reqStack = webInvocation.getRequestStack();
        reqStack.setAttribute("org.iplass.mtp.actionRuntime", (Object)webInvocation.getAction());
        CachableHttpServletResponse response = (CachableHttpServletResponse)((Object)reqStack.getRequest().getAttribute("org.iplass.mtp.cachableHttpServletResponse"));
        if (response == null) {
            response = new CachableHttpServletResponse(reqStack.getResponse());
            reqStack.getRequest().setAttribute("org.iplass.mtp.cachableHttpServletResponse", (Object)response);
            reqStack.setResponse((HttpServletResponse)response);
        }
        boolean prevDoCache = response.isDoCache();
        try {
            MetaActionMapping.ActionMappingRuntime amr = webInvocation.getAction();
            if (reqStack.isIncludeStack()) {
                this.doInclude(response, webInvocation, amr);
            } else if (reqStack.isLayoutStack()) {
                this.doLayout(response, webInvocation, amr);
            } else {
                this.doDirect(response, webInvocation, amr, true);
            }
            response.flushToContentCache();
        }
        catch (IOException e) {
            throw new WebProcessRuntimeException(e);
        }
        catch (ServletException e) {
            throw new WebProcessRuntimeException(e);
        }
        finally {
            response.setDoCache(prevDoCache);
        }
    }

    private void doDirect(CachableHttpServletResponse response, WebInvocationImpl invocation, MetaActionMapping.ActionMappingRuntime amr, boolean isClientDirect) throws ServletException, IOException {
        if (amr.getCacheCriteria() != null) {
            String lang = ExecuteContext.getCurrentContext().getLanguage();
            ContentCacheContext ac = ContentCacheContext.getContentCacheContext();
            MetaCacheCriteria.CacheCriteriaRuntime ccr = amr.getCacheCriteria();
            String key = ccr.createContentCacheKey(invocation.getRequest());
            if (key == null) {
                this.withoutCache(response, invocation);
            } else {
                ContentCache cache = ac.get(invocation.getActionName(), lang, key);
                if (cache != null) {
                    response.setDoCache(false);
                    long lastModified = cache.getLastModified(invocation, ac, lang);
                    if (isClientDirect && this.isNotModified(cache, lastModified, response, invocation, ac, lang)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("action:" + invocation.getActionName() + " cached and not modified.");
                        }
                        response.setStatus(304);
                    } else {
                        if (lastModified < Long.MAX_VALUE) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("action:" + invocation.getActionName() + " all stack cached. response from cache.");
                            }
                            if (isClientDirect) {
                                this.setLastModAndEtag(lastModified, response, invocation, lang, ac, cache);
                            }
                        } else if (logger.isDebugEnabled()) {
                            logger.debug("action:" + invocation.getActionName() + " partial stack cached. response from cache partially.");
                        }
                        cache.write(invocation);
                    }
                } else {
                    long ttl = 0L;
                    if (ccr.getMetaData().getTimeToLive() != null) {
                        ttl = ccr.getMetaData().getTimeToLive().longValue();
                    }
                    ContentCache newCache = new ContentCache(invocation.getActionName(), lang, key, ttl);
                    response.setDoCache(true);
                    response.setCurrentContentCache(newCache);
                    invocation.proceedRequest();
                    if (invocation.getRequestStack().getPageContext() != null) {
                        invocation.getRequestStack().getPageContext().getOut().flush();
                    }
                    response.flushToContentCache();
                    ContentCache createdCache = response.getCurrentContentCache();
                    if (!response.isError() && !response.isRedirect() && ccr.canCache(invocation)) {
                        ac.put(invocation.getActionName(), lang, key, createdCache);
                    }
                }
            }
        } else {
            this.withoutCache(response, invocation);
        }
    }

    private void withoutCache(CachableHttpServletResponse response, WebInvocationImpl invocation) throws IOException {
        response.setDoCache(false);
        response.setCurrentContentCache(null);
        invocation.proceedRequest();
        if (invocation.getRequestStack().getPageContext() != null) {
            invocation.getRequestStack().getPageContext().getOut().flush();
        }
    }

    private void setLastModAndEtag(long lastModified, CachableHttpServletResponse response, WebInvocationImpl invocation, String lang, ContentCacheContext ac, ContentCache cache) {
        if (lastModified >= 0L && lastModified != Long.MAX_VALUE) {
            response.setDateHeader("Last-Modified", lastModified);
            response.setHeader("ETag", cache.getEtag(lastModified, lang));
        }
    }

    private boolean isNotModified(ContentCache cache, long lastModified, CachableHttpServletResponse response, WebInvocationImpl invocation, ContentCacheContext cc, String lang) {
        long ifModifiedSince = invocation.getRequestStack().getRequest().getDateHeader("If-Modified-Since");
        String ifNoneMatch = invocation.getRequestStack().getRequest().getHeader("If-None-Match");
        if (ifModifiedSince < 0L && ifNoneMatch == null) {
            return false;
        }
        boolean isNotModified = true;
        if (ifModifiedSince >= 0L) {
            boolean bl = isNotModified = lastModified <= ifModifiedSince + 1000L;
        }
        if (isNotModified && ifNoneMatch != null) {
            String etag = cache.getEtag(lastModified, lang);
            boolean conditionSatisfied = false;
            if (!ifNoneMatch.equals("*")) {
                StringTokenizer commaTokenizer = new StringTokenizer(ifNoneMatch, ",");
                while (!conditionSatisfied && commaTokenizer.hasMoreTokens()) {
                    String currentToken = commaTokenizer.nextToken();
                    if (!currentToken.trim().equals(etag)) continue;
                    conditionSatisfied = true;
                }
            } else {
                conditionSatisfied = true;
            }
            isNotModified = conditionSatisfied ? ("GET".equals(invocation.getRequestStack().getRequest().getMethod()) || "HEAD".equals(invocation.getRequestStack().getRequest().getMethod()) ? (isNotModified &= true) : (isNotModified &= false)) : (isNotModified &= false);
        }
        return isNotModified;
    }

    private void doLayout(CachableHttpServletResponse response, WebInvocationImpl invocation, MetaActionMapping.ActionMappingRuntime amr) throws ServletException, IOException {
        ContentCache prevCc = response.getCurrentContentCache();
        if (prevCc != null) {
            prevCc.setLayoutActionName(invocation.getActionName());
        }
        invocation.getRequestStack().setAttribute("org.iplass.mtp.contentCache", prevCc);
        response.setCurrentContentCache(null);
        this.doDirect(response, invocation, amr, false);
        response.setCurrentContentCache(prevCc);
    }

    private void doInclude(CachableHttpServletResponse response, WebInvocationImpl invocation, MetaActionMapping.ActionMappingRuntime amr) throws ServletException, IOException {
        response.flushToContentCache();
        ContentCache prevCc = response.getCurrentContentCache();
        if (prevCc != null) {
            prevCc.addContent(new IncludeActionBlock(invocation.getActionName()));
        }
        this.doDirect(response, invocation, amr, false);
        response.setCurrentContentCache(prevCc);
    }
}

