/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.i18n;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.SessionContext;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.i18n.I18nService;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.TenantI18nInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LangSelector {
    private static Logger logger = LoggerFactory.getLogger(LangSelector.class);
    public static final String LANG_ATTRIBUTE_NAME = "language";
    private I18nService i18n = (I18nService)ServiceRegistry.getRegistry().getService(I18nService.class);

    public void selectLangByUser(RequestContext reqContext, ExecuteContext exec) {
        User user;
        String ulang;
        String lang = null;
        TenantI18nInfo i18n = (TenantI18nInfo)exec.getCurrentTenant().getTenantConfig(TenantI18nInfo.class);
        if (i18n.isUseMultilingual() && i18n.getUseLanguageList() != null && (ulang = (user = AuthContext.getCurrentContext().getUser()).getLanguage()) != null) {
            for (String tl : i18n.getUseLanguageList()) {
                if (!ulang.equals(tl)) continue;
                lang = ulang;
                break;
            }
        }
        if (lang != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("set lang by user to " + lang);
            }
            exec.setLanguage(lang);
        }
    }

    public void selectLangByRequest(RequestContext reqContext, ExecuteContext exec) {
        SessionContext sc = reqContext.getSession(false);
        String lang = null;
        if (sc != null) {
            lang = (String)sc.getAttribute(LANG_ATTRIBUTE_NAME);
        }
        if (lang == null) {
            lang = this.getLangFromHeader(WebRequestStack.getCurrent().getRequest(), exec);
        }
        if (lang != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("set lang by request to " + lang);
            }
            exec.setLanguage(lang);
        }
    }

    private String getLangFromHeader(HttpServletRequest req, ExecuteContext ec) {
        TenantI18nInfo i18n = (TenantI18nInfo)ec.getCurrentTenant().getTenantConfig(TenantI18nInfo.class);
        if (!i18n.isUseMultilingual()) {
            return null;
        }
        List langList = i18n.getUseLanguageList();
        Enumeration ls = req.getLocales();
        while (ls.hasMoreElements()) {
            Locale l = (Locale)ls.nextElement();
            String lang = this.mapLang(l.toLanguageTag());
            if (!langList.contains(lang)) continue;
            return lang;
        }
        return null;
    }

    private String mapLang(String lang) {
        String mapped = this.i18n.toValidLanguageTag(lang);
        if (mapped == null) {
            return lang;
        }
        return mapped;
    }
}

