/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.fileupload;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload2.core.FileItemInput;
import org.apache.commons.fileupload2.core.FileItemInputIterator;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.iplass.mtp.command.UploadFileHandle;
import org.iplass.mtp.impl.web.ParameterValueMap;
import org.iplass.mtp.impl.web.RequestParameterCountLimitException;
import org.iplass.mtp.impl.web.WebFrontendService;
import org.iplass.mtp.impl.web.WebProcessRuntimeException;
import org.iplass.mtp.impl.web.fileupload.UploadFileHandleImpl;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiPartParameterValueMap
implements ParameterValueMap {
    private static final Logger logger = LoggerFactory.getLogger(MultiPartParameterValueMap.class);
    private List<UploadFileHandleImpl> tempFiles;
    protected Map<String, Object> valueMap;
    private boolean init;
    private ServletContext servletContext;
    private HttpServletRequest req;
    private long maxFileSize = -1L;
    private long maxParameterCount;

    public MultiPartParameterValueMap(ServletContext servletContext, HttpServletRequest req) {
        this.servletContext = servletContext;
        this.req = req;
        this.maxParameterCount = ((WebFrontendService)ServiceRegistry.getRegistry().getService(WebFrontendService.class)).getMaxMultipartParameterCount();
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init() {
        if (this.init) {
            return;
        }
        this.init = true;
        long start = 0L;
        if (logger.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        this.valueMap = new HashMap<String, Object>();
        this.tempFiles = new ArrayList<UploadFileHandleImpl>();
        JakartaServletFileUpload upload = new JakartaServletFileUpload();
        try {
            FileItemInputIterator iter = upload.getItemIterator(this.req);
            long parameterCount = 0L;
            while (iter.hasNext()) {
                if (parameterCount == this.maxParameterCount) {
                    throw new RequestParameterCountLimitException("Multipart request parameters exceeds the limit. limit: " + this.maxParameterCount);
                }
                FileItemInput item = iter.next();
                String name = item.getFieldName();
                if (item.isFormField()) {
                    value = IOUtils.toString((InputStream)item.getInputStream(), (Charset)StandardCharsets.UTF_8);
                    oldValue = this.valueMap.get(name);
                    if (oldValue == null) {
                        this.valueMap.put(name, new String[]{value});
                    } else {
                        if (!(oldValue instanceof String[])) throw new WebProcessRuntimeException(name + " is alerady used as file upload field name.");
                        newValue = new String[((String[])oldValue).length + 1];
                        System.arraycopy(oldValue, 0, newValue, 0, newValue.length - 1);
                        newValue[newValue.length - 1] = value;
                        this.valueMap.put(name, newValue);
                    }
                } else {
                    value = UploadFileHandleImpl.toUploadFileHandle(item.getInputStream(), item.getName(), item.getContentType(), this.servletContext, this.maxFileSize);
                    if (value != null) {
                        this.tempFiles.add((UploadFileHandleImpl)value);
                        oldValue = this.valueMap.get(name);
                        if (oldValue == null) {
                            this.valueMap.put(name, new UploadFileHandle[]{value});
                        } else {
                            if (!(oldValue instanceof UploadFileHandle[])) throw new WebProcessRuntimeException(name + " is alerady used as form field name.");
                            newValue = new UploadFileHandle[((UploadFileHandle[])oldValue).length + 1];
                            System.arraycopy(oldValue, 0, newValue, 0, newValue.length - 1);
                            newValue[newValue.length - 1] = value;
                            this.valueMap.put(name, newValue);
                        }
                    }
                }
                ++parameterCount;
            }
        }
        catch (IOException e) {
            this.cleanTempResource();
            throw new WebProcessRuntimeException(e);
        }
        catch (Error | RuntimeException e) {
            this.cleanTempResource();
            throw e;
        }
        this.valueMap = Collections.unmodifiableMap(this.valueMap);
        if (!logger.isDebugEnabled()) return;
        logger.debug("MultiPartRequest parsed. time:" + (System.currentTimeMillis() - start));
    }

    @Override
    public void cleanTempResource() {
        if (this.tempFiles != null) {
            for (UploadFileHandleImpl f : this.tempFiles) {
                f.deleteTempFile();
            }
        }
    }

    @Override
    public Map<String, Object> getParamMap() {
        this.init();
        return this.valueMap;
    }

    @Override
    public Iterator<String> getParamNames() {
        this.init();
        return this.valueMap.keySet().iterator();
    }

    @Override
    public Object getParam(String name) {
        this.init();
        Object val = this.valueMap.get(name);
        if (val instanceof Object[]) {
            return ((Object[])val)[0];
        }
        return val;
    }

    @Override
    public Object[] getParams(String name) {
        this.init();
        Object val = this.valueMap.get(name);
        if (val instanceof String) {
            return new String[]{(String)val};
        }
        if (val instanceof UploadFileHandle) {
            return new UploadFileHandle[]{(UploadFileHandle)val};
        }
        return (Object[])val;
    }
}

