/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.fileupload;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.impl.util.CoreResourceBundleUtil;
import org.iplass.mtp.impl.web.fileupload.MagicByteChecker;
import org.iplass.mtp.impl.web.fileupload.MagicByteRule;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMagicByteChecker
implements MagicByteChecker {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMagicByteChecker.class);
    private List<MagicByteRule> magicByteRule;

    public List<MagicByteRule> getMagicByteRule() {
        return this.magicByteRule;
    }

    public void setMagicByteRule(List<MagicByteRule> magicByteRule) {
        this.magicByteRule = magicByteRule;
    }

    @Override
    public void checkMagicByte(File tempFile, String contentType, String fileName) {
        byte[] magicByte;
        String extension = StringUtil.substringAfterLast((String)fileName, (String)".");
        int index = contentType.indexOf(59);
        String mimeType = index < 0 ? contentType : contentType.substring(0, index);
        if (!this.isCorrectMagicByte(mimeType, extension, magicByte = DefaultMagicByteChecker.readMagicByte(tempFile))) {
            throw new ApplicationException(DefaultMagicByteChecker.resourceString("impl.web.fileupload.UploadFileHandleImpl.invalidFileMsg", null));
        }
    }

    private boolean isCorrectMagicByte(String mimeType, String extension, byte[] magicByte) {
        if (this.magicByteRule == null) {
            return true;
        }
        for (MagicByteRule rule : this.magicByteRule) {
            if (!rule.matchMimeType(mimeType) || !rule.matchExtension(extension)) continue;
            return rule.matchMagicByte(magicByte);
        }
        return true;
    }

    private static byte[] readMagicByte(File tempFile) {
        byte[] buf = new byte[128];
        try (FileInputStream is = new FileInputStream(tempFile);){
            ((InputStream)is).read(buf);
        }
        catch (IOException e) {
            logger.warn("upload file is externally deleted. maybe contains virus.", (Throwable)e);
        }
        return buf;
    }

    private static String resourceString(String key, Object ... arguments) {
        return CoreResourceBundleUtil.resourceString((String)key, (Object[])arguments);
    }
}

