/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.actionmapping.cache.blocks;

import jakarta.servlet.ServletException;
import java.io.IOException;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.WebUtil;
import org.iplass.mtp.impl.web.actionmapping.ActionMappingService;
import org.iplass.mtp.impl.web.actionmapping.MetaActionMapping;
import org.iplass.mtp.impl.web.actionmapping.WebInvocationImpl;
import org.iplass.mtp.impl.web.actionmapping.cache.ContentBlock;
import org.iplass.mtp.impl.web.actionmapping.cache.ContentCache;
import org.iplass.mtp.impl.web.actionmapping.cache.ContentCacheContext;
import org.iplass.mtp.impl.web.actionmapping.cache.MetaCacheCriteria;
import org.iplass.mtp.spi.ServiceRegistry;

public class IncludeActionBlock
implements ContentBlock {
    private static final long serialVersionUID = -894755257590110956L;
    private final String actionName;

    public IncludeActionBlock(String actionName) {
        this.actionName = actionName;
    }

    public String getActionName() {
        return this.actionName;
    }

    @Override
    public void writeTo(WebRequestStack request) throws IOException, ServletException {
        WebUtil.include(this.actionName, request.getRequest(), request.getResponse(), request.getServletContext(), request.getPageContext());
    }

    @Override
    public long lastModified(long lastModified, WebInvocationImpl invocation, ContentCacheContext cc, String lang) {
        MetaActionMapping.ActionMappingRuntime amr = (MetaActionMapping.ActionMappingRuntime)((ActionMappingService)ServiceRegistry.getRegistry().getService(ActionMappingService.class)).getRuntimeByName(this.actionName);
        if (amr == null) {
            return Long.MAX_VALUE;
        }
        MetaCacheCriteria.CacheCriteriaRuntime ccr = amr.getCacheCriteria();
        if (ccr == null) {
            return Long.MAX_VALUE;
        }
        String key = ccr.createContentCacheKey(invocation.getRequest());
        ContentCache incCache = cc.get(this.actionName, lang, key);
        if (incCache == null) {
            return Long.MAX_VALUE;
        }
        long incLastMod = incCache.getLastModified(invocation, cc, lang);
        if (lastModified > incLastMod) {
            return lastModified;
        }
        return incLastMod;
    }
}

