/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.actionmapping.cache;

import jakarta.xml.bind.annotation.XmlSeeAlso;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.web.actionmapping.MetaActionMapping;
import org.iplass.mtp.impl.web.actionmapping.WebInvocationImpl;
import org.iplass.mtp.impl.web.actionmapping.cache.MetaCacheRelatedEntity;
import org.iplass.mtp.impl.web.actionmapping.cache.MetaJavaClassCacheCriteria;
import org.iplass.mtp.impl.web.actionmapping.cache.MetaParameterMatchCacheCriteria;
import org.iplass.mtp.impl.web.actionmapping.cache.MetaScriptingCacheCriteria;
import org.iplass.mtp.web.actionmapping.definition.cache.CacheCriteriaDefinition;
import org.iplass.mtp.web.actionmapping.definition.cache.CacheRelatedEntityDefinition;
import org.iplass.mtp.web.actionmapping.definition.cache.JavaClassCacheCriteriaDefinition;
import org.iplass.mtp.web.actionmapping.definition.cache.ParameterMatchCacheCriteriaDefinition;
import org.iplass.mtp.web.actionmapping.definition.cache.RelatedEntityType;
import org.iplass.mtp.web.actionmapping.definition.cache.ScriptingCacheCriteriaDefinition;

@XmlSeeAlso(value={MetaJavaClassCacheCriteria.class, MetaParameterMatchCacheCriteria.class, MetaScriptingCacheCriteria.class})
public abstract class MetaCacheCriteria
implements MetaData {
    private static final long serialVersionUID = -4394764286765456178L;
    private List<String> cachableCommandResultStatus;
    private List<MetaCacheRelatedEntity> relatedEntity;
    private Integer timeToLive;

    public List<String> getCachableCommandResultStatus() {
        return this.cachableCommandResultStatus;
    }

    public void setCachableCommandResultStatus(List<String> cachableCommandResultStatus) {
        this.cachableCommandResultStatus = cachableCommandResultStatus;
    }

    public List<MetaCacheRelatedEntity> getRelatedEntity() {
        return this.relatedEntity;
    }

    public void setRelatedEntity(List<MetaCacheRelatedEntity> relatedEntity) {
        this.relatedEntity = relatedEntity;
    }

    public Integer getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(Integer timeToLive) {
        this.timeToLive = timeToLive;
    }

    public static MetaCacheCriteria createInstance(CacheCriteriaDefinition definition) {
        if (definition instanceof JavaClassCacheCriteriaDefinition) {
            return new MetaJavaClassCacheCriteria();
        }
        if (definition instanceof ParameterMatchCacheCriteriaDefinition) {
            return new MetaParameterMatchCacheCriteria();
        }
        if (definition instanceof ScriptingCacheCriteriaDefinition) {
            return new MetaScriptingCacheCriteria();
        }
        return null;
    }

    public abstract void applyConfig(CacheCriteriaDefinition var1);

    public abstract CacheCriteriaDefinition currentConfig();

    protected void fillFrom(CacheCriteriaDefinition definition) {
        if (definition.getCachableCommandResultStatus() != null) {
            this.cachableCommandResultStatus = new ArrayList<String>();
            this.cachableCommandResultStatus.addAll(definition.getCachableCommandResultStatus());
        } else {
            this.cachableCommandResultStatus = null;
        }
        if (definition.getRelatedEntity() != null) {
            this.relatedEntity = new ArrayList<MetaCacheRelatedEntity>();
            for (CacheRelatedEntityDefinition def : definition.getRelatedEntity()) {
                MetaCacheRelatedEntity meta = new MetaCacheRelatedEntity();
                meta.applyConfig(def);
                this.relatedEntity.add(meta);
            }
        } else {
            this.relatedEntity = null;
        }
        this.timeToLive = definition.getTimeToLive();
    }

    protected void fillTo(CacheCriteriaDefinition definition) {
        if (this.cachableCommandResultStatus != null) {
            ArrayList<String> statuses = new ArrayList<String>();
            statuses.addAll(this.cachableCommandResultStatus);
            definition.setCachableCommandResultStatus(statuses);
        }
        if (this.relatedEntity != null) {
            ArrayList<CacheRelatedEntityDefinition> entities = new ArrayList<CacheRelatedEntityDefinition>();
            for (MetaCacheRelatedEntity value : this.relatedEntity) {
                entities.add(value.currentConfig());
            }
            definition.setRelatedEntity(entities);
        }
        definition.setTimeToLive(this.timeToLive);
    }

    public MetaCacheCriteria copy() {
        return (MetaCacheCriteria)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    public abstract CacheCriteriaRuntime createRuntime(MetaActionMapping var1);

    public abstract class CacheCriteriaRuntime {
        private boolean isAllOkCommandStatus = false;
        private boolean isTargetAllEntity = false;
        private RelatedEntityType targetAllEntityType;

        public CacheCriteriaRuntime() {
            if (MetaCacheCriteria.this.cachableCommandResultStatus == null) {
                this.isAllOkCommandStatus = true;
            } else {
                for (String s : MetaCacheCriteria.this.cachableCommandResultStatus) {
                    if (!"*".equals(s)) continue;
                    this.isAllOkCommandStatus = true;
                    break;
                }
            }
            if (MetaCacheCriteria.this.relatedEntity != null) {
                for (MetaCacheRelatedEntity cre : MetaCacheCriteria.this.relatedEntity) {
                    if (!"*".equals(cre.getDefinitionName())) continue;
                    this.isTargetAllEntity = true;
                    this.targetAllEntityType = cre.getType();
                    break;
                }
            }
        }

        public MetaCacheCriteria getMetaData() {
            return MetaCacheCriteria.this;
        }

        public abstract String createContentCacheKey(RequestContext var1);

        public RelatedEntityType checkRelatedEntity(String entityName) {
            if (this.isTargetAllEntity) {
                return this.targetAllEntityType;
            }
            if (MetaCacheCriteria.this.relatedEntity != null) {
                for (MetaCacheRelatedEntity re : MetaCacheCriteria.this.relatedEntity) {
                    if (!entityName.equals(re.getDefinitionName())) continue;
                    return re.getType();
                }
            }
            return null;
        }

        public boolean canCache(WebInvocationImpl webInvocation) {
            if (this.isAllOkCommandStatus) {
                return true;
            }
            for (String s : MetaCacheCriteria.this.cachableCommandResultStatus) {
                if (!s.equals(webInvocation.getStatus())) continue;
                return true;
            }
            return false;
        }
    }
}

