/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.actionmapping;

import java.io.Serializable;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.metadata.MetaDataRuntimeException;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.util.KeyGenerator;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.web.actionmapping.VariableParameterValueMap;
import org.iplass.mtp.web.actionmapping.definition.ParamMapDefinition;

public class ParamMap
implements MetaData {
    private static final long serialVersionUID = 7897422706786772704L;
    private static final String SCRIPT_PREFIX = "ParamMap_condition";
    private String name;
    private String mapFrom;
    private String condition;

    public ParamMap() {
    }

    public ParamMap(String name, String mapFrom) {
        this.name = name;
        this.mapFrom = mapFrom;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMapFrom() {
        return this.mapFrom;
    }

    public void setMapFrom(String mapFrom) {
        this.mapFrom = mapFrom;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public void applyConfig(ParamMapDefinition definition) {
        this.name = definition.getName();
        this.mapFrom = definition.getMapFrom();
        this.condition = definition.getCondition();
    }

    public ParamMapDefinition currentConfig() {
        ParamMapDefinition definition = new ParamMapDefinition();
        definition.setName(this.name);
        definition.setMapFrom(this.mapFrom);
        definition.setCondition(this.condition);
        return definition;
    }

    public MetaData copy() {
        return (MetaData)ObjectUtil.deepCopy((Serializable)((Object)this));
    }

    public ParamMapRuntime createRuntime() {
        return new ParamMapRuntime();
    }

    public class ParamMapRuntime {
        private Script conditionScript;
        private MapType type;
        private int depth;

        ParamMapRuntime() {
            if (ParamMap.this.condition != null && !ParamMap.this.condition.isEmpty()) {
                TenantContext tc = ExecuteContext.getCurrentContext().getTenantContext();
                ScriptEngine ss = tc.getScriptEngine();
                KeyGenerator keyGen = new KeyGenerator();
                this.conditionScript = ss.createScript(ParamMap.this.condition, "ParamMap_condition_" + keyGen.generateId());
            }
            if (ParamMap.this.name == null) {
                throw new MetaDataRuntimeException("ParamMap's name must be specified.");
            }
            if (ParamMap.this.mapFrom == null) {
                throw new MetaDataRuntimeException("ParamMap's mapFrom must be specified.");
            }
            if (ParamMap.this.mapFrom.startsWith("{")) {
                this.type = MapType.FULL_PATH;
                this.depth = Integer.parseInt(ParamMap.this.mapFrom.substring(1, ParamMap.this.mapFrom.length() - 1).trim());
            } else if (ParamMap.this.mapFrom.startsWith("${")) {
                String val = ParamMap.this.mapFrom.substring(2, ParamMap.this.mapFrom.length() - 1).trim();
                if (val.startsWith("subPath[")) {
                    this.type = MapType.SUB_PATH;
                    this.depth = Integer.parseInt(val.substring(8, val.length() - 1).trim());
                } else if (val.startsWith("fullPath[")) {
                    this.type = MapType.FULL_PATH;
                    this.depth = Integer.parseInt(val.substring(9, val.length() - 1).trim());
                } else if ("paths".equals(val)) {
                    this.type = MapType.PATHS;
                } else {
                    this.type = MapType.SUB_PATH;
                    this.depth = Integer.parseInt(val.trim());
                }
            } else {
                this.type = MapType.PARAM_ALIAS;
            }
        }

        public ParamMap getMetaData() {
            return ParamMap.this;
        }

        public boolean isTarget(VariableParameterValueMap paramValueMap) {
            if (this.conditionScript == null) {
                return true;
            }
            TenantContext tc = ExecuteContext.getCurrentContext().getTenantContext();
            ScriptEngine ss = tc.getScriptEngine();
            ScriptContext sc = ss.newScriptContext();
            sc.setAttribute("subPath", (Object)paramValueMap.getSubPaths());
            sc.setAttribute("fullPath", (Object)paramValueMap.getFullPaths());
            sc.setAttribute("paramMap", paramValueMap.getWrapped().getParamMap());
            Boolean ret = (Boolean)this.conditionScript.eval(sc);
            return ret != null && ret != false;
        }

        public Object getParam(VariableParameterValueMap paramValueMap) {
            switch (this.type.ordinal()) {
                case 0: {
                    return paramValueMap.getWrapped().getParam(ParamMap.this.mapFrom);
                }
                case 1: {
                    String[] fullPaths = paramValueMap.getFullPaths();
                    if (fullPaths.length > this.depth) {
                        return fullPaths[this.depth];
                    }
                    return null;
                }
                case 2: {
                    String[] subPaths = paramValueMap.getSubPaths();
                    if (subPaths.length > this.depth) {
                        return subPaths[this.depth];
                    }
                    return null;
                }
                case 3: {
                    return paramValueMap.getSubPath();
                }
            }
            return null;
        }

        public Object[] getParams(VariableParameterValueMap paramValueMap) {
            switch (this.type.ordinal()) {
                case 0: {
                    return paramValueMap.getWrapped().getParams(ParamMap.this.mapFrom);
                }
                case 1: {
                    String[] fullPaths = paramValueMap.getFullPaths();
                    if (fullPaths.length > this.depth) {
                        return new String[]{fullPaths[this.depth]};
                    }
                    return null;
                }
                case 2: {
                    String[] subPaths = paramValueMap.getSubPaths();
                    if (subPaths.length > this.depth) {
                        return new String[]{subPaths[this.depth]};
                    }
                    return null;
                }
                case 3: {
                    String paths = paramValueMap.getSubPath();
                    if (paths != null) {
                        return new String[]{paths};
                    }
                    return null;
                }
            }
            return null;
        }
    }

    private static enum MapType {
        PARAM_ALIAS,
        FULL_PATH,
        SUB_PATH,
        PATHS;

    }
}

