/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.actionmapping;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;

class NoBodyResponse
extends HttpServletResponseWrapper {
    private NoBodyOutputStream noBody = new NoBodyOutputStream(this);
    private PrintWriter writer;
    private boolean didSetContentLength;

    NoBodyResponse(HttpServletResponse r) {
        super(r);
    }

    void setContentLength() {
        if (!this.didSetContentLength) {
            super.setContentLength(this.noBody.getContentLength());
        }
    }

    public void setContentLength(int len) {
        super.setContentLength(len);
        this.didSetContentLength = true;
    }

    public void setHeader(String name, String value) {
        super.setHeader(name, value);
        this.checkHeader(name);
    }

    public void addHeader(String name, String value) {
        super.addHeader(name, value);
        this.checkHeader(name);
    }

    public void setIntHeader(String name, int value) {
        super.setIntHeader(name, value);
        this.checkHeader(name);
    }

    public void addIntHeader(String name, int value) {
        super.addIntHeader(name, value);
        this.checkHeader(name);
    }

    private void checkHeader(String name) {
        if ("content-length".equalsIgnoreCase(name)) {
            this.didSetContentLength = true;
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.noBody;
    }

    public PrintWriter getWriter() throws UnsupportedEncodingException {
        if (this.writer == null) {
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)((Object)this.noBody), this.getCharacterEncoding());
            this.writer = new PrintWriter(w);
        }
        return this.writer;
    }

    class NoBodyOutputStream
    extends ServletOutputStream {
        private int contentLength = 0;

        NoBodyOutputStream(NoBodyResponse this$0) {
        }

        int getContentLength() {
            return this.contentLength;
        }

        public void write(int b) {
            ++this.contentLength;
        }

        public synchronized void write(byte[] buf, int offset, int len) throws IOException {
            if (buf == null) {
                throw new NullPointerException("buf is null");
            }
            if (offset < 0 || len < 0 || offset + len > buf.length) {
                String msg = "index out of bounds: offset={0}, len={1}, buf.length={2}";
                Object[] msgArgs = new Object[]{offset, len, buf.length};
                msg = MessageFormat.format(msg, msgArgs);
                throw new IndexOutOfBoundsException(msg);
            }
            this.contentLength += len;
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }
}

