/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.jsp.PageContext;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.Permission;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.RequestContextWrapper;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.web.ContentDispositionPolicy;
import org.iplass.mtp.impl.web.RequestPath;
import org.iplass.mtp.impl.web.WebFrontendService;
import org.iplass.mtp.impl.web.WebProcessRuntimeException;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.actionmapping.ActionMappingService;
import org.iplass.mtp.impl.web.actionmapping.MetaActionMapping;
import org.iplass.mtp.impl.web.actionmapping.cache.CachableHttpServletResponse;
import org.iplass.mtp.impl.web.actionmapping.cache.ContentCache;
import org.iplass.mtp.impl.web.actionmapping.cache.blocks.RenderContentBlock;
import org.iplass.mtp.impl.web.template.MetaTemplate;
import org.iplass.mtp.impl.web.template.TemplateService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tenant.web.TenantWebInfo;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.web.actionmapping.definition.result.ContentDispositionType;
import org.iplass.mtp.web.actionmapping.permission.ActionPermission;
import org.iplass.mtp.web.actionmapping.permission.RequestContextActionParameter;
import org.iplass.mtp.web.template.TemplateUtil;

public class WebUtil {
    private WebUtil() {
    }

    public static boolean needTrustedLogin(String requestPath) {
        WebFrontendService webFrontendService;
        ActionMappingService amService;
        MetaActionMapping.ActionMappingRuntime actionMapping;
        String tenantContextPath = TemplateUtil.getTenantContextPath();
        String actionPath = requestPath.substring(tenantContextPath.length() + 1);
        int i = actionPath.indexOf(63);
        if (i >= 0) {
            actionPath = actionPath.substring(0, i);
        }
        return (actionMapping = (amService = (ActionMappingService)ServiceRegistry.getRegistry().getService(ActionMappingService.class)).getByPathHierarchy(actionPath, (webFrontendService = (WebFrontendService)ServiceRegistry.getRegistry().getService(WebFrontendService.class)).getWelcomeAction())) != null && actionMapping.getMetaData().isNeedTrustedAuthenticate();
    }

    public static boolean isValidInternalUrl(String url) {
        if (StringUtil.startsWithAny((String)StringUtil.lowerCase((String)url), (String[])new String[]{"http:", "https:", "//", "/\\", "/\t", "\\\\"})) {
            return false;
        }
        try {
            URI uri = new URI(url);
            if (uri.getHost() == null) {
                return true;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return false;
    }

    public static RequestContext getRequestContext() {
        WebRequestStack src = WebRequestStack.getCurrent();
        if (src != null) {
            return src.getRequestContext();
        }
        return null;
    }

    public static void includeTemplate(String templateName, HttpServletRequest req, HttpServletResponse resp, ServletContext context, PageContext page) throws IOException, ServletException {
        WebUtil.includeTemplate(templateName, req, resp, context, page, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void includeTemplate(String templateName, HttpServletRequest req, HttpServletResponse resp, ServletContext context, PageContext page, RequestContextWrapper requestContext) throws IOException, ServletException {
        WebRequestStack src = new WebRequestStack((RequestContext)requestContext, context, req, resp, page);
        src.setIncludeTemplateStack(true);
        try {
            TemplateService tmplService = (TemplateService)ServiceRegistry.getRegistry().getService(TemplateService.class);
            MetaTemplate.TemplateRuntime tmpl = (MetaTemplate.TemplateRuntime)tmplService.getRuntimeByName(templateName);
            if (tmpl != null) {
                tmpl.handle(src);
            } else {
                new WebProcessRuntimeException("template:" + templateName + " not defined.");
            }
        }
        finally {
            src.finallyProcess();
        }
    }

    public static void include(String actionName, HttpServletRequest req, HttpServletResponse resp, ServletContext context, PageContext page) throws IOException, ServletException {
        WebUtil.include(actionName, req, resp, context, page, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void include(String actionName, HttpServletRequest req, HttpServletResponse resp, ServletContext context, PageContext page, RequestContextWrapper requestContext) throws IOException, ServletException {
        if (page != null) {
            page.getOut().flush();
        }
        WebRequestStack current = WebRequestStack.getCurrent();
        RequestContext reqContext = current.getRequestContext();
        ActionMappingService amService = (ActionMappingService)ServiceRegistry.getRegistry().getService(ActionMappingService.class);
        MetaActionMapping.ActionMappingRuntime am = amService.getByPathHierarchy(actionName);
        if (am == null) {
            new WebProcessRuntimeException("path:" + actionName + " not defined.");
        }
        if (!am.getMetaData().isPublicAction() && !AuthContext.getCurrentContext().checkPermission((Permission)new ActionPermission(actionName, new RequestContextActionParameter(reqContext)))) {
            throw new SecurityException(actionName + "\u306e\u5b9f\u884c\u6a29\u9650\u304c\u3042\u308a\u307e\u305b\u3093");
        }
        WebRequestStack src = new WebRequestStack(new RequestPath(actionName, current.getRequestPath()), (RequestContext)requestContext, context, req, resp, page);
        src.setIncludeStack(true);
        try {
            am.executeCommand(src);
        }
        finally {
            if (src != null) {
                src.finallyProcess();
            }
        }
        if (page != null) {
            page.getOut().flush();
        }
    }

    public static String getTenantContextPath(HttpServletRequest req) {
        String tenantPath;
        WebRequestStack reqStack = WebRequestStack.getCurrent();
        if (reqStack != null) {
            return reqStack.getRequestPath().getTenantContextPath(req);
        }
        Tenant tenant = ExecuteContext.getCurrentContext().getCurrentTenant();
        if (!WebUtil.isDirectAccess(req) && (tenantPath = WebUtil.getTenantWebInfo(tenant).getUrlForRequest()) != null) {
            if ("/".equals(tenantPath)) {
                return "";
            }
            return tenantPath;
        }
        String tenantUrl = tenant.getUrl();
        Object tenantContextPath = null;
        tenantContextPath = "/".equals(tenantUrl) ? req.getContextPath() : req.getContextPath() + tenantUrl;
        return tenantContextPath;
    }

    public static boolean isDirectAccess(HttpServletRequest req) {
        WebFrontendService ss = (WebFrontendService)ServiceRegistry.getRegistry().getService(WebFrontendService.class);
        if (ss.getDirectAccessPort() != null) {
            return ss.getDirectAccessPort().equals(String.valueOf(req.getServerPort()));
        }
        return false;
    }

    public static String getStaticContentPath() {
        WebRequestStack reqStack;
        String path = ((WebFrontendService)ServiceRegistry.getRegistry().getService(WebFrontendService.class)).getStaticContentPath();
        if (path == null && (reqStack = WebRequestStack.getCurrent()) != null) {
            path = reqStack.getRequest().getContextPath();
        }
        if (path == null) {
            path = "";
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderContent(HttpServletRequest req, HttpServletResponse resp, ServletContext context, PageContext page) throws IOException, ServletException {
        if (page != null) {
            page.getOut().flush();
        }
        WebRequestStack layoutStack = WebRequestStack.getCurrent();
        WebRequestStack contentsStack = layoutStack.getPrevStack();
        Object content = layoutStack.getAttribute("org.iplass.mtp.contentTemplate");
        if (content instanceof MetaTemplate.TemplateRuntime) {
            MetaTemplate.TemplateRuntime contentTemplate = (MetaTemplate.TemplateRuntime)((Object)content);
            CachableHttpServletResponse response = (CachableHttpServletResponse)((Object)layoutStack.getRequest().getAttribute("org.iplass.mtp.cachableHttpServletResponse"));
            boolean prevDoCache = false;
            ContentCache layoutContentCache = null;
            if (response != null) {
                ContentCache cc;
                response.flushToContentCache();
                prevDoCache = response.isDoCache();
                layoutContentCache = response.getCurrentContentCache();
                if (layoutContentCache != null) {
                    layoutContentCache.addContent(new RenderContentBlock());
                }
                if ((cc = (ContentCache)layoutStack.getAttribute("org.iplass.mtp.contentCache")) != null) {
                    response.setDoCache(true);
                } else {
                    response.setDoCache(false);
                }
                response.setCurrentContentCache(cc);
            }
            WebRequestStack src = new WebRequestStack(contentsStack.getRequestPath(), null, context, req, resp, page);
            src.shareStackAttributeContext(contentsStack);
            src.setRenderContentStack(true);
            try {
                contentTemplate.handleContent(src);
            }
            finally {
                if (src != null) {
                    src.finallyProcess();
                }
            }
            if (page != null) {
                page.getOut().flush();
            }
            if (response != null) {
                response.flushToContentCache();
                response.setDoCache(prevDoCache);
                response.setCurrentContentCache(layoutContentCache);
            }
        } else if (content instanceof ContentCache) {
            ContentCache cc = (ContentCache)content;
            WebRequestStack src = new WebRequestStack(contentsStack.getRequestPath(), null, context, req, resp, page);
            src.shareStackAttributeContext(contentsStack);
            src.setRenderContentStack(true);
            try {
                ContentCache ccc;
                CachableHttpServletResponse response = (CachableHttpServletResponse)((Object)layoutStack.getRequest().getAttribute("org.iplass.mtp.cachableHttpServletResponse"));
                boolean prevDoCache = response.isDoCache();
                ContentCache layoutContentCache = null;
                response.flushToContentCache();
                prevDoCache = response.isDoCache();
                layoutContentCache = response.getCurrentContentCache();
                if (layoutContentCache != null) {
                    layoutContentCache.addContent(new RenderContentBlock());
                }
                if ((ccc = (ContentCache)layoutStack.getAttribute("org.iplass.mtp.contentCache")) != null) {
                    response.setDoCache(true);
                } else {
                    response.setDoCache(false);
                }
                response.setCurrentContentCache(ccc);
                cc.writeContent(src);
                if (page != null) {
                    page.getOut().flush();
                }
                response.flushToContentCache();
                response.setDoCache(prevDoCache);
                response.setCurrentContentCache(layoutContentCache);
            }
            finally {
                if (src != null) {
                    src.finallyProcess();
                }
            }
        }
    }

    public static void setCacheControlHeader(WebRequestStack req, boolean cache, long maxAge) {
        WebUtil.setCacheControlHeader(req, cache, false, maxAge);
    }

    public static void setCacheControlHeader(WebRequestStack req, boolean cache, boolean shared, long maxAge) {
        if (req.isClientDirectRequest() && !req.getResponse().isCommitted()) {
            if (cache) {
                if (maxAge < 0L) {
                    if (shared) {
                        req.getResponse().setHeader("Cache-Control", "public");
                    } else {
                        req.getResponse().setHeader("Cache-Control", "private");
                    }
                } else if (shared) {
                    req.getResponse().setHeader("Cache-Control", "public, max-age=" + maxAge);
                } else {
                    req.getResponse().setHeader("Cache-Control", "private, max-age=" + maxAge);
                }
            } else {
                req.getResponse().setHeader("Cache-Control", "private, no-store, no-cache, must-revalidate");
                if ("HTTP/1.0".equals(req.getRequest().getProtocol())) {
                    req.getResponse().setHeader("Pragma", "no-cache");
                }
            }
        }
    }

    public static void setContentDispositionHeader(WebRequestStack req, ContentDispositionType type, String fileName) throws IOException {
        WebUtil.setContentDispositionHeader(req.getRequest(), req.getResponse(), type, fileName);
    }

    public static void setContentDispositionHeader(HttpServletRequest req, HttpServletResponse resp, ContentDispositionType type, String fileName) throws IOException {
        String userAgent = req.getHeader("User-Agent");
        boolean noPoricy = true;
        boolean isMatch = false;
        if (userAgent != null) {
            WebFrontendService wfeService = (WebFrontendService)ServiceRegistry.getRegistry().getService(WebFrontendService.class);
            List<ContentDispositionPolicy> policies = wfeService.getContentDispositionPolicy();
            ContentDispositionPolicy defaultPolicy = null;
            if (policies != null) {
                noPoricy = false;
                for (ContentDispositionPolicy policy : policies) {
                    if (policy.isDefault()) {
                        defaultPolicy = policy;
                        continue;
                    }
                    if (!policy.match(userAgent, type)) continue;
                    isMatch = true;
                    resp.addHeader("Content-Disposition", StringUtil.removeLineFeedCode((String)policy.getContentDisposition(type, fileName)));
                    break;
                }
                if (!isMatch && defaultPolicy != null) {
                    isMatch = true;
                    resp.addHeader("Content-Disposition", StringUtil.removeLineFeedCode((String)defaultPolicy.getContentDisposition(type, fileName)));
                }
            }
        }
        if (noPoricy || !isMatch) {
            resp.addHeader("Content-Disposition", "attachment; " + StringUtil.removeLineFeedCode((String)fileName));
        }
    }

    public static TenantWebInfo getTenantWebInfo(Tenant tenant) {
        return tenant.getTenantConfig(TenantWebInfo.class) != null ? (TenantWebInfo)tenant.getTenantConfig(TenantWebInfo.class) : new TenantWebInfo();
    }
}

