/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.iplass.mtp.impl.web.ContentDispositionPolicy;
import org.iplass.mtp.impl.web.ErrorUrlSelector;
import org.iplass.mtp.impl.web.LoginUrlSelector;
import org.iplass.mtp.impl.web.RequestPath;
import org.iplass.mtp.impl.web.RequestRestriction;
import org.iplass.mtp.impl.web.fileupload.DefaultFileTypeDetector;
import org.iplass.mtp.impl.web.fileupload.FileScanner;
import org.iplass.mtp.impl.web.fileupload.FileTypeDetector;
import org.iplass.mtp.impl.web.fileupload.MagicByteChecker;
import org.iplass.mtp.impl.web.mdc.HttpHeaderMdcValueResolver;
import org.iplass.mtp.impl.web.mdc.MdcValueResolver;
import org.iplass.mtp.impl.web.mdc.RemoteAddrMdcValueResolver;
import org.iplass.mtp.impl.web.mdc.RemoteHostMdcValueResolver;
import org.iplass.mtp.impl.web.mdc.SessionIdMdcValueResolver;
import org.iplass.mtp.impl.web.mdc.UuidMdcValueResolver;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.iplass.mtp.web.actionmapping.definition.ClientCacheType;
import org.iplass.mtp.webapi.definition.CacheControlType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebFrontendService
implements Service {
    static final String MDC_VALUE_RESOLVER_UUID = "generateUuid";
    static final String MDC_VALUE_RESOLVER_INSECURE_UUID = "generateInsecureUuid";
    static final String MDC_VALUE_RESOLVER_REMOTE_HOST = "remoteHost";
    static final String MDC_VALUE_RESOLVER_REMOTE_ADDR = "remoteAddr";
    static final String MDC_VALUE_RESOLVER_HEADER_PREFIX = "header.";
    static final String MDC_VALUE_RESOLVER_SESSION_ID = "sessionId";
    private static final Long DEFAULT_MAX_MULTIPART_PARAMETER_COUNT = 10000L;
    private static Logger logger = LoggerFactory.getLogger(WebFrontendService.class);
    private String tempFileDir;
    private String staticContentPath;
    private String defaultContentType;
    private ClientCacheType defaultClientCacheType;
    private CacheControlType defaultCacheControlType;
    private Pattern excludePathes;
    private Pattern throughPathes;
    private List<String> restPath;
    private Pattern acceptPathes;
    private Pattern rejectPathes;
    private List<RequestRestriction> requestRestrictions;
    private RequestRestriction defaultRequestRestriction;
    private String logoutUrl;
    private ErrorUrlSelector errorUrlSelector;
    private LoginUrlSelector loginUrlSelector;
    private List<ContentDispositionPolicy> contentDispositionPolicies;
    private FileScanner uploadFileScanner;
    private FileTypeDetector uploadFileTypeDetector;
    private boolean isExecMagicByteCheck;
    private MagicByteChecker magicByteChecker;
    private String directAccessPort;
    private int transactionTokenMaxSize = 50;
    private List<String> welcomeAction;
    private boolean redirectAfterLogin = true;
    private boolean tenantAsDomain;
    private String fixedTenant;
    private long maxMultipartParameterCount;
    private Map<String, MdcValueResolver> mdc;

    public Map<String, MdcValueResolver> getMdc() {
        return this.mdc;
    }

    public boolean isAcceptPathes(String path) {
        boolean ret;
        boolean bl = ret = this.getAcceptPathes() == null || this.getAcceptPathes().matcher(path).matches();
        if (this.getRejectPathes() != null) {
            ret = ret && !this.getRejectPathes().matcher(path).matches();
        }
        return ret;
    }

    public boolean isExcludePath(String path) {
        return this.getExcluePathes() != null && this.getExcluePathes().matcher(path).matches();
    }

    public boolean isThroughPath(String path) {
        return this.getThroughPathes() != null && this.getThroughPathes().matcher(path).matches();
    }

    public boolean isRestPath(String path) {
        if (this.restPath != null) {
            for (String rp : this.restPath) {
                if (!path.startsWith(rp)) continue;
                return true;
            }
        }
        return false;
    }

    public Pattern getAcceptPathes() {
        return this.acceptPathes;
    }

    public Pattern getRejectPathes() {
        return this.rejectPathes;
    }

    public Pattern getThroughPathes() {
        return this.throughPathes;
    }

    public String getFixedTenant() {
        return this.fixedTenant;
    }

    public boolean isTenantAsDomain() {
        return this.tenantAsDomain;
    }

    public boolean isRedirectAfterLogin() {
        return this.redirectAfterLogin;
    }

    public List<String> getWelcomeAction() {
        return this.welcomeAction;
    }

    public int getTransactionTokenMaxSize() {
        return this.transactionTokenMaxSize;
    }

    public boolean isExecMagicByteCheck() {
        return this.isExecMagicByteCheck;
    }

    public MagicByteChecker getMagicByteChecker() {
        return this.magicByteChecker;
    }

    public FileScanner getUploadFileScanner() {
        return this.uploadFileScanner;
    }

    public FileTypeDetector getUploadFileTypeDetector() {
        return this.uploadFileTypeDetector;
    }

    public LoginUrlSelector getLoginUrlSelector() {
        return this.loginUrlSelector;
    }

    public ErrorUrlSelector getErrorUrlSelector() {
        return this.errorUrlSelector;
    }

    public String getTempFileDir() {
        return this.tempFileDir;
    }

    public String getStaticContentPath() {
        return this.staticContentPath;
    }

    public void destroy() {
    }

    public void init(Config config) {
        List throughPathList;
        List exclude;
        List reject;
        String defaultCacheControlType;
        this.tempFileDir = config.getValue("tempFileDir");
        if (this.tempFileDir != null) {
            File tFile = new File(this.tempFileDir);
            if (!tFile.exists()) {
                logger.debug("tempFileDir not exist:" + tFile.getAbsolutePath());
                try {
                    if (!tFile.mkdirs()) {
                        throw new ServiceConfigrationException("tempFileDir create failed:" + tFile.getAbsolutePath());
                    }
                    logger.info("create tempFileDir:" + tFile.getAbsolutePath());
                    tFile.setReadable(true, false);
                    tFile.setWritable(true, false);
                    tFile.setExecutable(true, false);
                }
                catch (SecurityException e) {
                    throw new ServiceConfigrationException("tempFileDir create failed:" + tFile.getAbsolutePath());
                }
            } else {
                logger.debug("tempFileDir is existed:" + tFile.getAbsolutePath());
            }
        } else {
            logger.debug("tempFileDir is undefined");
        }
        this.staticContentPath = config.getValue("staticContentPath");
        String defaultContentType = config.getValue("defaultContentType");
        if (defaultContentType == null) {
            defaultContentType = "text/html; charset=utf-8";
        }
        this.defaultContentType = defaultContentType;
        String defaultClientCacheType = config.getValue("defaultClientCacheType");
        if (defaultClientCacheType != null) {
            if (defaultClientCacheType.equals("NO_CACHE")) {
                this.defaultClientCacheType = ClientCacheType.NO_CACHE;
            } else if (defaultClientCacheType.equals("CACHE")) {
                this.defaultClientCacheType = ClientCacheType.CACHE;
            } else {
                throw new ServiceConfigrationException("defaultClientCacheType incorrect:" + defaultClientCacheType);
            }
        }
        if ((defaultCacheControlType = config.getValue("defaultCacheControlType")) != null) {
            if (defaultCacheControlType.equals("NO_CACHE")) {
                this.defaultCacheControlType = CacheControlType.NO_CACHE;
            } else if (defaultCacheControlType.equals("CACHE")) {
                this.defaultCacheControlType = CacheControlType.CACHE;
            } else {
                throw new ServiceConfigrationException("defaultCacheControlType incorrect:" + defaultCacheControlType);
            }
        }
        this.errorUrlSelector = (ErrorUrlSelector)config.getBean("errorUrlSelector");
        this.loginUrlSelector = (LoginUrlSelector)config.getBean("loginUrlSelector");
        List accept = config.getValues("acceptPath");
        if (accept != null && accept.size() > 0) {
            this.acceptPathes = Pattern.compile(String.join((CharSequence)"|", accept));
        }
        if ((reject = config.getValues("rejectPath")) != null && reject.size() > 0) {
            this.rejectPathes = Pattern.compile(String.join((CharSequence)"|", reject));
        }
        if ((exclude = config.getValues("excludePath")) != null && exclude.size() > 0) {
            this.excludePathes = Pattern.compile(String.join((CharSequence)"|", exclude));
        }
        if ((throughPathList = config.getValues("throughPath")) != null && throughPathList.size() > 0) {
            this.throughPathes = Pattern.compile(String.join((CharSequence)"|", throughPathList));
        }
        this.requestRestrictions = config.getValues("requestRestriction", RequestRestriction.class);
        if (this.requestRestrictions != null) {
            for (RequestRestriction rr : this.requestRestrictions) {
                if (rr.getPathPattern() != null) continue;
                this.defaultRequestRestriction = rr;
            }
        }
        if (this.defaultRequestRestriction == null) {
            this.defaultRequestRestriction = this.createDefaultRequestRestriction(config);
        }
        this.restPath = config.getValues("restPath");
        this.logoutUrl = config.getValue("logoutUrl");
        if (this.logoutUrl == null || this.logoutUrl.length() == 0) {
            throw new ServiceConfigrationException("logoutUrl is not set");
        }
        this.contentDispositionPolicies = config.getBeans("contentDispositionPolicy");
        this.uploadFileScanner = (FileScanner)config.getBean("uploadFileScanner");
        this.uploadFileTypeDetector = (FileTypeDetector)config.getValue("uploadFileTypeDetector", FileTypeDetector.class, (Object)new DefaultFileTypeDetector());
        this.isExecMagicByteCheck = Boolean.valueOf(config.getValue("isExecMagicByteCheck"));
        this.magicByteChecker = (MagicByteChecker)config.getValue("magicByteChecker", MagicByteChecker.class);
        this.directAccessPort = config.getValue("directAccessPort");
        if (config.getValue("transactionTokenMaxSize") != null) {
            this.transactionTokenMaxSize = Integer.parseInt(config.getValue("transactionTokenMaxSize"));
        }
        this.welcomeAction = config.getValues("welcomeAction");
        if (config.getValue("redirectAfterLogin") != null) {
            this.redirectAfterLogin = Boolean.valueOf(config.getValue("redirectAfterLogin"));
        }
        if (config.getValue("tenantAsDomain") != null) {
            this.tenantAsDomain = Boolean.valueOf(config.getValue("tenantAsDomain"));
        }
        this.fixedTenant = config.getValue("fixedTenant");
        this.maxMultipartParameterCount = (Long)config.getValue("maxMultipartParameterCount", Long.class, (Object)DEFAULT_MAX_MULTIPART_PARAMETER_COUNT);
        Map mdcFromConfig = (Map)config.getValue("mdc", Map.class);
        if (mdcFromConfig != null) {
            this.mdc = new HashMap<String, MdcValueResolver>();
            for (Map.Entry e : mdcFromConfig.entrySet()) {
                if (e.getValue() == null) continue;
                if (e.getValue() instanceof String) {
                    String valStr = (String)e.getValue();
                    if (MDC_VALUE_RESOLVER_UUID.equals(valStr)) {
                        this.mdc.put((String)e.getKey(), new UuidMdcValueResolver());
                        continue;
                    }
                    if (MDC_VALUE_RESOLVER_INSECURE_UUID.equals(valStr)) {
                        this.mdc.put((String)e.getKey(), new UuidMdcValueResolver(false));
                        continue;
                    }
                    if (MDC_VALUE_RESOLVER_REMOTE_HOST.equals(valStr)) {
                        this.mdc.put((String)e.getKey(), new RemoteHostMdcValueResolver());
                        continue;
                    }
                    if (MDC_VALUE_RESOLVER_REMOTE_ADDR.equals(valStr)) {
                        this.mdc.put((String)e.getKey(), new RemoteAddrMdcValueResolver());
                        continue;
                    }
                    if (valStr.startsWith(MDC_VALUE_RESOLVER_HEADER_PREFIX)) {
                        String headerName = valStr.substring(MDC_VALUE_RESOLVER_HEADER_PREFIX.length());
                        if (headerName.length() <= 0) continue;
                        this.mdc.put((String)e.getKey(), new HttpHeaderMdcValueResolver(headerName));
                        continue;
                    }
                    if (MDC_VALUE_RESOLVER_SESSION_ID.equals(valStr)) {
                        this.mdc.put((String)e.getKey(), new SessionIdMdcValueResolver());
                        continue;
                    }
                    throw new ServiceConfigrationException("unrecognized mdc value:" + valStr);
                }
                if (e.getValue() instanceof MdcValueResolver) {
                    this.mdc.put((String)e.getKey(), (MdcValueResolver)e.getValue());
                    continue;
                }
                throw new ServiceConfigrationException("unrecognized mdc value. String or MdcValueResolver can be set. :" + String.valueOf(e.getValue()));
            }
        }
    }

    private RequestRestriction createDefaultRequestRestriction(Config config) {
        RequestRestriction rr = new RequestRestriction();
        rr.setAllowMethods(Arrays.asList("*"));
        rr.setAllowContentTypes(Arrays.asList("*/*"));
        rr.setMaxFileSize((Long)config.getValue("maxUploadFileSize", Long.class, (Object)-1L));
        rr.inited(this, config);
        return rr;
    }

    public RequestRestriction getRequestRestriction(String metaDataName, RequestPath.PathType type) {
        String path = null;
        if (this.requestRestrictions != null) {
            switch (type) {
                case ACTION: {
                    path = "/" + metaDataName;
                    for (RequestRestriction rr : this.requestRestrictions) {
                        if (rr.getPathPattern() == null || !rr.getPathPatternCompile().matcher(path).matches()) continue;
                        return rr;
                    }
                    if (this.welcomeAction == null) break;
                    int slaIndex = path.lastIndexOf(47);
                    String shortName = slaIndex < 0 ? path : path.substring(slaIndex + 1);
                    for (String wa : this.welcomeAction) {
                        if (!wa.equals(shortName)) continue;
                        String remainPath = path.substring(0, slaIndex + 1);
                        for (RequestRestriction rr : this.requestRestrictions) {
                            if (rr.getPathPattern() == null || !rr.getPathPatternCompile().matcher(remainPath).matches()) continue;
                            return rr;
                        }
                    }
                    break;
                }
                case REST: {
                    for (String rp : this.restPath) {
                        path = rp + metaDataName;
                        for (RequestRestriction rr : this.requestRestrictions) {
                            if (rr.getPathPattern() == null || !rr.getPathPatternCompile().matcher(path).matches()) continue;
                            return rr;
                        }
                    }
                    break;
                }
            }
        }
        return this.defaultRequestRestriction;
    }

    public List<RequestRestriction> getRequestRestrictions() {
        return this.requestRestrictions;
    }

    public RequestRestriction getDefaultRequestRestriction() {
        return this.defaultRequestRestriction;
    }

    public String getDefaultContentType() {
        return this.defaultContentType;
    }

    public ClientCacheType getDefaultClientCacheType() {
        return this.defaultClientCacheType;
    }

    public CacheControlType getDefaultCacheControlType() {
        return this.defaultCacheControlType;
    }

    @Deprecated
    public long getMaxUploadFileSize() {
        return this.defaultRequestRestriction.getMaxFileSize();
    }

    public Pattern getExcluePathes() {
        return this.excludePathes;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public List<String> getRestPath() {
        return this.restPath;
    }

    public List<ContentDispositionPolicy> getContentDispositionPolicy() {
        return this.contentDispositionPolicies;
    }

    public String getDirectAccessPort() {
        return this.directAccessPort;
    }

    public long getMaxMultipartParameterCount() {
        return this.maxMultipartParameterCount;
    }
}

