/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.iplass.mtp.impl.web.RequestBodyTooLargeException;

public class LimitRequestBodyHttpServletRequest
extends HttpServletRequestWrapper {
    private long maxBodySize;

    public LimitRequestBodyHttpServletRequest(HttpServletRequest request, long maxBodySize) {
        super(request);
        this.maxBodySize = maxBodySize;
    }

    public ServletInputStream getInputStream() throws IOException {
        return new LimitRequestBodyServletInputStream(this.getRequest().getInputStream(), this.getContentLengthLong());
    }

    public BufferedReader getReader() throws IOException {
        String charset = this.getCharacterEncoding();
        if (charset == null) {
            charset = "utf-8";
        }
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), charset));
    }

    private class LimitRequestBodyServletInputStream
    extends ServletInputStream {
        private long count;
        private ServletInputStream actual;
        private boolean contentLengthOver;

        private LimitRequestBodyServletInputStream(ServletInputStream actual, long contentLength) {
            if (contentLength >= 0L && contentLength > LimitRequestBodyHttpServletRequest.this.maxBodySize) {
                this.contentLengthOver = true;
            }
            this.actual = actual;
        }

        public boolean isFinished() {
            return this.actual.isFinished();
        }

        public boolean isReady() {
            return this.actual.isReady();
        }

        public void setReadListener(ReadListener readListener) {
            this.actual.setReadListener(readListener);
        }

        public int read() throws IOException {
            this.checkContentLength();
            int i = this.actual.read();
            if (i >= 0) {
                this.countup(1);
            }
            return i;
        }

        public int read(byte[] b) throws IOException {
            this.checkContentLength();
            int i = this.actual.read(b);
            if (i >= 0) {
                this.countup(i);
            }
            return i;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            this.checkContentLength();
            int i = this.actual.read(b, off, len);
            if (i >= 0) {
                this.countup(i);
            }
            return i;
        }

        public int readLine(byte[] b, int off, int len) throws IOException {
            this.checkContentLength();
            int i = this.actual.readLine(b, off, len);
            if (i >= 0) {
                this.countup(i);
            }
            return i;
        }

        private void countup(int i) {
            this.count += (long)i;
            if (this.count > LimitRequestBodyHttpServletRequest.this.maxBodySize) {
                RequestBodyTooLargeException ex = new RequestBodyTooLargeException("Request body too large. MaxBodySize:" + LimitRequestBodyHttpServletRequest.this.maxBodySize);
                try {
                    this.actual.close();
                }
                catch (Exception e) {
                    ex.addSuppressed(e);
                }
                throw ex;
            }
        }

        private void checkContentLength() {
            if (this.contentLengthOver) {
                RequestBodyTooLargeException ex = new RequestBodyTooLargeException("Request body too large. MaxBodySize:" + LimitRequestBodyHttpServletRequest.this.maxBodySize);
                try {
                    this.actual.close();
                }
                catch (Exception e) {
                    ex.addSuppressed(e);
                }
                throw ex;
            }
        }
    }
}

