/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.rdb.connection.ResourceHolder;
import org.iplass.mtp.impl.web.LimitRequestBodyHttpServletRequest;
import org.iplass.mtp.impl.web.RequestBodyTooLargeException;
import org.iplass.mtp.impl.web.RequestPath;
import org.iplass.mtp.impl.web.WebFrontendService;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.WebUtil;
import org.iplass.mtp.impl.web.actionmapping.ActionMappingService;
import org.iplass.mtp.impl.web.actionmapping.MetaActionMapping;
import org.iplass.mtp.impl.web.mdc.MdcValueResolver;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherFilter
implements Filter {
    private static Logger logger = LoggerFactory.getLogger(DispatcherFilter.class);
    private static Logger fatalLogger = LoggerFactory.getLogger((String)"mtp.fatal");
    private TenantContextService tenantContextService;
    private ServletContext servletContext;
    private ActionMappingService amService;
    private WebFrontendService webFrontendService;

    public void destroy() {
    }

    public void init(FilterConfig config) throws ServletException {
        this.tenantContextService = (TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class);
        this.servletContext = config.getServletContext();
        this.amService = (ActionMappingService)ServiceRegistry.getRegistry().getService(ActionMappingService.class);
        this.webFrontendService = (WebFrontendService)ServiceRegistry.getRegistry().getService(WebFrontendService.class);
    }

    private void setMdc(HttpServletRequest req, ExecuteContext ec) {
        if (this.webFrontendService.getMdc() != null && !this.webFrontendService.getMdc().isEmpty()) {
            for (Map.Entry<String, MdcValueResolver> e : this.webFrontendService.getMdc().entrySet()) {
                String val = e.getValue().resolve(req);
                if (val == null) continue;
                ec.mdcPutWithoutLoggingContextReload(e.getKey(), val);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        RequestPath path = new RequestPath(req, this.webFrontendService);
        if (!path.isValid()) {
            res.sendError(404);
            return;
        }
        ResourceHolder.init();
        try {
            if (path.getPathType() == RequestPath.PathType.UNKNOWN) {
                if (logger.isTraceEnabled()) {
                    logger.trace("excluded URL:" + req.getRequestURI());
                }
                chain.doFilter((ServletRequest)req, (ServletResponse)res);
                return;
            }
            req.setCharacterEncoding("utf-8");
            res.setCharacterEncoding("utf-8");
            TenantContext tc = this.getTenantContext(path.getTenantUrl());
            if (tc == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("can not determine tenant.URL=" + req.getServletPath());
                }
                ExecuteContext.finContext();
                res.sendError(404);
                return;
            }
            try {
                ExecuteContext ec = new ExecuteContext(tc);
                ExecuteContext.initContext((ExecuteContext)ec);
                this.setMdc(req, ec);
                if (logger.isDebugEnabled()) {
                    logger.debug("do " + req.getRequestURL().toString() + " " + req.getMethod());
                }
                switch (path.getPathType()) {
                    case REJECT: {
                        if (logger.isDebugEnabled()) {
                            logger.debug("reject URL:" + req.getRequestURI());
                        }
                        res.sendError(404);
                        return;
                    }
                    case REST: {
                        req.setAttribute("mtp.requestPath", (Object)path);
                        this.servletContext.getRequestDispatcher(path.getTargetPath()).forward((ServletRequest)req, (ServletResponse)res);
                        return;
                    }
                    case THROUGH: {
                        req.setAttribute("mtp.requestPath", (Object)path);
                        chain.doFilter((ServletRequest)req, (ServletResponse)res);
                        return;
                    }
                    case ACTION: {
                        this.doAction(path, req, res, chain);
                        return;
                    }
                }
                return;
            }
            finally {
                ExecuteContext.finContext();
            }
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                fatalLogger.error("Exception occurred while processing URI:" + req.getRequestURI() + " " + e.getMessage(), e);
            } else {
                logger.error("Exception occurred while processing URI:" + req.getRequestURI() + " " + e.getMessage(), e);
            }
            try {
                if (res.isCommitted()) return;
                res.sendError(500);
                return;
            }
            catch (Exception e1) {
                logger.error(e1.getMessage(), (Throwable)e1);
                return;
            }
        }
        finally {
            ResourceHolder.fin();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAction(RequestPath path, HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        Tenant tenant;
        String menuUrl;
        String actionPath;
        if (WebUtil.isDirectAccess(req)) {
            logger.debug("process as direct access mode. port={}", (Object)req.getServerPort());
        }
        if ((actionPath = path.getTargetPath(true)).length() == 0 && !StringUtil.isEmpty((String)(menuUrl = WebUtil.getTenantWebInfo(tenant = ExecuteContext.getCurrentContext().getCurrentTenant()).getHomeUrl())) && !menuUrl.equals("/")) {
            String redirectPath = menuUrl.startsWith("/") ? path.getTenantContextPath((HttpServletRequest)req) + menuUrl : path.getTenantContextPath((HttpServletRequest)req) + "/" + menuUrl;
            logger.debug("redirects to top URL.RedirectURL=" + redirectPath);
            res.sendRedirect(redirectPath);
            return;
        }
        WebRequestStack requestStack = null;
        try {
            MetaActionMapping.ActionMappingRuntime actionMapping = this.amService.getByPathHierarchy(actionPath, this.webFrontendService.getWelcomeAction());
            if (actionMapping != null) {
                logger.debug("call actionMapping:" + actionMapping.getMetaData().getName());
                if (actionMapping.getRequestRestriction().maxBodySize() != -1L) {
                    req = new LimitRequestBodyHttpServletRequest((HttpServletRequest)req, actionMapping.getRequestRestriction().maxBodySize());
                }
                requestStack = new WebRequestStack(path, this.servletContext, (HttpServletRequest)req, res);
                try {
                    actionMapping.executeCommand(requestStack);
                }
                catch (RequestBodyTooLargeException e) {
                    res.sendError(413);
                }
            } else {
                res.sendError(404);
            }
        }
        finally {
            if (requestStack != null) {
                requestStack.finallyProcess();
            }
        }
    }

    private TenantContext getTenantContext(String value) {
        TenantContext context = this.tenantContextService.getTenantContext(value);
        return context;
    }
}

