/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.session.jee;

import jakarta.servlet.http.HttpSession;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import org.iplass.mtp.command.RequestContextWrapper;
import org.iplass.mtp.impl.session.Session;
import org.iplass.mtp.impl.session.SessionService;
import org.iplass.mtp.impl.web.WebRequestContext;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.spi.Config;

public class HttpSessionService
extends SessionService {
    static final String MUTEX_OBJECT_NAME = "mtp.session.store.Mutex";

    public void init(Config config) {
    }

    public void destroy() {
    }

    public Session getSessionInternal(boolean create) {
        WebRequestStack request = WebRequestStack.getCurrent();
        if (request == null) {
            if (create) {
                return new SessionService.OnetimeSessionImpl((SessionService)this);
            }
        } else {
            HttpSession httpSession = request.getRequest().getSession(create);
            if (httpSession != null) {
                return new HttpServletSession(httpSession, this);
            }
        }
        return null;
    }

    private static class HttpServletSession
    implements Session {
        private HttpSession httpSession;
        private SessionService service;

        private HttpServletSession(HttpSession httpSession, SessionService service) {
            this.httpSession = httpSession;
            this.service = service;
        }

        public String getId() {
            return this.httpSession.getId();
        }

        public Object getAttribute(String name) {
            return this.httpSession.getAttribute(name);
        }

        public void setAttribute(String name, Object value) {
            this.httpSession.setAttribute(name, value);
        }

        public void removeAttribute(String name) {
            this.httpSession.removeAttribute(name);
        }

        public Iterator<String> getAttributeNames() {
            final Enumeration e = this.httpSession.getAttributeNames();
            return new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return e.hasMoreElements();
                }

                @Override
                public String next() {
                    return (String)e.nextElement();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public void invalidate() {
            this.service.removeSessionFromExecuteContext((Session)this);
            this.httpSession.invalidate();
            WebRequestContext webRequestContext = null;
            WebRequestStack stack = WebRequestStack.getCurrent();
            if (stack != null) {
                if (stack.getRequestContext() instanceof WebRequestContext) {
                    webRequestContext = (WebRequestContext)stack.getRequestContext();
                } else if (stack.getRequestContext() instanceof RequestContextWrapper) {
                    RequestContextWrapper w = (RequestContextWrapper)stack.getRequestContext();
                    while (w != null) {
                        if (w.getWrapped() instanceof WebRequestContext) {
                            webRequestContext = (WebRequestContext)w.getWrapped();
                            w = null;
                            continue;
                        }
                        if (w.getWrapped() instanceof RequestContextWrapper) {
                            w = (RequestContextWrapper)w.getWrapped();
                            continue;
                        }
                        w = null;
                    }
                }
            }
            if (webRequestContext != null) {
                webRequestContext.clearSession();
            }
        }

        public Object getSessionMutexObject() {
            Object mutex = this.httpSession.getAttribute(HttpSessionService.MUTEX_OBJECT_NAME);
            if (mutex == null) {
                return this.httpSession;
            }
            return mutex;
        }

        public long getCreationTime() {
            return this.httpSession.getCreationTime();
        }

        public void changeSessionId() {
            WebRequestStack request = WebRequestStack.getCurrent();
            if (request == null) {
                throw new IllegalStateException("HttpServletRequest cannot be identified.");
            }
            request.getRequest().changeSessionId();
        }
    }

    public static class MutexObject
    implements Serializable {
        private static final long serialVersionUID = -8257705546725540025L;
    }
}

