/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.report;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionMode;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.TempFile;
import org.iplass.mtp.impl.report.JxlsCompiledScriptCacheStore;
import org.iplass.mtp.impl.report.JxlsGroovyEvaluatorFactory;
import org.iplass.mtp.impl.report.ReportingOutputModel;
import org.iplass.mtp.impl.web.template.report.MetaJxlsReportOutputLogic;
import org.iplass.mtp.impl.web.template.report.MetaReportParamMap;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.web.template.report.definition.OutputFileType;
import org.jxls.builder.JxlsStreaming;
import org.jxls.builder.JxlsTemplateFillerBuilder;
import org.jxls.expression.ExpressionEvaluatorFactory;
import org.jxls.transform.poi.JxlsPoiTemplateFillerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JxlsReportingOutputModel
implements ReportingOutputModel {
    private static Logger logger = LoggerFactory.getLogger(JxlsReportingOutputModel.class);
    private String passwordAttributeName;
    private POIFSFileSystem fs;
    private File tempPasswordFile;
    private MetaJxlsReportOutputLogic.JxlsReportOutputLogicRuntime logicRuntime;
    private byte[] binary;
    private String type;
    private MetaReportParamMap[] paramMap;
    private JxlsCompiledScriptCacheStore cacheStore;

    JxlsReportingOutputModel(byte[] binary, String type, String extension) throws Exception {
        this.binary = binary;
        this.type = type;
    }

    public String getPasswordAttributeName() {
        return this.passwordAttributeName;
    }

    public void setPasswordAttributeName(String passwordAttributeName) {
        this.passwordAttributeName = passwordAttributeName;
    }

    public MetaJxlsReportOutputLogic.JxlsReportOutputLogicRuntime getLogicRuntime() {
        return this.logicRuntime;
    }

    public void setLogicRuntime(MetaJxlsReportOutputLogic.JxlsReportOutputLogicRuntime logicRuntime) {
        this.logicRuntime = logicRuntime;
    }

    public byte[] getBinary() {
        return this.binary;
    }

    public void setBinary(byte[] binary) {
        this.binary = binary;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public MetaReportParamMap[] getParamMap() {
        return this.paramMap;
    }

    public void setParamMap(MetaReportParamMap[] paramMap) {
        this.paramMap = paramMap;
    }

    public JxlsCompiledScriptCacheStore getCacheStore() {
        return this.cacheStore;
    }

    public void setCacheStore(JxlsCompiledScriptCacheStore cacheStore) {
        this.cacheStore = cacheStore;
    }

    public void write(Map<String, Object> reportData, OutputStream os, String password) throws IOException, InvalidFormatException, GeneralSecurityException {
        try (ByteArrayInputStream templateInput = new ByteArrayInputStream(this.getBinary());){
            OutputFileType outputType = OutputFileType.convertOutputFileType(this.getType());
            boolean isStreaming = outputType == OutputFileType.XLSX_SXSSF_JXLS;
            JxlsPoiTemplateFillerBuilder builder = (JxlsPoiTemplateFillerBuilder)((JxlsPoiTemplateFillerBuilder)((JxlsPoiTemplateFillerBuilder)JxlsPoiTemplateFillerBuilder.newInstance().withExpressionEvaluatorFactory((ExpressionEvaluatorFactory)new JxlsGroovyEvaluatorFactory(this.cacheStore))).withTemplate((InputStream)templateInput)).withStreaming(isStreaming ? JxlsStreaming.STREAMING_ON : JxlsStreaming.STREAMING_OFF);
            if (StringUtil.isEmpty((String)password)) {
                this.outputReport(reportData, builder, os);
            } else if (OutputFileType.XLS_JXLS.equals((Object)outputType)) {
                logger.warn("XLS type does not support encryption. IF you want to encryption, change to XLSX type.");
                this.outputReport(reportData, builder, os);
            } else {
                this.getPOIFSFileSystem(reportData, password, builder).writeFilesystem(os);
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.fs != null) {
                this.fs.close();
                this.fs = null;
            }
        }
        finally {
            if (this.tempPasswordFile != null) {
                if (!this.tempPasswordFile.delete()) {
                    logger.warn("Fail to delete temporary resource:" + this.tempPasswordFile.getPath());
                }
                this.tempPasswordFile = null;
            }
        }
    }

    private POIFSFileSystem getPOIFSFileSystem(Map<String, Object> reportData, String password, JxlsPoiTemplateFillerBuilder builder) throws IOException, InvalidFormatException, GeneralSecurityException {
        if (this.fs != null) {
            return this.fs;
        }
        this.tempPasswordFile = TempFile.createTempFile((String)"tmp", (String)".tmp");
        try (FileOutputStream fos = new FileOutputStream(this.tempPasswordFile);){
            this.outputReport(reportData, builder, fos);
        }
        this.fs = new POIFSFileSystem();
        EncryptionInfo info = new EncryptionInfo(EncryptionMode.agile);
        Encryptor enc = info.getEncryptor();
        enc.confirmPassword(password);
        try (OPCPackage opc = OPCPackage.open((File)this.tempPasswordFile, (PackageAccess)PackageAccess.READ_WRITE);
             OutputStream encos = enc.getDataStream(this.fs);){
            opc.save(encos);
        }
        return this.fs;
    }

    private void outputReport(Map<String, Object> reportData, JxlsPoiTemplateFillerBuilder builder, OutputStream out) throws IOException {
        if (this.getLogicRuntime() != null) {
            this.logicRuntime.outputReport((JxlsTemplateFillerBuilder<?>)builder, reportData, out);
        } else {
            builder.build().fill(reportData, () -> out);
        }
    }
}

