/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.report;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimplePdfExporterConfiguration;
import net.sf.jasperreports.export.SimpleXlsReportConfiguration;
import net.sf.jasperreports.export.SimpleXlsxReportConfiguration;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.report.JasperReportingOutputModel;
import org.iplass.mtp.impl.report.ReportingEngine;
import org.iplass.mtp.impl.report.ReportingOutputModel;
import org.iplass.mtp.impl.report.ReportingType;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.template.report.MetaReportParamMap;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.web.template.definition.TemplateDefinitionManager;
import org.iplass.mtp.web.template.report.ReportOutputException;
import org.iplass.mtp.web.template.report.definition.JasperReportType;
import org.iplass.mtp.web.template.report.definition.LocalizedReportDefinition;
import org.iplass.mtp.web.template.report.definition.OutputFileType;
import org.iplass.mtp.web.template.report.definition.ReportTemplateDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JasperReportingEngine
implements ReportingEngine {
    private static Logger logger = LoggerFactory.getLogger(JasperReportingEngine.class);
    private String[] supportFiles;
    private static final String SESSION_STR = "session";
    private static final String REQUEST_STR = "request";
    private static final String PREFIX_REQUEST = "request.";
    private static final String PREFIX_SESSION = "session.";

    @Override
    public ReportingOutputModel createOutputModel(byte[] binary, String type, String extension) throws Exception {
        return new JasperReportingOutputModel(binary, type, extension);
    }

    @Override
    public boolean isSupport(String type) {
        boolean isSupport = false;
        for (String supportFile : this.supportFiles) {
            if (!supportFile.equals(type)) continue;
            isSupport = true;
        }
        return isSupport;
    }

    @Override
    public void exportReport(WebRequestStack context, ReportingOutputModel model) throws Exception {
        RequestContext request = context.getRequestContext();
        JasperReportingOutputModel jasperModel = (JasperReportingOutputModel)model;
        OutputFileType outputType = OutputFileType.convertOutputFileType(jasperModel.getType());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(REQUEST_STR, request);
        params.put(SESSION_STR, request.getSession());
        MetaReportParamMap[] paramMaps = jasperModel.getMaps();
        if (paramMaps != null) {
            for (MetaReportParamMap p : paramMaps) {
                if ("report".equals(p.getParamType())) {
                    TemplateDefinitionManager tdm = (TemplateDefinitionManager)ManagerLocator.getInstance().getManager(TemplateDefinitionManager.class);
                    ReportTemplateDefinition td = (ReportTemplateDefinition)tdm.get(p.getMapFrom());
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(td.getBinary());
                    JasperReport temp = JasperCompileManager.compileReport((InputStream)inputStream);
                    params.put(p.getName(), temp);
                    String lang = ExecuteContext.getCurrentContext().getLanguage();
                    for (LocalizedReportDefinition lrd : td.getLocalizedReportList()) {
                        ByteArrayInputStream localInputStream;
                        JasperReport localTemp;
                        if (!lang.equals(lrd.getLocaleName()) || (localTemp = JasperCompileManager.compileReport((InputStream)(localInputStream = new ByteArrayInputStream(lrd.getBinary())))) == null) continue;
                        params.put(p.getName(), localTemp);
                    }
                    continue;
                }
                if ("list".equals(p.getParamType())) {
                    params.put(p.getName(), new JRBeanCollectionDataSource((Collection)this.getAttribute(request, p.getMapFrom())));
                    continue;
                }
                params.put(p.getName(), this.getAttribute(request, p.getMapFrom()));
            }
        }
        JREmptyDataSource dataSource = null;
        if (StringUtil.isEmpty((String)jasperModel.getDataSourceAttributeName())) {
            dataSource = new JREmptyDataSource();
        } else {
            Object dsObject = this.getAttribute(request, jasperModel.getDataSourceAttributeName());
            if (dsObject == null) {
                dataSource = new JREmptyDataSource();
            } else if (dsObject instanceof JRDataSource) {
                dataSource = (JRDataSource)dsObject;
            } else {
                throw new ReportOutputException("unsupported datasource type. class=" + dsObject.getClass().getName());
            }
        }
        String password = null;
        if (StringUtil.isNotEmpty((String)jasperModel.getPasswordAttributeName())) {
            password = (String)this.getAttribute(request, jasperModel.getPasswordAttributeName());
        }
        ArrayList<JasperPrint> jrList = new ArrayList<JasperPrint>();
        jrList.add(JasperFillManager.fillReport((JasperReport)jasperModel.getJrMain(), params, (JRDataSource)dataSource));
        SimpleExporterInput input = SimpleExporterInput.getInstance(jrList);
        SimpleOutputStreamExporterOutput output = new SimpleOutputStreamExporterOutput((OutputStream)context.getResponse().getOutputStream());
        JRPdfExporter exporter = null;
        if (OutputFileType.PDF.equals((Object)outputType)) {
            JRPdfExporter pdfExporter = new JRPdfExporter();
            pdfExporter.setExporterInput((ExporterInput)input);
            pdfExporter.setExporterOutput((ExporterOutput)output);
            config = new SimplePdfExporterConfiguration();
            if (StringUtil.isNotEmpty((String)password)) {
                config.setOwnerPassword(password);
                config.setUserPassword(password);
                config.setEncrypted(Boolean.valueOf(true));
            }
            pdfExporter.setConfiguration((ExporterConfiguration)config);
            exporter = pdfExporter;
        } else if (OutputFileType.XLS.equals((Object)outputType)) {
            JRXlsExporter xlsExporter = new JRXlsExporter();
            xlsExporter.setExporterInput((ExporterInput)input);
            xlsExporter.setExporterOutput((ExporterOutput)output);
            config = new SimpleXlsReportConfiguration();
            if (StringUtil.isNotEmpty((String)password)) {
                logger.warn("XLS type does not support encryption. IF you want to encryption, change to XLSX type.");
            }
            config.setWhitePageBackground(Boolean.valueOf(false));
            xlsExporter.setConfiguration((ReportExportConfiguration)config);
            exporter = xlsExporter;
        } else if (OutputFileType.XLSX.equals((Object)outputType)) {
            JRXlsxExporter xlsxExporter = new JRXlsxExporter();
            xlsxExporter.setExporterInput((ExporterInput)input);
            xlsxExporter.setExporterOutput((ExporterOutput)output);
            config = new SimpleXlsxReportConfiguration();
            if (StringUtil.isNotEmpty((String)password)) {
                config.setPassword(password);
            }
            config.setWhitePageBackground(Boolean.valueOf(false));
            xlsxExporter.setConfiguration((ReportExportConfiguration)config);
            exporter = xlsxExporter;
        }
        if (exporter != null) {
            exporter.exportReport();
        }
    }

    @Override
    public String[] getSupportFiles() {
        return this.supportFiles;
    }

    public void setSupportFiles(String[] supportFiles) {
        this.supportFiles = supportFiles;
    }

    @Override
    public ReportingType getReportingType() {
        ReportingType type = new ReportingType();
        type.setName(JasperReportType.class.getName());
        type.setDisplayName("JasperReports");
        return type;
    }

    private Object getAttribute(RequestContext request, String attributeName) {
        if (attributeName.startsWith(PREFIX_REQUEST)) {
            String valueName = attributeName.substring(PREFIX_REQUEST.length());
            return request.getAttribute(valueName);
        }
        if (attributeName.startsWith(PREFIX_SESSION)) {
            String valueName = attributeName.substring(PREFIX_SESSION.length());
            return request.getSession().getAttribute(valueName);
        }
        return request.getAttribute(attributeName);
    }
}

