/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.fileport;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.concurrent.Callable;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.async.TaskStatus;
import org.iplass.mtp.impl.async.ExceptionHandleable;
import org.iplass.mtp.impl.entity.fileport.EntityCsvException;
import org.iplass.mtp.impl.fileport.EntityFileUploadOption;
import org.iplass.mtp.impl.fileport.EntityFileUploadService;
import org.iplass.mtp.impl.fileport.EntityFileUploadStatus;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityFileUploadTask
implements Callable<EntityFileUploadStatus>,
ExceptionHandleable,
Serializable {
    private static final long serialVersionUID = -3723274599525554443L;
    private static Logger logger = LoggerFactory.getLogger(EntityFileUploadTask.class);
    private String filePath;
    private String fileName;
    private long uploadDateTime;
    private String defName;
    private String parameter;
    private EntityFileUploadOption option;

    public EntityFileUploadTask(String filePath, String fileName, long uploadDateTime, String defName, String parameter, EntityFileUploadOption option) {
        this.filePath = filePath;
        this.fileName = fileName;
        this.uploadDateTime = uploadDateTime;
        this.defName = defName;
        this.parameter = parameter;
        this.option = option;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getUploadDateTime() {
        return this.uploadDateTime;
    }

    public String getDefName() {
        return this.defName;
    }

    public String getParameter() {
        return this.parameter;
    }

    public EntityFileUploadOption getEntityFileUploadOption() {
        return this.option;
    }

    public void aborted(Throwable cause) {
    }

    public void timeouted() {
    }

    public void canceled() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntityFileUploadStatus call() throws Exception {
        FileInputStream is;
        EntityFileUploadService service = (EntityFileUploadService)ServiceRegistry.getRegistry().getService(EntityFileUploadService.class);
        try {
            is = new FileInputStream(this.filePath);
            try {
                service.validate(is, this.option.getEntityFileType(), this.defName, this.option.isWithReferenceVersion(), this.option.getInterrupterClassName());
            }
            finally {
                ((InputStream)is).close();
            }
        }
        catch (FileNotFoundException e) {
            throw new SystemException((Throwable)e);
        }
        catch (EntityCsvException e) {
            try {
                EntityFileUploadStatus result = new EntityFileUploadStatus();
                result.setFileName(this.getFileName());
                result.setUploadDateTime(this.getUploadDateTime());
                result.setCode(e.getCode());
                result.setMessage(e.getMessage());
                result.setStatus(TaskStatus.ABORTED);
                EntityFileUploadStatus entityFileUploadStatus = result;
                return entityFileUploadStatus;
            }
            finally {
                this.deleteFile();
            }
        }
        try {
            EntityFileUploadStatus entityFileUploadStatus;
            is = new FileInputStream(this.filePath);
            try {
                EntityFileUploadStatus result;
                entityFileUploadStatus = result = service.upload(is, this.defName, this.option);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new SystemException((Throwable)e);
                }
            }
            ((InputStream)is).close();
            return entityFileUploadStatus;
        }
        finally {
            this.deleteFile();
        }
    }

    private void deleteFile() {
        try {
            Files.deleteIfExists(Paths.get(this.filePath, new String[0]));
        }
        catch (IOException e) {
            logger.warn("Fail to delete a Temporary's File.", (Throwable)e);
        }
    }
}

