/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.fileport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.async.AsyncTaskFuture;
import org.iplass.mtp.async.AsyncTaskInfo;
import org.iplass.mtp.async.AsyncTaskInfoSearchCondtion;
import org.iplass.mtp.async.AsyncTaskManager;
import org.iplass.mtp.async.AsyncTaskOption;
import org.iplass.mtp.async.ExceptionHandlingMode;
import org.iplass.mtp.async.TaskStatus;
import org.iplass.mtp.async.TaskTimeoutException;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.csv.CsvUploadInterrupter;
import org.iplass.mtp.entity.DeleteOption;
import org.iplass.mtp.entity.DeleteTargetVersion;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityDuplicateValueException;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.EntityValidationException;
import org.iplass.mtp.entity.InsertOption;
import org.iplass.mtp.entity.SearchOption;
import org.iplass.mtp.entity.SearchResult;
import org.iplass.mtp.entity.TargetVersion;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.entity.ValidateError;
import org.iplass.mtp.entity.ValidateResult;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.VersionControlType;
import org.iplass.mtp.entity.definition.properties.BinaryProperty;
import org.iplass.mtp.entity.definition.properties.ExpressionProperty;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.impl.entity.fileport.EntityCsvException;
import org.iplass.mtp.impl.entity.fileport.EntityCsvReader;
import org.iplass.mtp.impl.entity.fileport.EntityExcelReader;
import org.iplass.mtp.impl.entity.fileport.EntityFileReader;
import org.iplass.mtp.impl.fileport.EntityFileType;
import org.iplass.mtp.impl.fileport.EntityFileUploadOption;
import org.iplass.mtp.impl.fileport.EntityFileUploadStatus;
import org.iplass.mtp.impl.fileport.EntityFileUploadTask;
import org.iplass.mtp.impl.fileport.TransactionType;
import org.iplass.mtp.impl.web.WebFrontendService;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.WebResourceBundleUtil;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.transaction.Propagation;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.util.CollectionUtil;
import org.iplass.mtp.util.DateUtil;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.utilityclass.definition.UtilityClassDefinitionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityFileUploadService
implements Service {
    private static Logger logger = LoggerFactory.getLogger(EntityFileUploadService.class);
    private static final String UPLOAD_QUEUE = "entityupload";
    private static final String ENCODE = "UTF-8";
    private int showErrorLimitCount;
    private TargetVersion defaultUpdateTargetVersionForNoneVersionedEntity;
    private boolean mustOrderByWithLimit;
    private EntityManager em = null;
    private EntityDefinitionManager edm = null;

    public void init(Config config) {
        this.em = (EntityManager)ManagerLocator.manager(EntityManager.class);
        this.edm = (EntityDefinitionManager)ManagerLocator.manager(EntityDefinitionManager.class);
        this.showErrorLimitCount = (Integer)config.getValue("showErrorLimitCount", Integer.class, (Object)100);
        this.defaultUpdateTargetVersionForNoneVersionedEntity = (TargetVersion)config.getValue("defaultUpdateTargetVersionForNoneVersionedEntity", TargetVersion.class, (Object)TargetVersion.CURRENT_VALID);
        this.mustOrderByWithLimit = (Boolean)config.getValue("mustOrderByWithLimit", Boolean.class, (Object)false);
    }

    public void destroy() {
    }

    public int getShowErrorLimitCount() {
        return this.showErrorLimitCount;
    }

    public boolean isMustOrderByWithLimit() {
        return this.mustOrderByWithLimit;
    }

    public void validate(InputStream is, EntityFileType entityFileType, String defName, boolean withReferenceVersion, String interrupterClassName) {
        this.validate(is, entityFileType, defName, withReferenceVersion, interrupterClassName, this.showErrorLimitCount);
    }

    public void validate(InputStream is, EntityFileType entityFileType, String defName, boolean withReferenceVersion, String interrupterClassName, int errorLimit) {
        EntityDefinition ed = this.edm.get(defName);
        CsvUploadInterrupter interrupter = this.createInterrupter(interrupterClassName);
        try (EntityFileReader<?> reader = this.getReader(is, entityFileType, ed);){
            reader.withReferenceVersion(withReferenceVersion);
            reader.setCustomColumnNameMap(this.getCustomColumnNameMap(ed, interrupter));
            reader.validate(errorLimit);
        }
        catch (UnsupportedEncodingException e) {
            throw new EntityCsvException("CE0001", EntityFileUploadService.resourceString("impl.csv.CsvUploadService.invalidFileMsg", new Object[0]));
        }
        catch (EntityCsvException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ApplicationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new EntityCsvException("CE9000", e.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new EntityCsvException("CE9000", EntityFileUploadService.resourceString("impl.csv.CsvUploadService.errReadFile", new Object[0]));
        }
    }

    public EntityFileUploadStatus upload(InputStream is, String defName, EntityFileUploadOption option) {
        EntityFileUploadStatus entityFileUploadStatus;
        block11: {
            EntityFileUploadStatus result = new EntityFileUploadStatus();
            EntityDefinition ed = this.edm.get(defName);
            CsvUploadInterrupter interrupter = this.createInterrupter(option.getInterrupterClassName());
            EntityFileReader<?> reader = this.getReader(is, option.getEntityFileType(), ed);
            try {
                reader.withReferenceVersion(option.isWithReferenceVersion());
                reader.setCustomColumnNameMap(this.getCustomColumnNameMap(ed, interrupter));
                Transaction.with((Propagation)Propagation.SUPPORTS, t -> {
                    int readCount = 0;
                    int insertCount = 0;
                    int updateCount = 0;
                    int deleteCount = 0;
                    List properties = reader.properties();
                    boolean useCtrl = reader.isUseCtrl();
                    Set<String> updatableProperties = null;
                    HashMap<Object, String> keyValueMap = new HashMap<Object, String>();
                    Iterator iterator = reader.iterator();
                    while (iterator.hasNext()) {
                        ImportFunction func = new ImportFunction(this.em).ed(ed).iterator(iterator).isDenyInsert(option.isDenyInsert()).isDenyUpdate(option.isDenyUpdate()).isDenyDelete(option.isDenyDelete()).insertProperties(option.getInsertProperties()).updateProperties(option.getUpdateProperties()).transactionType(option.getTransactionType()).commitLimit(option.getCommitLimit()).useCtrl(useCtrl).uniqueKey(option.getUniqueKey()).properties(properties).updatableProperties(updatableProperties).keyValueMap(keyValueMap).deleteSpecificVersion(option.isDeleteSpecificVersion()).updateTargetVersionForNoneVersionedEntity(option.getUpdateTargetVersionForNoneVersionedEntity() != null ? option.getUpdateTargetVersionForNoneVersionedEntity() : this.defaultUpdateTargetVersionForNoneVersionedEntity).interrupter(interrupter);
                        ApplicationException ex = null;
                        try {
                            Transaction.requiresNew((Consumer)func);
                            updatableProperties = func.updatableProperties();
                        }
                        catch (EntityDuplicateValueException e) {
                            ex = new ApplicationException(EntityFileUploadService.resourceString("impl.csv.CsvUploadService.rowMsg", readCount + func.readCount()) + EntityFileUploadService.resourceString("impl.csv.CsvUploadService.overlapMsg", new Object[0]), (Throwable)e);
                        }
                        catch (EntityValidationException e) {
                            Object errorMessage = " ";
                            if (e.getValidateResults() != null) {
                                for (ValidateError ve : e.getValidateResults()) {
                                    errorMessage = (String)errorMessage + ve.getPropertyName() + " : " + String.valueOf(ve.getErrorMessages()) + ", ";
                                }
                            }
                            ex = new ApplicationException(EntityFileUploadService.resourceString("impl.csv.CsvUploadService.rowMsg", readCount + func.readCount()) + EntityFileUploadService.resourceString("impl.csv.CsvUploadService.validationMsg", new Object[0]) + (String)errorMessage, (Throwable)e);
                        }
                        catch (ApplicationException e) {
                            ex = new ApplicationException(EntityFileUploadService.resourceString("impl.csv.CsvUploadService.rowMsg", readCount + func.readCount()) + e.getMessage(), (Throwable)e);
                        }
                        catch (Exception e) {
                            ex = new ApplicationException(EntityFileUploadService.resourceString("impl.csv.CsvUploadService.rowInternalErr", readCount + func.readCount()), (Throwable)e);
                        }
                        finally {
                            readCount += func.readCount();
                            insertCount += func.insertCount();
                            updateCount += func.updateCount();
                            deleteCount += func.deleteCount();
                        }
                        if (ex == null) continue;
                        result.setInsertCount(insertCount);
                        result.setUpdateCount(updateCount);
                        result.setDeleteCount(deleteCount);
                        throw ex;
                    }
                    result.setInsertCount(insertCount);
                    result.setUpdateCount(updateCount);
                    result.setDeleteCount(deleteCount);
                    result.setStatus(TaskStatus.COMPLETED);
                });
                entityFileUploadStatus = result;
                if (reader == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UnsupportedEncodingException e) {
                    return this.asFailedResult(result, "CE0001", EntityFileUploadService.resourceString("impl.csv.CsvUploadService.invalidFileMsg", new Object[0]));
                }
                catch (EntityCsvException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    return this.asFailedResult(result, e.getCode(), e.getMessage());
                }
                catch (ApplicationException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    return this.asFailedResult(result, "CE9000", e.getMessage());
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    return this.asFailedResult(result, "CE9000", EntityFileUploadService.resourceString("impl.csv.CsvUploadService.errReadFile", new Object[0]));
                }
            }
            reader.close();
        }
        return entityFileUploadStatus;
    }

    private EntityFileReader<?> getReader(InputStream is, EntityFileType entityFileType, EntityDefinition ed) throws UnsupportedEncodingException {
        if (entityFileType == EntityFileType.EXCEL) {
            return new EntityExcelReader(ed, is);
        }
        return new EntityCsvReader(ed, is, ENCODE);
    }

    private CsvUploadInterrupter createInterrupter(String className) {
        CsvUploadInterrupter interrupter = null;
        if (StringUtil.isNotEmpty((String)className)) {
            logger.debug("set csv upload interrupter. class=" + className);
            UtilityClassDefinitionManager ucdm = (UtilityClassDefinitionManager)ManagerLocator.getInstance().getManager(UtilityClassDefinitionManager.class);
            try {
                interrupter = (CsvUploadInterrupter)ucdm.createInstanceAs(CsvUploadInterrupter.class, className);
            }
            catch (ClassNotFoundException e) {
                logger.error(className + " can not instantiate.", (Throwable)e);
                throw new ApplicationException(EntityFileUploadService.resourceString("impl.csv.CsvUploadService.internalErr", new Object[0]));
            }
        }
        if (interrupter == null) {
            logger.debug("set default csv upload interrupter.");
            interrupter = new CsvUploadInterrupter(this){};
        }
        return interrupter;
    }

    private Map<String, String> getCustomColumnNameMap(EntityDefinition ed, CsvUploadInterrupter interrupter) {
        if (interrupter.columnNameMap(ed) != null) {
            return interrupter.columnNameMap(ed).entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        }
        return null;
    }

    private EntityFileUploadStatus asFailedResult(EntityFileUploadStatus result, String code, String message) {
        result.setCode(code);
        result.setMessage(message);
        result.setStatus(TaskStatus.ABORTED);
        return result;
    }

    public void asyncUpload(InputStream is, String fileName, String defName, String parameter, EntityFileUploadOption option) {
        Path destPath = this.copyUploadFile(is);
        EntityFileUploadTask task = new EntityFileUploadTask(destPath.toString(), fileName, DateUtil.getCurrentTimestamp().getTime(), defName, parameter, option);
        AsyncTaskOption taskOption = new AsyncTaskOption();
        taskOption.setExceptionHandlingMode(ExceptionHandlingMode.ABORT);
        taskOption.setGroupingKey(AuthContext.getCurrentContext().getUser().getOid());
        taskOption.setQueue(UPLOAD_QUEUE);
        taskOption.setReturnResult(true);
        ((AsyncTaskManager)ManagerLocator.manager(AsyncTaskManager.class)).execute(taskOption, (Callable)task);
    }

    private Path copyUploadFile(InputStream is) {
        WebFrontendService webFront = (WebFrontendService)ServiceRegistry.getRegistry().getService(WebFrontendService.class);
        File tempDir = null;
        if (webFront.getTempFileDir() == null) {
            WebRequestStack reqStack = WebRequestStack.getCurrent();
            if (reqStack != null && reqStack.getRequest() != null) {
                tempDir = (File)reqStack.getRequest().getServletContext().getAttribute("jakarta.servlet.context.tempdir");
            }
        } else {
            tempDir = new File(webFront.getTempFileDir());
        }
        Path distFile = null;
        try {
            distFile = Files.createTempFile(tempDir.toPath(), "mtp", ".csv", new FileAttribute[0]);
            Files.copy(is, distFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException | RuntimeException e) {
            if (distFile != null) {
                try {
                    Files.deleteIfExists(distFile);
                }
                catch (IOException e1) {
                    logger.warn("Fail to delete a Temporary's File.", (Throwable)e1);
                }
            }
            throw new EntityCsvException((Throwable)e);
        }
        return distFile;
    }

    public List<EntityFileUploadStatus> getStatus() {
        ArrayList<EntityFileUploadStatus> taskStatusList = new ArrayList<EntityFileUploadStatus>();
        AsyncTaskInfoSearchCondtion cond = new AsyncTaskInfoSearchCondtion();
        cond.setQueue(UPLOAD_QUEUE);
        cond.setGroupingKey(AuthContext.getCurrentContext().getUser().getOid());
        cond.setWithHistory(true);
        AsyncTaskManager atm = (AsyncTaskManager)ManagerLocator.manager(AsyncTaskManager.class);
        List infoList = atm.searchAsyncTaskInfo(cond);
        for (AsyncTaskInfo info : infoList) {
            AsyncTaskInfo detail = atm.loadAsyncTaskInfo(info.getTaskId(), UPLOAD_QUEUE);
            EntityFileUploadStatus result = null;
            if (TaskStatus.RETURNED.equals((Object)info.getStatus())) {
                try {
                    AsyncTaskFuture future = atm.getResult(info.getTaskId(), UPLOAD_QUEUE);
                    result = (EntityFileUploadStatus)future.get();
                }
                catch (Exception e) {
                    throw new SystemException((Throwable)e);
                }
            } else if (detail.getResult() != null) {
                if (detail.getResult() instanceof EntityFileUploadStatus) {
                    result = (EntityFileUploadStatus)detail.getResult();
                } else if (detail.getResult() instanceof TaskTimeoutException) {
                    result = new EntityFileUploadStatus();
                    result.setStatus(TaskStatus.ABORTED);
                    result.setMessage(EntityFileUploadService.resourceString("impl.csv.CsvUploadService.timeoutMsg", new Object[0]));
                }
            }
            if (result == null) {
                result = new EntityFileUploadStatus();
                result.setStatus(info.getStatus());
            }
            EntityFileUploadTask task = (EntityFileUploadTask)detail.getTask();
            result.setFileName(task.getFileName());
            result.setUploadDateTime(task.getUploadDateTime());
            result.setDefName(task.getDefName());
            result.setParameter(task.getParameter());
            taskStatusList.add(result);
        }
        return taskStatusList;
    }

    private static String resourceString(String key, Object ... arguments) {
        return WebResourceBundleUtil.resourceString(key, arguments);
    }

    private static class ImportFunction
    implements Consumer<Transaction> {
        private int readCount = 0;
        private int insertCount = 0;
        private int updateCount = 0;
        private int deleteCount = 0;
        private EntityManager em;
        private EntityDefinition ed;
        private Iterator<Entity> iterator;
        private TransactionType transactionType;
        private boolean useCtrl;
        private boolean isDenyInsert;
        private boolean isDenyUpdate;
        private boolean isDenyDelete;
        private Set<String> insertProperties;
        private Set<String> updateProperties;
        private int commitLimit;
        private String uniqueKey = "oid";
        private List<String> properties;
        private Set<String> updatableProperties;
        private Map<Object, String> keyValueMap;
        private boolean deleteSpecificVersion;
        private TargetVersion updateTargetVersionForNoneVersionedEntity;
        private CsvUploadInterrupter interrupter = new CsvUploadInterrupter(this){};

        public ImportFunction(EntityManager em) {
            this.em = em;
        }

        public ImportFunction ed(EntityDefinition ed) {
            this.ed = ed;
            return this;
        }

        public ImportFunction iterator(Iterator<Entity> iterator) {
            this.iterator = iterator;
            return this;
        }

        public ImportFunction isDenyInsert(boolean isDenyInsert) {
            this.isDenyInsert = isDenyInsert;
            return this;
        }

        public ImportFunction isDenyUpdate(boolean isDenyUpdate) {
            this.isDenyUpdate = isDenyUpdate;
            return this;
        }

        public ImportFunction isDenyDelete(boolean isDenyDelete) {
            this.isDenyDelete = isDenyDelete;
            return this;
        }

        public ImportFunction insertProperties(Set<String> insertProperties) {
            this.insertProperties = insertProperties;
            return this;
        }

        public ImportFunction updateProperties(Set<String> updateProperties) {
            this.updateProperties = updateProperties;
            return this;
        }

        public ImportFunction transactionType(TransactionType transactionType) {
            this.transactionType = transactionType;
            return this;
        }

        public ImportFunction commitLimit(int commitLimit) {
            this.commitLimit = commitLimit;
            return this;
        }

        public ImportFunction useCtrl(boolean useCtrl) {
            this.useCtrl = useCtrl;
            return this;
        }

        public ImportFunction uniqueKey(String uniqueKey) {
            if (uniqueKey != null) {
                this.uniqueKey = uniqueKey;
            }
            return this;
        }

        public ImportFunction properties(List<String> properties) {
            this.properties = properties;
            return this;
        }

        public ImportFunction updatableProperties(Set<String> updatableProperties) {
            this.updatableProperties = updatableProperties;
            return this;
        }

        public ImportFunction keyValueMap(Map<Object, String> keyValueMap) {
            this.keyValueMap = keyValueMap;
            return this;
        }

        public ImportFunction deleteSpecificVersion(boolean deleteSpecificVersion) {
            this.deleteSpecificVersion = deleteSpecificVersion;
            return this;
        }

        public ImportFunction updateTargetVersionForNoneVersionedEntity(TargetVersion updateTargetVersionForNoneVersionedEntity) {
            this.updateTargetVersionForNoneVersionedEntity = updateTargetVersionForNoneVersionedEntity;
            return this;
        }

        public ImportFunction interrupter(CsvUploadInterrupter interrupter) {
            this.interrupter = interrupter != null ? interrupter : new CsvUploadInterrupter(this){};
            return this;
        }

        public int readCount() {
            return this.readCount;
        }

        public int insertCount() {
            return this.insertCount;
        }

        public int updateCount() {
            return this.updateCount;
        }

        public int deleteCount() {
            return this.deleteCount;
        }

        public Set<String> updatableProperties() {
            return this.updatableProperties;
        }

        @Override
        public void accept(Transaction transaction) {
            try {
                while (this.iterator.hasNext() && (this.transactionType != TransactionType.DIVISION || this.readCount != this.commitLimit)) {
                    Entity entity = this.iterator.next();
                    ++this.readCount;
                    String ctrlCode = (String)entity.getValue("_useCtrl");
                    if (StringUtil.isEmpty((String)ctrlCode)) {
                        ctrlCode = "M";
                    }
                    if (this.useCtrl && ctrlCode.equals("D")) {
                        this.deleteEntity(entity);
                        continue;
                    }
                    this.registEntity(entity, ctrlCode);
                }
            }
            catch (Exception e) {
                if (this.transactionType == TransactionType.DIVISION && !transaction.isRollbackOnly()) {
                    transaction.commit();
                } else {
                    this.insertCount = 0;
                    this.updateCount = 0;
                    this.deleteCount = 0;
                }
                throw e;
            }
        }

        private void deleteEntity(Entity entity) {
            if (this.isDenyDelete) {
                throw new ApplicationException(EntityFileUploadService.resourceString("impl.csv.CsvUploadService.denyDeleteError", new Object[0]));
            }
            DeleteTargetVersion deleteTargetVersion = DeleteTargetVersion.ALL;
            SearchResult searchResult = null;
            Object uniqueKeyValue = entity.getValue(this.uniqueKey);
            if (this.ed.getVersionControlType() != VersionControlType.NONE && this.deleteSpecificVersion && entity.getVersion() != null) {
                searchResult = this.em.searchEntity(this.onVersionQuery(this.ed.getName(), this.uniqueKey, uniqueKeyValue, entity.getVersion()));
                deleteTargetVersion = DeleteTargetVersion.SPECIFIC;
            } else {
                searchResult = this.em.searchEntity(this.noVersionQuery(this.ed.getName(), this.uniqueKey, uniqueKeyValue));
            }
            if (searchResult.getFirst() == null) {
                return;
            }
            entity.setOid(((Entity)searchResult.getFirst()).getOid());
            this.interrupter.dataMapping(this.readCount, entity, this.ed, CsvUploadInterrupter.CsvRegistrationType.DELETE);
            ArrayList<ValidateError> errors = new ArrayList<ValidateError>(this.interrupter.beforeRegister(this.readCount, entity, this.ed, CsvUploadInterrupter.CsvRegistrationType.DELETE));
            if (CollectionUtil.isEmpty(errors)) {
                try {
                    this.em.delete(entity, this.interrupter.deleteOption(new DeleteOption(false, deleteTargetVersion)));
                }
                catch (EntityValidationException e) {
                    errors.addAll(e.getValidateResults());
                }
            }
            errors.addAll(this.interrupter.afterRegister(this.readCount, entity, this.ed, CsvUploadInterrupter.CsvRegistrationType.DELETE));
            if (CollectionUtil.isNotEmpty(errors)) {
                throw new EntityValidationException("valiation error.", errors);
            }
            ++this.deleteCount;
        }

        private void registEntity(Entity entity, String ctrlCode) {
            Object uniqueKeyValue = entity.getValue(this.uniqueKey);
            ExecType execType = this.execType(this.ed, this.uniqueKey, uniqueKeyValue, entity, this.keyValueMap);
            if (this.useCtrl) {
                if (execType == ExecType.INSERT && !ctrlCode.equals("I") && !ctrlCode.equals("M")) {
                    throw new ApplicationException(EntityFileUploadService.resourceString("impl.csv.CsvUploadService.ctrlFlgUpdateError", new Object[0]));
                }
                if (!(execType != ExecType.UPDATE_SPECIFIC && execType != ExecType.UPDATE_VALID && execType != ExecType.UPDATE_NEW || ctrlCode.equals("U") || ctrlCode.equals("M"))) {
                    throw new ApplicationException(EntityFileUploadService.resourceString("impl.csv.CsvUploadService.ctrlFlgInsertError", new Object[0]));
                }
            }
            ArrayList<ValidateError> errors = new ArrayList<ValidateError>();
            switch (execType.ordinal()) {
                case 0: {
                    if (this.isDenyInsert) {
                        throw new ApplicationException(EntityFileUploadService.resourceString("impl.csv.CsvUploadService.denyInsertError", new Object[0]));
                    }
                    if (this.insertProperties != null) {
                        this.properties.stream().filter(property -> !this.insertProperties.contains(property)).forEach(property -> entity.setValue(property, null));
                    }
                    entity.setLockedBy(null);
                    this.interrupter.dataMapping(this.readCount, entity, this.ed, CsvUploadInterrupter.CsvRegistrationType.INSERT);
                    errors.addAll(this.interrupter.beforeRegister(this.readCount, entity, this.ed, CsvUploadInterrupter.CsvRegistrationType.INSERT));
                    if (CollectionUtil.isEmpty(errors)) {
                        try {
                            InsertOption insertOption = this.interrupter.insertOption(new InsertOption());
                            String insertOid = this.em.insert(entity, insertOption);
                            this.keyValueMap.put(uniqueKeyValue, insertOid);
                        }
                        catch (EntityValidationException e) {
                            errors.addAll(e.getValidateResults());
                        }
                    } else {
                        ValidateResult vr = this.em.validate(entity);
                        if (vr != null && vr.hasError()) {
                            errors.addAll(vr.getErrors());
                        }
                    }
                    errors.addAll(this.interrupter.afterRegister(this.readCount, entity, this.ed, CsvUploadInterrupter.CsvRegistrationType.INSERT));
                    if (CollectionUtil.isNotEmpty(errors)) {
                        throw new EntityValidationException("valiation error.", errors);
                    }
                    ++this.insertCount;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    if (this.isDenyUpdate) {
                        throw new ApplicationException(EntityFileUploadService.resourceString("impl.csv.CsvUploadService.denyUpdateError", new Object[0]));
                    }
                    this.interrupter.dataMapping(this.readCount, entity, this.ed, CsvUploadInterrupter.CsvRegistrationType.UPDATE);
                    errors.addAll(this.interrupter.beforeRegister(this.readCount, entity, this.ed, CsvUploadInterrupter.CsvRegistrationType.UPDATE));
                    if (CollectionUtil.isEmpty(errors)) {
                        try {
                            UpdateOption updateOption = this.interrupter.updateOption(this.updateOption(execType));
                            this.em.update(entity, updateOption);
                            this.keyValueMap.put(uniqueKeyValue, entity.getOid());
                        }
                        catch (EntityValidationException e) {
                            errors.addAll(e.getValidateResults());
                        }
                    } else {
                        ValidateResult vr = this.em.validate(entity);
                        if (vr != null && vr.hasError()) {
                            errors.addAll(vr.getErrors());
                        }
                    }
                    errors.addAll(this.interrupter.afterRegister(this.readCount, entity, this.ed, CsvUploadInterrupter.CsvRegistrationType.UPDATE));
                    if (CollectionUtil.isNotEmpty(errors)) {
                        throw new EntityValidationException("valiation error.", errors);
                    }
                    ++this.updateCount;
                    break;
                }
                default: {
                    throw new ApplicationException(EntityFileUploadService.resourceString("impl.csv.CsvUploadService.invalid", new Object[0]));
                }
            }
        }

        private ExecType execType(EntityDefinition ed, String uniqueKey, Object uniqueKeyValue, Entity entity, Map<Object, String> keyValueMap) {
            ExecType execType = null;
            if (uniqueKeyValue == null) {
                execType = ExecType.INSERT;
            } else if (ed.getVersionControlType() != VersionControlType.NONE) {
                if (keyValueMap.containsKey(uniqueKeyValue)) {
                    entity.setOid(keyValueMap.get(uniqueKeyValue));
                    uniqueKey = "oid";
                    uniqueKeyValue = entity.getOid();
                }
                if (entity.getVersion() != null) {
                    Query versionedQuery = this.onVersionQuery(ed.getName(), uniqueKey, uniqueKeyValue, entity.getVersion());
                    SearchResult versionedResult = this.em.searchEntity(versionedQuery, new SearchOption().countTotal());
                    if (versionedResult.getTotalCount() > 0) {
                        execType = ExecType.UPDATE_SPECIFIC;
                        entity.setOid(((Entity)versionedResult.getFirst()).getOid());
                    } else {
                        execType = this.versionedExecType(ed, uniqueKey, uniqueKeyValue, entity);
                    }
                } else {
                    execType = this.versionedExecType(ed, uniqueKey, uniqueKeyValue, entity);
                }
            } else {
                SearchResult searchResult = this.em.searchEntity(this.noVersionQuery(ed.getName(), uniqueKey, uniqueKeyValue), new SearchOption().countTotal());
                if (searchResult.getTotalCount() > 0) {
                    if (this.updateTargetVersionForNoneVersionedEntity == TargetVersion.SPECIFIC) {
                        execType = ExecType.UPDATE_SPECIFIC;
                        entity.setVersion(Long.valueOf(0L));
                    } else {
                        execType = ExecType.UPDATE_VALID;
                    }
                    entity.setOid(((Entity)searchResult.getFirst()).getOid());
                } else {
                    execType = ExecType.INSERT;
                }
            }
            return execType;
        }

        private ExecType versionedExecType(EntityDefinition ed, String uniqueKey, Object uniqueKeyValue, Entity entity) {
            ExecType execType = null;
            Query validQuery = this.noVersionQuery(ed.getName(), uniqueKey, uniqueKeyValue);
            SearchResult validResult = this.em.searchEntity(validQuery, new SearchOption().countTotal());
            if (validResult.getTotalCount() > 0) {
                execType = ExecType.UPDATE_NEW;
                entity.setVersion(null);
                entity.setOid(((Entity)validResult.getFirst()).getOid());
            } else {
                Query versionedOidQuery = this.onVersionQuery(ed.getName(), uniqueKey, uniqueKeyValue, null);
                SearchResult versionedOidResult = this.em.searchEntity(versionedOidQuery, new SearchOption().countTotal());
                if (versionedOidResult.getTotalCount() > 0) {
                    execType = ExecType.UPDATE_NEW;
                    entity.setVersion(((Entity)versionedOidResult.getFirst()).getVersion());
                    entity.setOid(((Entity)versionedOidResult.getFirst()).getOid());
                } else {
                    execType = ExecType.INSERT;
                }
            }
            return execType;
        }

        private Query noVersionQuery(String defName, String uniqueKey, Object uniqueKeyValue) {
            return new Query().select(new Object[]{"oid"}).from(defName).where((Condition)new Equals(uniqueKey, uniqueKeyValue));
        }

        private Query onVersionQuery(String defName, String uniqueKey, Object uniqueKeyValue, Long version) {
            Query query = new Query().select(new Object[]{"oid", "version"}).from(defName).order(new SortSpec[]{new SortSpec("version", SortSpec.SortType.DESC)}).versioned(true);
            if (version != null) {
                query.where((Condition)new And(new Condition[]{new Equals(uniqueKey, uniqueKeyValue), new Equals("version", (Object)version)}));
            } else {
                query.where((Condition)new Equals(uniqueKey, uniqueKeyValue));
            }
            return query;
        }

        private UpdateOption updateOption(ExecType execType) {
            UpdateOption option = new UpdateOption(false);
            if (this.updatableProperties == null) {
                this.updatableProperties = this.updateProperties != null ? this.updateProperties : this.filterProperties();
            }
            option.setUpdateProperties(new ArrayList<String>(this.updatableProperties));
            TargetVersion targetVersion = null;
            if (execType == ExecType.UPDATE_SPECIFIC) {
                targetVersion = TargetVersion.SPECIFIC;
            } else if (execType == ExecType.UPDATE_VALID) {
                targetVersion = TargetVersion.CURRENT_VALID;
            } else if (execType == ExecType.UPDATE_NEW) {
                targetVersion = TargetVersion.NEW;
            }
            option.setTargetVersion(targetVersion);
            return option;
        }

        private Set<String> filterProperties() {
            return this.properties.stream().filter(s -> !s.equals("oid") && !s.equals("version") && !s.equals("updateBy") && !s.equals("updateDate") && !s.equals("lockedBy") && !s.equals("createBy") && !s.equals("createDate") && !s.equals("_useCtrl")).map(s -> this.ed.getProperty(s)).filter(pd -> pd != null).filter(pd -> pd.isUpdatable()).filter(pd -> !(pd instanceof ExpressionProperty) && !(pd instanceof BinaryProperty)).filter(pd -> !(pd instanceof ReferenceProperty) || ((ReferenceProperty)pd).getMappedBy() == null).map(PropertyDefinition::getName).collect(Collectors.toSet());
        }
    }

    private static enum ExecType {
        INSERT,
        UPDATE_SPECIFIC,
        UPDATE_VALID,
        UPDATE_NEW;

    }
}

