/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.fileport;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.Callable;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.impl.async.ExceptionHandleable;
import org.iplass.mtp.impl.fileport.EntityCsvImportOption;
import org.iplass.mtp.impl.fileport.EntityCsvImportResult;
import org.iplass.mtp.impl.fileport.EntityCsvImportService;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityCsvImportTask
implements Callable<EntityCsvImportResult>,
ExceptionHandleable,
Serializable {
    private static final long serialVersionUID = 8823049367792641192L;
    private static Logger logger = LoggerFactory.getLogger(EntityCsvImportTask.class);
    private String filePath;
    private String defName;
    private EntityCsvImportOption option;
    final List<String> excludeEntityNames;

    public EntityCsvImportTask(String filePath, String defName, EntityCsvImportOption option, List<String> excludeEntityNames) {
        this.filePath = filePath;
        this.defName = defName;
        this.option = option;
        this.excludeEntityNames = excludeEntityNames;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getDefName() {
        return this.defName;
    }

    public EntityCsvImportOption getOption() {
        return this.option;
    }

    public List<String> getExcludeEntityNames() {
        return this.excludeEntityNames;
    }

    public void aborted(Throwable cause) {
    }

    public void timeouted() {
    }

    public void canceled() {
    }

    @Override
    public EntityCsvImportResult call() throws Exception {
        EntityCsvImportService importService = (EntityCsvImportService)ServiceRegistry.getRegistry().getService(EntityCsvImportService.class);
        String entityPath = "/entity/" + this.defName.replace(".", "/");
        MetaDataEntry entry = MetaDataContext.getContext().getMetaDataEntry(entityPath);
        try {
            EntityCsvImportResult entityCsvImportResult;
            FileInputStream is = new FileInputStream(this.filePath);
            try {
                EntityCsvImportResult ret;
                entityCsvImportResult = ret = importService.importEntityData(this.defName, is, entry, this.option, null, null, this.excludeEntityNames);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new SystemException((Throwable)e);
                }
            }
            ((InputStream)is).close();
            return entityCsvImportResult;
        }
        finally {
            this.deleteFile();
        }
    }

    private void deleteFile() {
        try {
            Files.deleteIfExists(Paths.get(this.filePath, new String[0]));
        }
        catch (IOException e) {
            logger.warn("Fail to delete a Temporary's File.", (Throwable)e);
        }
    }
}

