/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import org.iplass.mtp.SystemException;

public class OAuthUtil {
    public static String encodeRfc3986(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            throw new SystemException((Throwable)e);
        }
    }

    public static String calcCodeChallenge(String codeChallengeMethod, String codeVerifier) {
        if (codeVerifier == null) {
            return null;
        }
        if (codeChallengeMethod == null) {
            return codeVerifier;
        }
        switch (codeChallengeMethod) {
            case "plain": {
                return codeVerifier;
            }
            case "S256": {
                try {
                    return Base64.getUrlEncoder().withoutPadding().encodeToString(MessageDigest.getInstance("SHA-256").digest(codeVerifier.getBytes("UTF-8")));
                }
                catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
                    throw new SystemException((Throwable)e);
                }
            }
        }
        return null;
    }

    public static String atHash(String accessToken, String jwtSignAlg) {
        return OAuthUtil.hashValue(accessToken, jwtSignAlg);
    }

    public static String cHash(String code, String jwtSignAlg) {
        return OAuthUtil.hashValue(code, jwtSignAlg);
    }

    private static String hashValue(String target, String jwtSignAlg) {
        try {
            MessageDigest md = MessageDigest.getInstance(OAuthUtil.hashAlg(jwtSignAlg));
            byte[] b = md.digest(target.getBytes("UTF-8"));
            return Base64.getUrlEncoder().withoutPadding().encodeToString(Arrays.copyOf(b, b.length / 2));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new SystemException((Throwable)e);
        }
    }

    private static String hashAlg(String jwtSignAlg) {
        switch (jwtSignAlg) {
            case "HS256": 
            case "ES256": 
            case "RS256": 
            case "PS256": {
                return "SHA-256";
            }
            case "HS384": 
            case "ES384": 
            case "RS384": 
            case "PS384": {
                return "SHA-384";
            }
            case "HS512": 
            case "ES512": 
            case "RS512": 
            case "PS512": {
                return "SHA-512";
            }
        }
        throw new IllegalArgumentException("unknown jwtSignAlg:" + jwtSignAlg);
    }
}

