/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.jwt;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.iplass.mtp.impl.auth.oauth.OAuthAuthorizationService;
import org.iplass.mtp.impl.auth.oauth.jwt.CertificateKeyPair;
import org.iplass.mtp.impl.auth.oauth.jwt.JwtKeyRolloverType;
import org.iplass.mtp.impl.auth.oauth.jwt.JwtKeyStore;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJwtKeyStore
implements JwtKeyStore {
    private static Logger logger = LoggerFactory.getLogger(SimpleJwtKeyStore.class);
    private String keyStoreType = "PKCS12";
    private String keyStoreProvider;
    private String keyStoreFilePath;
    private String keyStorePassword;
    private Map<String, String> keyPasswordMap;
    private Integer keyStoreReloadIntervalMinutes;
    private JwtKeyRolloverType rollOverType = JwtKeyRolloverType.OLDER;
    private long rollOverDaysBeforeExpire;
    private volatile CertStore certStore;

    protected InputStream inputStreamFromFile() throws IOException {
        InputStream is = this.getClass().getResourceAsStream(this.keyStoreFilePath);
        if (is == null) {
            is = new FileInputStream(this.keyStoreFilePath);
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CertStore getStore() {
        if (this.certStore == null) {
            return null;
        }
        long now = System.currentTimeMillis();
        if (this.certStore.expires < now) {
            SimpleJwtKeyStore simpleJwtKeyStore = this;
            synchronized (simpleJwtKeyStore) {
                if (this.certStore.expires < now) {
                    try {
                        this.certStore = new CertStore(this);
                    }
                    catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
                        logger.error("Can't load KeyStore", (Throwable)e);
                    }
                }
            }
        }
        return this.certStore;
    }

    public JwtKeyRolloverType getRollOverType() {
        return this.rollOverType;
    }

    public void setRollOverType(JwtKeyRolloverType rollOverType) {
        this.rollOverType = rollOverType;
    }

    public long getRollOverDaysBeforeExpire() {
        return this.rollOverDaysBeforeExpire;
    }

    public void setRollOverDaysBeforeExpire(long rollOverDaysBeforeExpire) {
        this.rollOverDaysBeforeExpire = rollOverDaysBeforeExpire;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    public void setKeyStoreProvider(String keyStoreProvider) {
        this.keyStoreProvider = keyStoreProvider;
    }

    public String getKeyStoreFilePath() {
        return this.keyStoreFilePath;
    }

    public void setKeyStoreFilePath(String keyStoreFilePath) {
        this.keyStoreFilePath = keyStoreFilePath;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public Map<String, String> getKeyPasswordMap() {
        return this.keyPasswordMap;
    }

    public void setKeyPasswordMap(Map<String, String> keyPasswordMap) {
        this.keyPasswordMap = keyPasswordMap;
    }

    public Integer getKeyStoreReloadIntervalMinutes() {
        return this.keyStoreReloadIntervalMinutes;
    }

    public void setKeyStoreReloadIntervalMinutes(Integer keyStoreReloadIntervalMinutes) {
        this.keyStoreReloadIntervalMinutes = keyStoreReloadIntervalMinutes;
    }

    @Override
    public CertificateKeyPair getCertificateKeyPair() {
        return this.rollOverType.select(this);
    }

    private CertificateKeyPair getCertificateKeyPair(String keyId, CertStore cs) throws CertificateExpiredException, CertificateNotYetValidException {
        String keyPass = null;
        if (cs != null) {
            if (this.keyPasswordMap != null) {
                keyPass = this.keyPasswordMap.get(keyId);
            }
            if (keyPass == null) {
                keyPass = this.keyStorePassword;
            }
        }
        try {
            X509Certificate c = (X509Certificate)cs.store.getCertificate(keyId);
            try {
                Key k = cs.store.getKey(keyId, keyPass.toCharArray());
                if (k instanceof PrivateKey) {
                    return new CertificateKeyPair(keyId, c, (PrivateKey)k);
                }
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                logger.error("JwtKey:" + keyId + " can't recover by password.", (Throwable)e);
            }
        }
        catch (KeyStoreException e) {
            logger.error("Can't get JwtKey:" + keyId + " cause:" + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public List<CertificateKeyPair> list() {
        CertStore cs = this.getStore();
        if (cs != null) {
            ArrayList<CertificateKeyPair> list = new ArrayList<CertificateKeyPair>();
            for (String keyId : cs.aliases) {
                CertificateKeyPair pair = null;
                try {
                    pair = this.getCertificateKeyPair(keyId, cs);
                    pair.getCertificate().checkValidity();
                }
                catch (CertificateExpiredException e) {
                    pair = null;
                    logger.debug("JwtKey:" + keyId + " is expired.");
                }
                catch (CertificateNotYetValidException e) {
                    logger.debug("JwtKey:" + keyId + " is not yet valid.");
                }
                if (pair == null) continue;
                list.add(pair);
            }
            return list;
        }
        return Collections.emptyList();
    }

    public void destroyed() {
        this.certStore = null;
    }

    public void inited(OAuthAuthorizationService service, Config config) {
        if (this.keyStoreType != null) {
            try {
                this.certStore = new CertStore(this);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
                throw new ServiceConfigrationException("Cant load KeyStore", (Throwable)e);
            }
        }
    }

    private class CertStore {
        private final long expires;
        private final KeyStore store;
        private final List<String> aliases;

        private CertStore(SimpleJwtKeyStore simpleJwtKeyStore) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, NoSuchProviderException {
            KeyStore ks = simpleJwtKeyStore.keyStoreProvider == null ? KeyStore.getInstance(simpleJwtKeyStore.keyStoreType) : KeyStore.getInstance(simpleJwtKeyStore.keyStoreType, simpleJwtKeyStore.keyStoreProvider);
            if (simpleJwtKeyStore.keyStoreFilePath != null) {
                logger.debug("load keyStore: " + simpleJwtKeyStore.keyStoreFilePath);
                try (InputStream is = simpleJwtKeyStore.inputStreamFromFile();
                     BufferedInputStream bis = new BufferedInputStream(is);){
                    if (simpleJwtKeyStore.keyStorePassword != null) {
                        ks.load(bis, simpleJwtKeyStore.keyStorePassword.toCharArray());
                    }
                    ks.load(bis, null);
                }
            } else if (simpleJwtKeyStore.keyStorePassword != null) {
                ks.load(null, simpleJwtKeyStore.keyStorePassword.toCharArray());
            } else {
                ks.load(null, null);
            }
            this.store = ks;
            ArrayList<String> al = new ArrayList<String>();
            Enumeration<String> en = ks.aliases();
            while (en.hasMoreElements()) {
                String name = en.nextElement();
                Certificate c = ks.getCertificate(name);
                if (!(c instanceof X509Certificate)) continue;
                X509Certificate cert = (X509Certificate)c;
                boolean valid = false;
                try {
                    cert.checkValidity();
                    valid = true;
                }
                catch (CertificateExpiredException e) {
                    logger.warn("JwtKey:" + name + " is expired.");
                }
                catch (CertificateNotYetValidException e) {
                    valid = true;
                }
                if (!valid) continue;
                try {
                    Key k;
                    String keyPass = null;
                    if (simpleJwtKeyStore.keyPasswordMap != null) {
                        keyPass = simpleJwtKeyStore.keyPasswordMap.get(name);
                    }
                    if (keyPass == null) {
                        keyPass = simpleJwtKeyStore.keyStorePassword;
                    }
                    if (!((k = ks.getKey(name, keyPass.toCharArray())) instanceof PrivateKey)) continue;
                    al.add(name);
                }
                catch (UnrecoverableKeyException e) {
                    logger.error("JwtKey(PrivateKey):" + name + " can't recover by password.", (Throwable)e);
                }
            }
            this.expires = simpleJwtKeyStore.keyStoreReloadIntervalMinutes != null && simpleJwtKeyStore.keyStoreReloadIntervalMinutes > 0 ? System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(simpleJwtKeyStore.keyStoreReloadIntervalMinutes.intValue()) : Long.MAX_VALUE;
            this.aliases = al;
            if (this.aliases.size() == 0) {
                logger.warn("Currently non expired JwtKey does not exists.");
            }
        }
    }
}

