/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.jwt;

public enum EllipticCurveSpec {
    P_256("P-256", 32, "secp256r1"),
    P_384("P-384", 48, "secp384r1"),
    P_521("P-521", 66, "secp521r1");

    private final String curveName;
    private final int octetStringLength;
    private final String standardName;

    private EllipticCurveSpec(String curveName, int octetStringLength, String standardName) {
        this.curveName = curveName;
        this.octetStringLength = octetStringLength;
        this.standardName = standardName;
    }

    public String getStandardName() {
        return this.standardName;
    }

    public String getCurveName() {
        return this.curveName;
    }

    public int getOctetStringLength() {
        return this.octetStringLength;
    }

    static EllipticCurveSpec preferredSpec(int keyLength) {
        if (keyLength >= 512) {
            return P_521;
        }
        if (keyLength >= 384) {
            return P_384;
        }
        return P_256;
    }

    static EllipticCurveSpec fromCurveName(String curveName) {
        for (EllipticCurveSpec v : EllipticCurveSpec.values()) {
            if (!v.getCurveName().equals(curveName)) continue;
            return v;
        }
        throw new IllegalArgumentException("Unsupported curve name:" + curveName);
    }
}

