/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.jwt;

import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import org.iplass.mtp.impl.auth.oauth.jwt.EllipticCurveSpec;
import org.iplass.mtp.impl.auth.oauth.jwt.InvalidKeyException;

public class CertificateKeyPair {
    static final String JWK_PARAM_KID = "kid";
    static final String JWK_PARAM_ALG = "alg";
    static final String JWK_PARAM_USE = "use";
    static final String JWK_PARAM_KTY = "kty";
    static final String JWK_PARAM_X = "x";
    static final String JWK_PARAM_Y = "y";
    static final String JWK_PARAM_CRV = "crv";
    static final String JWK_PARAM_E = "e";
    static final String JWK_PARAM_N = "n";
    static final String USE_SIG = "sig";
    static final String KTY_RSA = "RSA";
    static final String KTY_EC = "EC";
    static final String ALG_NONE = "none";
    private final String keyId;
    private final PrivateKey privateKey;
    private final PublicKey publicKey;
    private final X509Certificate certificate;

    public CertificateKeyPair(String keyId, X509Certificate certificate, PrivateKey privateKey) {
        this.keyId = keyId;
        this.certificate = certificate;
        this.privateKey = privateKey;
        this.publicKey = certificate.getPublicKey();
    }

    public CertificateKeyPair(String keyId, PublicKey publicKey, PrivateKey privateKey) {
        this.keyId = keyId;
        this.certificate = null;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public CertificateKeyPair(Map<String, Object> jwkMap) throws InvalidKeyException {
        this.keyId = (String)jwkMap.get(JWK_PARAM_KID);
        if (this.keyId == null) {
            throw new NullPointerException("keyId is null");
        }
        this.certificate = null;
        this.privateKey = null;
        String kty = (String)jwkMap.get(JWK_PARAM_KTY);
        if (KTY_RSA.equals(kty)) {
            try {
                BigInteger n = CertificateKeyPair.base64ToInt((String)jwkMap.get(JWK_PARAM_N));
                BigInteger e = CertificateKeyPair.base64ToInt((String)jwkMap.get(JWK_PARAM_E));
                RSAPublicKeySpec keySpec = new RSAPublicKeySpec(n, e);
                KeyFactory keyFactory = KeyFactory.getInstance(KTY_RSA);
                this.publicKey = keyFactory.generatePublic(keySpec);
            }
            catch (RuntimeException | NoSuchAlgorithmException | InvalidKeySpecException e) {
                throw new InvalidKeyException("Invalid JWK parameter:" + String.valueOf(jwkMap), e);
            }
        } else if (KTY_EC.equals(kty)) {
            try {
                BigInteger x = CertificateKeyPair.base64ToInt((String)jwkMap.get(JWK_PARAM_X));
                BigInteger y = CertificateKeyPair.base64ToInt((String)jwkMap.get(JWK_PARAM_Y));
                ECPoint point = new ECPoint(x, y);
                AlgorithmParameters algParams = AlgorithmParameters.getInstance(KTY_EC);
                EllipticCurveSpec crvSpec = EllipticCurveSpec.fromCurveName((String)jwkMap.get(JWK_PARAM_CRV));
                algParams.init(new ECGenParameterSpec(crvSpec.getStandardName()));
                ECParameterSpec ecParamSpec = algParams.getParameterSpec(ECParameterSpec.class);
                ECPublicKeySpec keySpec = new ECPublicKeySpec(point, ecParamSpec);
                KeyFactory keyFactory = KeyFactory.getInstance(KTY_EC);
                this.publicKey = keyFactory.generatePublic(keySpec);
            }
            catch (RuntimeException | NoSuchAlgorithmException | InvalidKeySpecException | InvalidParameterSpecException e) {
                throw new InvalidKeyException("Invalid JWK parameter:" + String.valueOf(jwkMap), e);
            }
        } else {
            throw new InvalidKeyException("Unsupported key type:" + kty);
        }
    }

    public String getKeyId() {
        return this.keyId;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public Map<String, Object> toPublicJwkMap(String alg) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(JWK_PARAM_KID, this.keyId);
        map.put(JWK_PARAM_KTY, this.privateKey.getAlgorithm());
        map.put(JWK_PARAM_USE, USE_SIG);
        map.put(JWK_PARAM_ALG, alg);
        if (this.publicKey instanceof RSAPublicKey) {
            RSAPublicKey rsaPubKey = (RSAPublicKey)this.publicKey;
            map.put(JWK_PARAM_N, CertificateKeyPair.intToBase64(rsaPubKey.getModulus(), -1));
            map.put(JWK_PARAM_E, CertificateKeyPair.intToBase64(rsaPubKey.getPublicExponent(), -1));
        } else if (this.publicKey instanceof ECPublicKey) {
            ECPublicKey ecPubKey = (ECPublicKey)this.publicKey;
            EllipticCurveSpec spec = EllipticCurveSpec.preferredSpec(ecPubKey.getParams().getOrder().bitLength());
            map.put(JWK_PARAM_CRV, spec.getCurveName());
            ECPoint w = ecPubKey.getW();
            map.put(JWK_PARAM_X, CertificateKeyPair.intToBase64(w.getAffineX(), spec.getOctetStringLength()));
            map.put(JWK_PARAM_Y, CertificateKeyPair.intToBase64(w.getAffineY(), spec.getOctetStringLength()));
        }
        return map;
    }

    static String intToBase64(BigInteger num, int length) {
        byte[] bb;
        byte[] b = num.toByteArray();
        if (num.bitLength() % 8 == 0 && b[0] == 0 && b.length != 0) {
            bb = new byte[b.length - 1];
            System.arraycopy(b, 1, bb, 0, bb.length);
            b = bb;
        }
        if (length > 0 && length > b.length) {
            bb = new byte[length];
            System.arraycopy(b, 0, bb, length - b.length, b.length);
            b = bb;
        }
        return Base64.getUrlEncoder().withoutPadding().encodeToString(b);
    }

    static BigInteger base64ToInt(String value) {
        return new BigInteger(1, Base64.getUrlDecoder().decode(value));
    }
}

