/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.auth.oauth.definition.ClaimMappingDefinition;
import org.iplass.mtp.auth.oauth.definition.OIDCClaimScopeDefinition;
import org.iplass.mtp.auth.oauth.definition.ScopeDefinition;
import org.iplass.mtp.impl.auth.oauth.MetaClaimMapping;
import org.iplass.mtp.impl.auth.oauth.MetaScope;

public class MetaOIDCClaimScope
extends MetaScope {
    private static final long serialVersionUID = 4677632824181886235L;
    private List<MetaClaimMapping> claims;

    public List<MetaClaimMapping> getClaims() {
        return this.claims;
    }

    public void setClaims(List<MetaClaimMapping> claims) {
        this.claims = claims;
    }

    @Override
    public void applyConfig(ScopeDefinition def) {
        super.applyConfig(def);
        OIDCClaimScopeDefinition odef = (OIDCClaimScopeDefinition)def;
        if (odef.getClaims() != null) {
            this.claims = new ArrayList<MetaClaimMapping>();
            for (ClaimMappingDefinition cmd : odef.getClaims()) {
                MetaClaimMapping mcm = new MetaClaimMapping();
                mcm.applyConfig(cmd);
                this.claims.add(mcm);
            }
        } else {
            this.claims = null;
        }
    }

    @Override
    public OIDCClaimScopeDefinition currentConfig() {
        OIDCClaimScopeDefinition def = new OIDCClaimScopeDefinition();
        this.fill(def);
        if (this.claims != null) {
            ArrayList<ClaimMappingDefinition> list = new ArrayList<ClaimMappingDefinition>();
            for (MetaClaimMapping mcm : this.claims) {
                list.add(mcm.currentConfig());
            }
            def.setClaims(list);
        }
        return def;
    }

    public OIDCClaimScopeRuntime createRuntime(String defName) {
        return new OIDCClaimScopeRuntime(this, defName);
    }

    public class OIDCClaimScopeRuntime {
        private List<MetaClaimMapping.ClaimMappingRuntime> claimRuntimes;

        private OIDCClaimScopeRuntime(MetaOIDCClaimScope this$0, String defName) {
            if (this$0.claims != null) {
                this.claimRuntimes = new ArrayList<MetaClaimMapping.ClaimMappingRuntime>();
                for (MetaClaimMapping m : this$0.claims) {
                    this.claimRuntimes.add(m.createRuntime(defName, this$0.getName()));
                }
            }
        }

        public void map(User user, Map<String, Object> claimMap) {
            if (this.claimRuntimes != null) {
                for (MetaClaimMapping.ClaimMappingRuntime cmr : this.claimRuntimes) {
                    Object val = cmr.value(user);
                    if (val == null) continue;
                    claimMap.put(cmr.name(), val);
                }
            }
        }
    }
}

