/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.oidc.jwks;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.impl.auth.authenticate.oidc.OpenIdConnectService;

public abstract class Jwks {
    static final String JWK_PARAM_KID = "kid";
    static final String JWKS_PARAM_KEYS = "keys";
    protected OpenIdConnectService service;

    Jwks(OpenIdConnectService service) {
        this.service = service;
    }

    public abstract Map<String, Object> get(String var1);

    public abstract List<String> kidList();

    protected Map<String, Map<String, Object>> toJwksMap(String content) {
        try {
            Map parsed = (Map)this.service.getObjectMapper().readValue(content, (TypeReference)new TypeReference<Map<String, Object>>(this){});
            HashMap<String, Map<String, Object>> ret = new HashMap<String, Map<String, Object>>();
            List jwkList = (List)parsed.get(JWKS_PARAM_KEYS);
            if (jwkList != null) {
                for (Map jwk : jwkList) {
                    ret.put((String)jwk.get(JWK_PARAM_KID), jwk);
                }
            }
            return ret;
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("can't parse JWKS contents", e);
        }
    }
}

