/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.oidc;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.iplass.mtp.auth.oidc.definition.ClientAuthenticationType;
import org.iplass.mtp.impl.auth.authenticate.oidc.OIDCRuntimeException;
import org.iplass.mtp.impl.auth.authenticate.oidc.OpenIdConnectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OPEndpoint {
    private static Logger logger = LoggerFactory.getLogger(OPEndpoint.class);
    private String tokenEndpointUrl;
    private String userInfoEndpointUrl;
    private OpenIdConnectService opService;

    public OPEndpoint(String tokenEndpointUrl, String userInfoEndpointUrl, OpenIdConnectService opService) {
        this.tokenEndpointUrl = tokenEndpointUrl;
        this.userInfoEndpointUrl = userInfoEndpointUrl;
        this.opService = opService;
    }

    public Map<String, Object> token(ClientAuthenticationType clientAuthenticationType, String clientId, String clientSecret, String code, String redirectUri, String codeVerifier) {
        try {
            String content = null;
            HttpClient client = this.opService.getHttpClient();
            HttpPost post = new HttpPost(this.tokenEndpointUrl);
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            if (clientAuthenticationType == ClientAuthenticationType.CLIENT_SECRET_BASIC) {
                post.setHeader("Authorization", (Object)("Basic " + Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes("UTF-8"))));
            } else {
                nvps.add(new BasicNameValuePair("client_id", clientId));
                nvps.add(new BasicNameValuePair("client_secret", clientSecret));
            }
            nvps.add(new BasicNameValuePair("code", code));
            nvps.add(new BasicNameValuePair("redirect_uri", redirectUri));
            nvps.add(new BasicNameValuePair("grant_type", "authorization_code"));
            if (codeVerifier != null) {
                nvps.add(new BasicNameValuePair("code_verifier", codeVerifier));
            }
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
            content = (String)client.execute((ClassicHttpRequest)post, res -> {
                HttpEntity entity = res.getEntity();
                try {
                    String string = EntityUtils.toString((HttpEntity)entity);
                    return string;
                }
                finally {
                    EntityUtils.consume((HttpEntity)entity);
                }
            });
            return (Map)this.opService.getObjectMapper().readValue(content, (TypeReference)new TypeReference<Map<String, Object>>(this){});
        }
        catch (IOException e) {
            throw new OIDCRuntimeException(e);
        }
    }

    public Map<String, Object> userInfo(String tokenType, String accessToken) {
        try {
            HttpGet get = new HttpGet(this.userInfoEndpointUrl);
            get.setHeader("Authorization", (Object)(tokenType + " " + accessToken));
            return (Map)this.opService.getHttpClient().execute((ClassicHttpRequest)get, res -> {
                HttpEntity entity = res.getEntity();
                try {
                    String content = EntityUtils.toString((HttpEntity)entity);
                    Map map = (Map)this.opService.getObjectMapper().readValue(content, (TypeReference)new TypeReference<Map<String, Object>>(this){});
                    return map;
                }
                finally {
                    EntityUtils.consume((HttpEntity)entity);
                }
            });
        }
        catch (IOException e) {
            throw new OIDCRuntimeException(e);
        }
    }
}

