/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.oidc;

import java.util.HashMap;
import java.util.Map;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.impl.auth.authenticate.oidc.OIDCState;

public class OIDCCredential
implements Credential {
    public static final String FACTOR_OP_DEFINITION_NAME = "openIdProviderDefinitionName";
    public static final String FACTOR_CODE = "code";
    public static final String FACTOR_STATE_TOKEN = "stateToken";
    public static final String FACTOR_REDIRECT_URI = "redirectUri";
    public static final String FACTOR_ISS = "iss";
    public static final String FACTOR_STATE = "state";
    private String id;
    private String openIdConnectDefinitionName;
    private String code;
    private String stateToken;
    private String redirectUri;
    private String iss;
    private OIDCState state;
    private Map<String, Object> additionalAuthenticationFactor;

    public OIDCCredential() {
    }

    public OIDCCredential(String id) {
        this.id = id;
    }

    public OIDCCredential(String openIdConnectDefinitionName, String code, String stateToken, String redirectUri, String iss, OIDCState state) {
        this.openIdConnectDefinitionName = openIdConnectDefinitionName;
        this.code = code;
        this.stateToken = stateToken;
        this.redirectUri = redirectUri;
        this.iss = iss;
        this.state = state;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOpenIdConnectDefinitionName() {
        return this.openIdConnectDefinitionName;
    }

    public void setOpenIdConnectDefinitionName(String openIdConnectDefinitionName) {
        this.openIdConnectDefinitionName = openIdConnectDefinitionName;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getStateToken() {
        return this.stateToken;
    }

    public void setStateToken(String stateToken) {
        this.stateToken = stateToken;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getIss() {
        return this.iss;
    }

    public void setIss(String iss) {
        this.iss = iss;
    }

    public OIDCState getState() {
        return this.state;
    }

    public void setState(OIDCState state) {
        this.state = state;
    }

    public Object getAuthenticationFactor(String name) {
        switch (name) {
            case "openIdProviderDefinitionName": {
                return this.openIdConnectDefinitionName;
            }
            case "code": {
                return this.code;
            }
            case "stateToken": {
                return this.stateToken;
            }
            case "redirectUri": {
                return this.redirectUri;
            }
            case "iss": {
                return this.iss;
            }
            case "state": {
                return this.state;
            }
        }
        if (this.additionalAuthenticationFactor == null) {
            return null;
        }
        return this.additionalAuthenticationFactor.get(name);
    }

    public void setAuthenticationFactor(String name, Object value) {
        switch (name) {
            case "openIdProviderDefinitionName": {
                this.openIdConnectDefinitionName = (String)value;
                break;
            }
            case "code": {
                this.code = (String)value;
                break;
            }
            case "stateToken": {
                this.stateToken = (String)value;
                break;
            }
            case "redirectUri": {
                this.redirectUri = (String)value;
                break;
            }
            case "iss": {
                this.iss = (String)value;
                break;
            }
            case "state": {
                this.state = (OIDCState)value;
                break;
            }
            default: {
                if (this.additionalAuthenticationFactor == null) {
                    this.additionalAuthenticationFactor = new HashMap<String, Object>();
                }
                this.additionalAuthenticationFactor.put(name, value);
            }
        }
    }
}

