/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.builtin.web;

import jakarta.servlet.http.HttpServletRequest;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.IdPasswordCredential;
import org.iplass.mtp.auth.login.LoginFailedException;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.impl.auth.UserContext;
import org.iplass.mtp.impl.auth.authenticate.AutoLoginHandler;
import org.iplass.mtp.impl.auth.authenticate.AutoLoginInstruction;
import org.iplass.mtp.impl.auth.authenticate.builtin.web.BasicAuthUtil;
import org.iplass.mtp.impl.auth.authenticate.builtin.web.WWWAuthenticateException;
import org.iplass.mtp.impl.webapi.rest.RestRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdPasswordAutoLoginHandler
implements AutoLoginHandler {
    private static Logger logger = LoggerFactory.getLogger(IdPasswordAutoLoginHandler.class);
    public static final String AUTH_ID_HEADER = "X-Auth-Id";
    public static final String AUTH_PASSWORD_HEADER = "X-Auth-Password";
    private boolean enableBasicAuthentication;
    private boolean rejectAmbiguousRequest;

    public boolean isRejectAmbiguousRequest() {
        return this.rejectAmbiguousRequest;
    }

    public void setRejectAmbiguousRequest(boolean rejectAmbiguousRequest) {
        this.rejectAmbiguousRequest = rejectAmbiguousRequest;
    }

    public boolean isEnableBasicAuthentication() {
        return this.enableBasicAuthentication;
    }

    public void setEnableBasicAuthentication(boolean enableBasicAuthentication) {
        this.enableBasicAuthentication = enableBasicAuthentication;
    }

    private IdPasswordCredential idPassFromHeader(RequestContext req) {
        IdPasswordCredential cre;
        HttpServletRequest hr = (HttpServletRequest)req.getAttribute("servletRequest");
        String id = null;
        String pass = null;
        id = hr.getHeader(AUTH_ID_HEADER);
        if (id != null && id.length() > 0) {
            logger.debug("handle custom header authentication");
            pass = hr.getHeader(AUTH_PASSWORD_HEADER);
            return new IdPasswordCredential(id, pass);
        }
        if (this.enableBasicAuthentication && (cre = BasicAuthUtil.decodeFromHeader(req)) != null) {
            logger.debug("handle basic authentication");
            return cre;
        }
        return null;
    }

    public AutoLoginInstruction handle(RequestContext req, boolean isLogined, UserContext user) {
        if (!(req instanceof RestRequestContext)) {
            return AutoLoginInstruction.THROUGH;
        }
        IdPasswordCredential cre = this.idPassFromHeader(req);
        if (cre == null) {
            return AutoLoginInstruction.THROUGH;
        }
        if (isLogined) {
            if (!cre.getId().equals(user.getAccount().getCredential().getId())) {
                if (this.rejectAmbiguousRequest) {
                    throw new LoginFailedException("another login session is avaliable");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("login session is avaliable, but another id/pass is specified. current id:" + user.getAccount().getCredential().getId() + ", request id:" + cre.getId());
                } else {
                    logger.warn("login session is avaliable, but another id/pass is specified.");
                }
            }
            return AutoLoginInstruction.THROUGH;
        }
        return new AutoLoginInstruction((Credential)cre);
    }

    public void handleSuccess(AutoLoginInstruction ali, RequestContext req, UserContext user) {
    }

    public Exception handleException(AutoLoginInstruction ali, ApplicationException e, RequestContext req, boolean isLogined, UserContext user) {
        if (this.isBasicAuth(req)) {
            throw new WWWAuthenticateException("Basic", null, "Login with BASIC Authentication failed.");
        }
        throw e;
    }

    private boolean isBasicAuth(RequestContext req) {
        if (!this.enableBasicAuthentication) {
            return false;
        }
        HttpServletRequest hr = (HttpServletRequest)req.getAttribute("servletRequest");
        return hr.getHeader(AUTH_ID_HEADER) == null;
    }
}

