/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.builtin.web;

import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.auth.login.IdPasswordCredential;
import org.iplass.mtp.command.RequestContext;

public class BasicAuthUtil {
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String AUTH_SCHEME_BASIC = "Basic";

    public static IdPasswordCredential decodeFromHeader(RequestContext req) {
        HttpServletRequest hr = (HttpServletRequest)req.getAttribute("servletRequest");
        String authHeaderValue = hr.getHeader(HEADER_AUTHORIZATION);
        if (authHeaderValue != null && authHeaderValue.regionMatches(true, 0, "Basic ", 0, AUTH_SCHEME_BASIC.length() + 1)) {
            String idpass;
            String idpassEncoded = authHeaderValue.substring(AUTH_SCHEME_BASIC.length() + 1).trim();
            try {
                idpass = new String(Base64.getDecoder().decode(idpassEncoded), "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new SystemException((Throwable)e);
            }
            String id = null;
            String pass = null;
            int index = idpass.indexOf(58);
            if (index < 0) {
                id = idpass.trim();
            } else {
                id = idpass.substring(0, index).trim();
                pass = idpass.substring(index + 1).trim();
            }
            return new IdPasswordCredential(id, pass);
        }
        return null;
    }

    public static String encodeValue(IdPasswordCredential idpass) {
        String str = idpass.getId() + ":" + idpass.getPassword();
        try {
            return "Basic " + Base64.getEncoder().encodeToString(str.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }
}

