/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi.interceptors;

import java.util.HashMap;
import java.util.Map;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.auth.NeedTrustedAuthenticationException;
import org.iplass.mtp.auth.NoPermissionException;
import org.iplass.mtp.auth.Permission;
import org.iplass.mtp.command.interceptor.CommandInterceptor;
import org.iplass.mtp.command.interceptor.CommandInvocation;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.UserContext;
import org.iplass.mtp.impl.auth.authenticate.AnonymousUserContext;
import org.iplass.mtp.impl.auth.authenticate.AuthenticationProvider;
import org.iplass.mtp.impl.auth.authenticate.AutoLoginHandler;
import org.iplass.mtp.impl.auth.authenticate.AutoLoginInstruction;
import org.iplass.mtp.impl.auth.authenticate.token.web.AuthorizationRequiredException;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.session.SessionService;
import org.iplass.mtp.impl.web.WebResourceBundleUtil;
import org.iplass.mtp.impl.web.i18n.LangSelector;
import org.iplass.mtp.impl.web.token.TokenStore;
import org.iplass.mtp.impl.webapi.MetaWebApi;
import org.iplass.mtp.impl.webapi.WebApiInvocationImpl;
import org.iplass.mtp.impl.webapi.rest.RestRequestContext;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.web.actionmapping.ResponseHeader;
import org.iplass.mtp.webapi.WebApiRuntimeException;
import org.iplass.mtp.webapi.permission.RequestContextWebApiParameter;
import org.iplass.mtp.webapi.permission.WebApiPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthInterceptor
implements CommandInterceptor {
    private static Logger logger = LoggerFactory.getLogger(AuthInterceptor.class);
    private LangSelector lang = new LangSelector();
    private AuthService authService = (AuthService)ServiceRegistry.getRegistry().getService(AuthService.class);
    private SessionService sessionService = (SessionService)ServiceRegistry.getRegistry().getService(SessionService.class);

    private AuthContextHolder getAuthContextHolder(MetaWebApi.WebApiRuntime webapi) {
        if (webapi.getMetaData().isPrivileged()) {
            if (logger.isDebugEnabled()) {
                logger.debug("do as Privileged webapi:" + webapi.getMetaData().getName());
            }
            return AuthContextHolder.getAuthContext().privilegedAuthContextHolder();
        }
        return AuthContextHolder.getAuthContext();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processAutoLogin(WebApiInvocationImpl invocation) {
        UserContext user = this.authService.getCurrentSessionUserContext();
        if (user != null && !(user instanceof AnonymousUserContext)) {
            AuthenticationProvider ap = this.authService.getAuthenticationProvider();
            AutoLoginHandler alh = ap.getAutoLoginHandler();
            if (alh == null) return;
            AutoLoginInstruction inst = alh.handle(invocation.getRequest(), true, user);
            switch (inst.getInstruction()) {
                case DO_AUTH: {
                    try {
                        this.authService.login(inst.getCredential());
                        alh.handleSuccess(inst, invocation.getRequest(), this.authService.getCurrentSessionUserContext());
                        this.responseToken(invocation);
                        return;
                    }
                    catch (ApplicationException e) {
                        Exception he = alh.handleException(inst, e, invocation.getRequest(), true, user);
                        if (he != null) {
                            if (!(he instanceof RuntimeException)) throw new WebApiRuntimeException(he);
                            throw (RuntimeException)he;
                        }
                        if (!logger.isDebugEnabled()) return;
                        logger.debug("auto login fail. cause:" + (Object)((Object)e));
                    }
                    return;
                }
                case LOGOUT: {
                    this.authService.logout();
                    return;
                }
                case ERROR: {
                    this.authService.logout();
                    if (!logger.isDebugEnabled()) throw new ApplicationException(AuthInterceptor.resourceString("auth.Login.noLogin", new Object[0]));
                    logger.debug("auto login fail. AutoLoginHandler return ERROR.");
                    throw new ApplicationException(AuthInterceptor.resourceString("auth.Login.noLogin", new Object[0]));
                }
            }
            return;
        } else {
            block14: for (AuthenticationProvider ap : this.authService.getAuthenticationProviders()) {
                AutoLoginHandler autoLoginHandler = ap.getAutoLoginHandler();
                if (autoLoginHandler == null) continue;
                AutoLoginInstruction inst = autoLoginHandler.handle(invocation.getRequest(), false, null);
                switch (inst.getInstruction()) {
                    case DO_AUTH: {
                        try {
                            this.authService.login(inst.getCredential());
                            autoLoginHandler.handleSuccess(inst, invocation.getRequest(), this.authService.getCurrentSessionUserContext());
                            this.responseToken(invocation);
                            return;
                        }
                        catch (ApplicationException e) {
                            Exception he = autoLoginHandler.handleException(inst, e, invocation.getRequest(), false, null);
                            if (he != null) {
                                if (!(he instanceof RuntimeException)) throw new WebApiRuntimeException(he);
                                throw (RuntimeException)he;
                            }
                            if (!logger.isDebugEnabled()) continue block14;
                            logger.debug("auto login fail. cause:" + (Object)((Object)e));
                            continue block14;
                        }
                    }
                    case LOGOUT: {
                        this.authService.logout();
                        return;
                    }
                    case ERROR: {
                        this.authService.logout();
                        if (!logger.isDebugEnabled()) throw new ApplicationException(AuthInterceptor.resourceString("auth.Login.noLogin", new Object[0]));
                        logger.debug("auto login fail. AutoLoginHandler return ERROR.");
                        throw new ApplicationException(AuthInterceptor.resourceString("auth.Login.noLogin", new Object[0]));
                    }
                }
            }
        }
    }

    private void responseToken(WebApiInvocationImpl invocation) {
        if (!this.sessionService.isSessionStateless()) {
            String token = TokenStore.getFixedToken(invocation.getRequest().getSession());
            ResponseHeader res = (ResponseHeader)invocation.getRequest().getAttribute("responseHeader");
            res.setHeader("X-Transaction-Token", token);
        }
    }

    public String intercept(CommandInvocation invocation) {
        WebApiInvocationImpl webApiInvocation = (WebApiInvocationImpl)invocation;
        this.processAutoLogin(webApiInvocation);
        AuthContextHolder account = this.getAuthContextHolder(webApiInvocation.getWebApiRuntime());
        return (String)this.authService.doSecuredAction(account, () -> {
            boolean isPermitted;
            this.lang.selectLangByUser(webApiInvocation.getRequest(), ExecuteContext.getCurrentContext());
            if (webApiInvocation.getWebApiRuntime().getMetaData().isPublicWebApi()) {
                isPermitted = true;
                if (logger.isDebugEnabled()) {
                    logger.debug("do as public webapi:" + webApiInvocation.getWebApiRuntime().getMetaData().getName());
                }
            } else {
                WebApiPermission permission = new WebApiPermission(webApiInvocation.getWebApiRuntime().getMetaData().getName(), new RequestContextWebApiParameter(webApiInvocation.getRequest(), this.additionalParam(webApiInvocation)));
                isPermitted = account.checkPermission((Permission)permission);
            }
            if (!isPermitted) {
                if (account.getUserContext() instanceof AnonymousUserContext && webApiInvocation.getWebApiRuntime().getMetaData().isSupportBearerToken()) {
                    throw new AuthorizationRequiredException("Bearer", null, "no_error_code_response", null);
                }
                throw new NoPermissionException(AuthInterceptor.resourceString("impl.webapi.WebAPIUtil.noPermission", new Object[0]));
            }
            if (webApiInvocation.getWebApiRuntime().getMetaData().isNeedTrustedAuthenticate() && !this.authService.checkCurrentSessionTrusted().isTrusted()) {
                throw new NeedTrustedAuthenticationException("need trusted authentication");
            }
            return invocation.proceedCommand();
        });
    }

    private Map<String, Object> additionalParam(WebApiInvocationImpl webApiInvocation) {
        MetaWebApi meta = webApiInvocation.getWebApiRuntime().getMetaData();
        RestRequestContext rc = (RestRequestContext)webApiInvocation.getRequest();
        String paramName = null;
        switch (rc.requestType()) {
            case REST_JSON: {
                paramName = meta.getRestJsonParameterName();
                break;
            }
            case REST_XML: {
                paramName = meta.getRestXmlParameterName();
                break;
            }
        }
        if (paramName != null) {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put(paramName, rc.getAttribute(paramName));
            return ret;
        }
        return null;
    }

    private static String resourceString(String key, Object ... arguments) {
        return WebResourceBundleUtil.resourceString(key, arguments);
    }
}

