/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi.command.entity;

import java.sql.Timestamp;
import java.util.Arrays;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.RestJson;
import org.iplass.mtp.command.annotation.webapi.RestXml;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.entity.TargetVersion;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.webapi.EntityWebApiService;
import org.iplass.mtp.impl.webapi.command.entity.AbstractEntityCommand;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;

@WebApi(name="mtp/entity/PUT", accepts={RequestType.REST_JSON, RequestType.REST_XML}, methods={MethodType.PUT}, restJson=@RestJson(parameterName="entity", parameterType=Entity.class), restXml=@RestXml(parameterName="entity"), results={"oid", "oids"}, supportBearerToken=true, overwritable=false)
@CommandClass(name="mtp/entity/UpdateEntityCommand", displayName="Entity Update Web API", overwritable=false)
public final class UpdateEntityCommand
extends AbstractEntityCommand {
    public static final String PARAM_ENTITY = "entity";
    public static final String PARAM_PUT_WITH_VALIDATION = "withValidation";
    public static final String PARAM_PUT_NOTIFY_LISTENERS = "notifyListeners";
    public static final String PARAM_PUT_LOCALIZED = "localized";
    public static final String PARAM_PUT_FORCE_UPDATE = "forceUpdate";
    public static final String PARAM_PUT_UPDATE_PROPERTIES = "updateProperties";
    public static final String PARAM_PUT_CHECK_TIMESTAMP = "checkTimestamp";
    public static final String PARAM_PUT_TARGET_VERSION = "targetVersion";
    public static final String PARAM_PUT_PURGE_COMPOSITIONED_ENTITY = "purgeCompositionedEntity";
    public static final String PARAM_PUT_CHECK_LOCKED_BY_USER = "checkLockedByUser";
    public static final String RESULT_OID_LIST = "oids";
    public static final String RESULT_OID = "oid";
    public static final String RESULT_VERSION = "version";
    public static final long VERSION_NEW = -1L;

    private void doUpdate(RequestContext request, String defName, String oid, String ver) {
        Timestamp updateDate;
        Entity e = (Entity)request.getAttribute(PARAM_ENTITY);
        e.setDefinitionName(defName);
        e.setOid(oid);
        UpdateOption option = null;
        if (e instanceof GenericEntity) {
            option = new UpdateOption(false);
            for (String pn : ((GenericEntity)e).getPropertyNames()) {
                if (pn.equals(RESULT_OID) || pn.equals("updateDate")) continue;
                option.add(pn);
            }
        } else {
            option = UpdateOption.allPropertyUpdateOption((String)defName, (boolean)false);
        }
        if ((updateDate = e.getUpdateDate()) != null) {
            option.setCheckTimestamp(true);
        }
        this.setUpdateOptionWithParam(request, option);
        EntityHandler eh = EntityContext.getCurrentContext().getHandlerByName(defName);
        if (ver != null && eh.isVersioned()) {
            long version = Long.parseLong(ver);
            if (version == -1L) {
                option.setTargetVersion(TargetVersion.NEW);
            } else {
                option.setTargetVersion(TargetVersion.SPECIFIC);
                e.setVersion(Long.valueOf(version));
            }
        }
        this.em.update(e, option);
        request.setAttribute(RESULT_OID, (Object)oid);
        if (eh.isVersioned()) {
            request.setAttribute(RESULT_VERSION, (Object)e.getVersion());
        }
    }

    private void setUpdateOptionWithParam(RequestContext request, UpdateOption option) {
        EntityWebApiService service = (EntityWebApiService)ServiceRegistry.getRegistry().getService(EntityWebApiService.class);
        if (service.isPermitRolesToSpecifyOptions()) {
            String checkLockedByUser;
            String purgeCompositionedEntity;
            String targetVersion;
            String checkTimestamp;
            String updateProperties;
            String forceUpdate;
            String localized;
            String notifyListeners;
            String withValidation = request.getParam(PARAM_PUT_WITH_VALIDATION);
            if (StringUtil.isNotBlank((String)withValidation)) {
                option.setWithValidation(Boolean.parseBoolean(withValidation));
            }
            if (StringUtil.isNotBlank((String)(notifyListeners = request.getParam(PARAM_PUT_NOTIFY_LISTENERS)))) {
                option.setNotifyListeners(Boolean.parseBoolean(notifyListeners));
            }
            if (StringUtil.isNotBlank((String)(localized = request.getParam(PARAM_PUT_LOCALIZED)))) {
                option.setLocalized(Boolean.parseBoolean(localized));
            }
            if (StringUtil.isNotBlank((String)(forceUpdate = request.getParam(PARAM_PUT_FORCE_UPDATE)))) {
                option.setForceUpdate(Boolean.parseBoolean(forceUpdate));
            }
            if (StringUtil.isNotBlank((String)(updateProperties = request.getParam(PARAM_PUT_UPDATE_PROPERTIES)))) {
                option.setUpdateProperties(Arrays.asList(updateProperties.split(",")));
            }
            if (StringUtil.isNotBlank((String)(checkTimestamp = request.getParam(PARAM_PUT_CHECK_TIMESTAMP)))) {
                option.setCheckTimestamp(Boolean.parseBoolean(checkTimestamp));
            }
            if (StringUtil.isNotBlank((String)(targetVersion = request.getParam(PARAM_PUT_TARGET_VERSION)))) {
                try {
                    option.setTargetVersion(TargetVersion.valueOf((String)targetVersion));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("targetVersion is invalid.");
                }
            }
            if (StringUtil.isNotBlank((String)(purgeCompositionedEntity = request.getParam(PARAM_PUT_PURGE_COMPOSITIONED_ENTITY)))) {
                option.setPurgeCompositionedEntity(Boolean.parseBoolean(purgeCompositionedEntity));
            }
            if (StringUtil.isNotBlank((String)(checkLockedByUser = request.getParam(PARAM_PUT_CHECK_LOCKED_BY_USER)))) {
                option.setCheckLockedByUser(Boolean.parseBoolean(checkLockedByUser));
            }
        }
    }

    @Override
    public String executeImpl(RequestContext request, String[] subPath) {
        if (subPath == null || subPath.length < 2 || subPath.length > 3) {
            throw new IllegalArgumentException("illegal path parameter:" + subPath);
        }
        this.checkPermission(subPath[0], def -> def.getMetaData().isUpdate());
        switch (subPath.length) {
            case 2: {
                this.doUpdate(request, subPath[0], subPath[1], null);
                break;
            }
            case 3: {
                this.doUpdate(request, subPath[0], subPath[1], subPath[2]);
                break;
            }
        }
        return "SUCCESS";
    }
}

