/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi.command.entity;

import java.sql.Timestamp;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.entity.DeleteOption;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.impl.webapi.command.entity.AbstractEntityCommand;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;

@WebApi(name="mtp/entity/DELETE", accepts={RequestType.REST_FORM}, methods={MethodType.DELETE}, supportBearerToken=true, overwritable=false)
@CommandClass(name="mtp/entity/DeleteEntityCommand", displayName="Entity Delete Web API", overwritable=false)
public final class DeleteEntityCommand
extends AbstractEntityCommand {
    public static final String PARAM_TIMESTAMP = "timestamp";
    public static final String RESULT_OID = "oid";

    @Override
    public String executeImpl(RequestContext request, String[] subPath) {
        if (subPath == null || subPath.length != 2) {
            throw new IllegalArgumentException("illegal path parameter:" + subPath);
        }
        this.checkPermission(subPath[0], def -> def.getMetaData().isDelete());
        GenericEntity e = new GenericEntity(subPath[0]);
        e.setOid(subPath[1]);
        DeleteOption option = new DeleteOption();
        String tsStr = request.getParam(PARAM_TIMESTAMP);
        if (tsStr != null) {
            e.setUpdateDate(new Timestamp(Long.parseLong(tsStr)));
            option.setCheckTimestamp(true);
        }
        this.em.delete((Entity)e, option);
        return "SUCCESS";
    }
}

