/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi.command.entity;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.async.TaskStatus;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.UploadFileHandle;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.RestJson;
import org.iplass.mtp.command.annotation.webapi.RestXml;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.InsertOption;
import org.iplass.mtp.impl.csv.CsvUploadOption;
import org.iplass.mtp.impl.csv.CsvUploadService;
import org.iplass.mtp.impl.csv.CsvUploadStatus;
import org.iplass.mtp.impl.csv.EntityCsvImportOption;
import org.iplass.mtp.impl.csv.EntityCsvImportResult;
import org.iplass.mtp.impl.csv.EntityCsvImportService;
import org.iplass.mtp.impl.entity.csv.EntityCsvException;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.web.WebRequestContext;
import org.iplass.mtp.impl.web.fileupload.MultiPartParameterValueMap;
import org.iplass.mtp.impl.webapi.EntityWebApiService;
import org.iplass.mtp.impl.webapi.command.entity.AbstractEntityCommand;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;

@WebApi(name="mtp/entity/POST", accepts={RequestType.REST_JSON, RequestType.REST_XML, RequestType.REST_FORM}, methods={MethodType.POST}, restJson=@RestJson(parameterName="entity", parameterType=Entity.class), restXml=@RestXml(parameterName="entity"), results={"oid", "insert", "update", "delete", "error"}, supportBearerToken=true, overwritable=false)
@CommandClass(name="mtp/entity/CreateEntityCommand", displayName="Entity Create Web API", overwritable=false)
public final class CreateEntityCommand
extends AbstractEntityCommand {
    public static final String PARAM_ENTITY = "entity";
    public static final String RESULT_OID = "oid";
    public static final String PARAM_POST_WITH_VALIDATION = "withValidation";
    public static final String PARAM_POST_NOTIFY_LISTENERS = "notifyListeners";
    public static final String PARAM_POST_ENABLE_AUDIT_PROPERTY_SPECIFICATION = "enableAuditPropertySpecification";
    public static final String PARAM_POST_REGENERATE_OID = "regenerateOid";
    public static final String PARAM_POST_REGENERATE_AUTO_NUMBER = "regenerateAutoNumber";
    public static final String PARAM_POST_VERSION_SPECIFIED = "versionSpecified";
    public static final String PARAM_POST_LOCALIZED = "localized";
    public static final String PARAM_UPLOAD_FILE = "uploadFile";
    public static final String PARAM_UPLOAD_UNIQUE_KEY = "uniqueKey";
    public static final String PARAM_UPLOAD_ASYNC = "asyncUpload";
    public static final String PARAM_UPLOAD_TRUNCATE = "truncate";
    public static final String PARAM_UPLOAD_BULK_UPDATE = "bulkUpdate";
    public static final String PARAM_UPLOAD_ERROR_SKIP = "errorSkip";
    public static final String PARAM_UPLOAD_IGNORE_NOT_EXIST_PROPERTY = "ignoreNotExistsProperty";
    public static final String PARAM_UPLOAD_NOTIFY_LISTENERT = "notifyListeners";
    public static final String PARAM_UPLOAD_WITH_VALIDATION = "withValidation";
    public static final String PARAM_UPLOAD_UPDATE_DISUPDATABLE_PROPERTY = "updateDisupdatableProperty";
    public static final String PARAM_UPLOAD_INSERT_ENABLE_AUDIT_PROPERTY_SPECIFICATION = "insertEnableAuditPropertySpecification";
    public static final String PARAM_UPLOAD_PREFIX_OID = "prefixOid";
    public static final String PARAM_UPLOAD_COMMIT_LIMIT = "commitLimit";
    public static final String PARAM_UPLOAD_FORCE_UPDATE = "fourceUpdate";
    public static final String PARAM_UPLOAD_LOCALE = "locale";
    public static final String PARAM_UPLOAD_TIMEZONE = "timezone";
    public static final String RESULT_UPLOAD_INSERT = "insert";
    public static final String RESULT_UPLOAD_UPDATE = "update";
    public static final String RESULT_UPLOAD_DELETE = "delete";
    public static final String RESULT_UPLOAD_ERROR = "error";

    @Override
    public String executeImpl(RequestContext request, String[] subPath) {
        if (subPath == null || subPath.length != 1) {
            throw new IllegalArgumentException("illegal path parameter:" + subPath);
        }
        if (this.isMultipart(request)) {
            this.doCsvUpload(request, subPath[0]);
        } else {
            this.doInsert(request, subPath[0]);
        }
        return "SUCCESS";
    }

    private boolean isMultipart(RequestContext request) {
        return request instanceof WebRequestContext && ((WebRequestContext)request).getValueMap() instanceof MultiPartParameterValueMap;
    }

    private void doInsert(RequestContext request, String defName) {
        this.checkPermission(defName, def -> def.getMetaData().isInsert());
        Entity e = (Entity)request.getAttribute(PARAM_ENTITY);
        e.setDefinitionName(defName);
        InsertOption option = new InsertOption();
        this.setInsertOptionWithParam(request, option);
        String oid = this.em.insert(e, option);
        request.setAttribute(RESULT_OID, (Object)oid);
    }

    private void setInsertOptionWithParam(RequestContext request, InsertOption option) {
        EntityWebApiService service = (EntityWebApiService)ServiceRegistry.getRegistry().getService(EntityWebApiService.class);
        if (service.isPermitRolesToSpecifyOptions()) {
            String localized;
            String versionSpecified;
            String regenerateAutoNumber;
            String regenerateOid;
            String enableAuditPropertySpecification;
            String notifyListeners;
            String withValidation = request.getParam("withValidation");
            if (StringUtil.isNotBlank((String)withValidation)) {
                option.setWithValidation(Boolean.parseBoolean(withValidation));
            }
            if (StringUtil.isNotBlank((String)(notifyListeners = request.getParam("notifyListeners")))) {
                option.setNotifyListeners(Boolean.parseBoolean(notifyListeners));
            }
            if (StringUtil.isNotBlank((String)(enableAuditPropertySpecification = request.getParam(PARAM_POST_ENABLE_AUDIT_PROPERTY_SPECIFICATION)))) {
                option.setEnableAuditPropertySpecification(Boolean.parseBoolean(enableAuditPropertySpecification));
            }
            if (StringUtil.isNotBlank((String)(regenerateOid = request.getParam(PARAM_POST_REGENERATE_OID)))) {
                option.setRegenerateOid(Boolean.parseBoolean(regenerateOid));
            }
            if (StringUtil.isNotBlank((String)(regenerateAutoNumber = request.getParam(PARAM_POST_REGENERATE_AUTO_NUMBER)))) {
                option.setRegenerateAutoNumber(Boolean.parseBoolean(regenerateAutoNumber));
            }
            if (StringUtil.isNotBlank((String)(versionSpecified = request.getParam(PARAM_POST_VERSION_SPECIFIED)))) {
                option.setVersionSpecified(Boolean.parseBoolean(versionSpecified));
            }
            if (StringUtil.isNotBlank((String)(localized = request.getParam(PARAM_POST_LOCALIZED)))) {
                option.setLocalized(Boolean.parseBoolean(localized));
            }
        }
    }

    private void doCsvUpload(RequestContext request, String defName) {
        block75: {
            Throwable throwable;
            InputStream is;
            this.checkPermission(defName, def -> def.getMetaData().isUpdate());
            UploadFileHandle file = request.getParamAsFile(PARAM_UPLOAD_FILE);
            String uniqueKey = StringUtil.stripToNull((String)request.getParam(PARAM_UPLOAD_UNIQUE_KEY));
            boolean async = (Boolean)request.getParam(PARAM_UPLOAD_ASYNC, Boolean.class, (Object)false);
            if (file == null) {
                throw new IllegalArgumentException("illegal parameter:uploadFile");
            }
            CsvUploadService service = (CsvUploadService)ServiceRegistry.getRegistry().getService(CsvUploadService.class);
            EntityCsvImportService importService = (EntityCsvImportService)ServiceRegistry.getRegistry().getService(EntityCsvImportService.class);
            EntityCsvImportOption option = new EntityCsvImportOption();
            this.setImportOptionWithParam(request, option);
            if (async) {
                if (option.isWithOption()) {
                    try (InputStream is2 = file.getInputStream();){
                        List<String> excludeEntityNames = Arrays.asList("mtp.maintenance.Package", "mtp.maintenance.MetaDataTag");
                        importService.asyncImportEntityData(defName, is2, defName, option, excludeEntityNames);
                        break block75;
                    }
                    catch (IOException e) {
                        throw new SystemException((Throwable)e);
                    }
                }
                try (InputStream is3 = file.getInputStream();){
                    CsvUploadOption uploadOption = new CsvUploadOption().uniqueKey(uniqueKey);
                    service.asyncUpload(is3, file.getFileName(), defName, null, uploadOption);
                    break block75;
                }
                catch (IOException e) {
                    throw new SystemException((Throwable)e);
                }
            }
            if (option.isWithOption()) {
                String entityPath = "/entity/" + defName.replace(".", "/");
                MetaDataEntry entry = MetaDataContext.getContext().getMetaDataEntry(entityPath);
                List<String> excludeEntityNames = Arrays.asList("mtp.maintenance.Package", "mtp.maintenance.MetaDataTag");
                try (InputStream is4 = file.getInputStream();){
                    EntityCsvImportResult ret = importService.importEntityData(defName, is4, entry, option, null, null, excludeEntityNames);
                    request.setAttribute(RESULT_UPLOAD_INSERT, (Object)ret.getInsertCount());
                    request.setAttribute(RESULT_UPLOAD_UPDATE, (Object)ret.getUpdateCount());
                    request.setAttribute(RESULT_UPLOAD_DELETE, (Object)ret.getDeleteCount());
                    request.setAttribute(RESULT_UPLOAD_ERROR, (Object)ret.getErrorCount());
                    break block75;
                }
                catch (IOException e) {
                    throw new SystemException((Throwable)e);
                }
            }
            try {
                is = file.getInputStream();
                throwable = null;
                try {
                    service.validate(is, defName, true);
                }
                catch (Throwable excludeEntityNames) {
                    throwable = excludeEntityNames;
                    throw excludeEntityNames;
                }
                finally {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable excludeEntityNames) {
                                throwable.addSuppressed(excludeEntityNames);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new SystemException((Throwable)e);
            }
            try {
                is = file.getInputStream();
                throwable = null;
                try {
                    CsvUploadOption uploadOption = new CsvUploadOption().uniqueKey(uniqueKey);
                    CsvUploadStatus result = service.upload(is, defName, uploadOption);
                    if (result.getStatus() != TaskStatus.COMPLETED) {
                        throw new EntityCsvException(result.getCode(), result.getMessage());
                    }
                    request.setAttribute(RESULT_UPLOAD_INSERT, (Object)result.getInsertCount());
                    request.setAttribute(RESULT_UPLOAD_UPDATE, (Object)result.getUpdateCount());
                    request.setAttribute(RESULT_UPLOAD_DELETE, (Object)result.getDeleteCount());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new SystemException((Throwable)e);
            }
        }
    }

    private void setImportOptionWithParam(RequestContext request, EntityCsvImportOption option) {
        EntityWebApiService service = (EntityWebApiService)ServiceRegistry.getRegistry().getService(EntityWebApiService.class);
        if (service.isPermitRolesToSpecifyOptions()) {
            String timezone;
            String locale;
            String uniqueKey;
            String fourceUpdate;
            String commitLimit;
            String prefixOid;
            String insertEnableAuditPropertySpecification;
            String updateDisupdatableProperty;
            String withValidation;
            String notifyListeners;
            String ignoreNotExistsProperty;
            String errorSkip;
            String bulkUpdate;
            String truncate = request.getParam(PARAM_UPLOAD_TRUNCATE);
            if (StringUtil.isNotBlank((String)truncate)) {
                option.setTruncate(Boolean.parseBoolean(truncate));
                option.withOption();
            }
            if (StringUtil.isNotBlank((String)(bulkUpdate = request.getParam(PARAM_UPLOAD_BULK_UPDATE)))) {
                option.setBulkUpdate(Boolean.parseBoolean(bulkUpdate));
                option.withOption();
            }
            if (StringUtil.isNotBlank((String)(errorSkip = request.getParam(PARAM_UPLOAD_ERROR_SKIP)))) {
                option.setErrorSkip(Boolean.parseBoolean(errorSkip));
                option.withOption();
            }
            if (StringUtil.isNotBlank((String)(ignoreNotExistsProperty = request.getParam(PARAM_UPLOAD_IGNORE_NOT_EXIST_PROPERTY)))) {
                option.setIgnoreNotExistsProperty(Boolean.parseBoolean(ignoreNotExistsProperty));
                option.withOption();
            }
            if (StringUtil.isNotBlank((String)(notifyListeners = request.getParam("notifyListeners")))) {
                option.setNotifyListeners(Boolean.parseBoolean(notifyListeners));
                option.withOption();
            }
            if (StringUtil.isNotBlank((String)(withValidation = request.getParam("withValidation")))) {
                option.setWithValidation(Boolean.parseBoolean(withValidation));
                option.withOption();
            }
            if (StringUtil.isNotBlank((String)(updateDisupdatableProperty = request.getParam(PARAM_UPLOAD_UPDATE_DISUPDATABLE_PROPERTY)))) {
                option.setUpdateDisupdatableProperty(Boolean.parseBoolean(updateDisupdatableProperty));
                option.withOption();
            }
            if (StringUtil.isNotBlank((String)(insertEnableAuditPropertySpecification = request.getParam(PARAM_UPLOAD_INSERT_ENABLE_AUDIT_PROPERTY_SPECIFICATION)))) {
                option.setInsertEnableAuditPropertySpecification(Boolean.parseBoolean(insertEnableAuditPropertySpecification));
                option.withOption();
            }
            if (StringUtil.isNotBlank((String)(prefixOid = request.getParam(PARAM_UPLOAD_PREFIX_OID)))) {
                option.setPrefixOid(prefixOid);
                option.withOption();
            }
            if (StringUtil.isNotBlank((String)(commitLimit = request.getParam(PARAM_UPLOAD_COMMIT_LIMIT)))) {
                try {
                    option.setCommitLimit(Integer.parseInt(commitLimit));
                    option.withOption();
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("illegal parameter:commitLimit");
                }
            }
            if (StringUtil.isNotBlank((String)(fourceUpdate = request.getParam(PARAM_UPLOAD_FORCE_UPDATE)))) {
                option.setFourceUpdate(Boolean.parseBoolean(fourceUpdate));
                option.withOption();
            }
            if (StringUtil.isNotBlank((String)(uniqueKey = request.getParam(PARAM_UPLOAD_UNIQUE_KEY)))) {
                option.setUniqueKey(uniqueKey);
            }
            if (StringUtil.isNotBlank((String)(locale = request.getParam(PARAM_UPLOAD_LOCALE)))) {
                option.setLocale(locale);
                option.withOption();
            }
            if (StringUtil.isNotBlank((String)(timezone = request.getParam(PARAM_UPLOAD_TIMEZONE)))) {
                option.setTimezone(timezone);
                option.withOption();
            }
        }
    }
}

