/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi.command.definition;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.NoPermissionException;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.RestJson;
import org.iplass.mtp.command.annotation.webapi.RestXml;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.command.annotation.webapi.WebApis;
import org.iplass.mtp.definition.Definition;
import org.iplass.mtp.definition.DefinitionModifyResult;
import org.iplass.mtp.definition.TypedDefinitionManager;
import org.iplass.mtp.impl.definition.DefinitionPath;
import org.iplass.mtp.impl.definition.DefinitionService;
import org.iplass.mtp.impl.webapi.WebApiService;
import org.iplass.mtp.impl.webapi.command.Constants;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebApis(value={@WebApi(name="mtp/definition/GET", accepts={RequestType.REST_FORM}, methods={MethodType.GET}, results={"definition", "list"}, supportBearerToken=true, overwritable=false), @WebApi(name="mtp/definition/POST", accepts={RequestType.REST_JSON, RequestType.REST_XML}, methods={MethodType.POST}, restJson=@RestJson(parameterName="definition", parameterType=Definition.class), restXml=@RestXml(parameterName="definition"), supportBearerToken=true, overwritable=false), @WebApi(name="mtp/definition/PUT", accepts={RequestType.REST_JSON, RequestType.REST_XML}, methods={MethodType.PUT}, restJson=@RestJson(parameterName="definition", parameterType=Definition.class), restXml=@RestXml(parameterName="definition"), supportBearerToken=true, overwritable=false), @WebApi(name="mtp/definition/DELETE", accepts={RequestType.REST_FORM}, methods={MethodType.DELETE}, supportBearerToken=true, overwritable=false)})
@CommandClass(name="mtp/definition/DefinitionCommand", displayName="Definition Web API", overwritable=false)
public final class DefinitionCommand
implements Command,
Constants {
    private static final Logger logger = LoggerFactory.getLogger(DefinitionCommand.class);
    public static final String PARAM_DEFINITION = "definition";
    public static final String PARAM_RECURSIVE = "recursive";
    public static final String RESULT_DEFINITION_LIST = "list";
    public static final String RESULT_DEFINITION = "definition";
    DefinitionService service = DefinitionService.getInstance();
    WebApiService webApiService = (WebApiService)ServiceRegistry.getRegistry().getService(WebApiService.class);

    public String execute(RequestContext request) {
        if (!this.webApiService.isEnableDefinitionApi()) {
            logger.warn("definition web api is disabled on WebApiService configration.");
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (!AuthContext.getCurrentContext().getUser().isAdmin()) {
            throw new NoPermissionException("this user have no admin permission");
        }
        MethodType method = (MethodType)((Object)request.getAttribute("httpMethod"));
        switch (method) {
            case GET: {
                return this.doGet(request);
            }
            case POST: {
                return this.doPost(request);
            }
            case PUT: {
                return this.doPut(request);
            }
            case DELETE: {
                return this.doDelete(request);
            }
        }
        throw new WebApplicationException(Response.Status.METHOD_NOT_ALLOWED);
    }

    private String doDelete(RequestContext request) {
        DefinitionPath typeAndPath = this.typeAndPath(request);
        TypedDefinitionManager tdm = this.service.getTypedDefinitionManager(typeAndPath.getType());
        DefinitionModifyResult res = tdm.remove(typeAndPath.getPath());
        if (res.isSuccess()) {
            return "SUCCESS";
        }
        throw new SystemException(res.getMessage());
    }

    private String doPut(RequestContext request) {
        DefinitionPath typeAndPath = this.typeAndPath(request);
        TypedDefinitionManager tdm = this.service.getTypedDefinitionManager(typeAndPath.getType());
        Definition def = (Definition)request.getAttribute("definition");
        if (def == null) {
            throw new IllegalArgumentException("definition must specify by put body content.");
        }
        if (typeAndPath.getClass().isAssignableFrom(def.getClass())) {
            throw new IllegalArgumentException("definition type unmatch. expect:" + typeAndPath.getClass().getName() + " actual:" + def.getClass().getName());
        }
        DefinitionModifyResult res = tdm.update(def);
        if (res.isSuccess()) {
            return "SUCCESS";
        }
        throw new SystemException(res.getMessage());
    }

    private String doPost(RequestContext request) {
        DefinitionPath typeAndPath = this.typeAndPath(request);
        TypedDefinitionManager tdm = this.service.getTypedDefinitionManager(typeAndPath.getType());
        Definition def = (Definition)request.getAttribute("definition");
        if (def == null) {
            throw new IllegalArgumentException("definition must specify by post body content.");
        }
        if (typeAndPath.getClass().isAssignableFrom(def.getClass())) {
            throw new IllegalArgumentException("definition type unmatch. expect:" + typeAndPath.getClass().getName() + " actual:" + def.getClass().getName());
        }
        DefinitionModifyResult res = tdm.create(def);
        if (res.isSuccess()) {
            return "SUCCESS";
        }
        throw new SystemException(res.getMessage());
    }

    private DefinitionPath typeAndPath(RequestContext request) {
        String subPath = (String)request.getAttribute("subPath");
        if (subPath == null || subPath.length() == 0) {
            throw new NullPointerException("definition path must specify.");
        }
        DefinitionPath path = this.service.resolvePath(subPath);
        if (path == null) {
            throw new IllegalArgumentException("illegal definition path:" + subPath);
        }
        return path;
    }

    private String doGet(RequestContext request) {
        DefinitionPath typeAndPath = this.typeAndPath(request);
        TypedDefinitionManager tdm = this.service.getTypedDefinitionManager(typeAndPath.getType());
        String defPath = typeAndPath.getPath();
        if (defPath.length() == 0 || defPath.endsWith("/")) {
            Boolean recursive = (Boolean)request.getParam(PARAM_RECURSIVE, Boolean.class, (Object)false);
            request.setAttribute(RESULT_DEFINITION_LIST, (Object)tdm.definitionSummaryList(defPath, recursive.booleanValue()));
        } else {
            request.setAttribute("definition", (Object)tdm.get(defPath));
        }
        return "SUCCESS";
    }
}

