/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi.command.binary;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.UploadFileHandle;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.command.annotation.webapi.WebApis;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.impl.definition.DefinitionService;
import org.iplass.mtp.impl.webapi.WebApiService;
import org.iplass.mtp.impl.webapi.command.Constants;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebApis(value={@WebApi(name="mtp/bin/GET", accepts={RequestType.REST_FORM}, methods={MethodType.GET}, supportBearerToken=true, overwritable=false), @WebApi(name="mtp/bin/POST", accepts={RequestType.REST_FORM}, methods={MethodType.POST}, results={"lobId"}, supportBearerToken=true, overwritable=false)})
@CommandClass(name="mtp/binary/BinaryCommand", displayName="Binary Web API", overwritable=false)
public final class BinaryCommand
implements Command,
Constants {
    private static Logger logger = LoggerFactory.getLogger(BinaryCommand.class);
    public static final String PARAM_UPLOAD_FILE = "uploadFile";
    public static final String RESULT_LOB_ID = "lobId";
    DefinitionService service = DefinitionService.getInstance();
    WebApiService webApiService = (WebApiService)ServiceRegistry.getRegistry().getService(WebApiService.class);

    public String execute(RequestContext request) {
        if (!this.webApiService.isEnableBinaryApi()) {
            logger.warn("bin web api is disabled on WebApiService configration.");
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        MethodType method = (MethodType)((Object)request.getAttribute("httpMethod"));
        switch (method) {
            case GET: {
                return this.doGet(request);
            }
            case POST: {
                return this.doPost(request);
            }
        }
        throw new WebApplicationException(Response.Status.METHOD_NOT_ALLOWED);
    }

    private String doPost(RequestContext request) {
        UploadFileHandle file = request.getParamAsFile(PARAM_UPLOAD_FILE);
        if (null != file && this.isRejectMimeTypes(file.getType())) {
            logger.error("File upload rejected. fileName = {}, fileType = {}, fileSize = {}.", new Object[]{file.getFileName(), file.getType(), file.getSize()});
            throw new WebApplicationException(Response.Status.UNSUPPORTED_MEDIA_TYPE);
        }
        BinaryReference br = file.toBinaryReference();
        request.setAttribute(RESULT_LOB_ID, (Object)br.getLobId());
        return "SUCCESS";
    }

    private String doGet(RequestContext request) {
        String subPath = (String)request.getAttribute("subPath");
        if (subPath != null && subPath.startsWith("/")) {
            subPath = subPath.substring(1);
        }
        long lobId = Long.parseLong(subPath);
        EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
        BinaryReference br = em.loadBinaryReference(lobId);
        if (br == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        InputStream stream = em.getInputStream(br);
        if (stream == null) {
            logger.error("no content");
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        Response.ResponseBuilder rb = Response.ok((Object)stream, (String)br.getType());
        if (br.getType() != null && br.getType().length() != 0) {
            rb.type(br.getType());
        }
        if (br.getSize() != 0L) {
            rb.header("Content-Length", (Object)br.getSize());
        }
        if (br.getName() != null && br.getName().length() != 0) {
            if (this.webApiService.isWriteEncodedFilenameInBinaryApi()) {
                String encodedFileName;
                try {
                    encodedFileName = this.getEncodedFileName(br.getName());
                }
                catch (IOException e) {
                    throw new SystemException((Throwable)e);
                }
                rb.header("Content-Disposition", (Object)String.format("attachment;filename*=%s''%s", StandardCharsets.UTF_8.name(), encodedFileName));
            } else {
                rb.header("Content-Disposition", (Object)("attachment;filename=" + br.getName()));
            }
        }
        request.setAttribute("result", (Object)rb);
        return "SUCCESS";
    }

    private String getEncodedFileName(String fileName) throws IOException {
        byte[] source = fileName.getBytes(StandardCharsets.UTF_8.name());
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(source.length);){
            for (byte b : source) {
                if (b < 0) {
                    b = (byte)(b + 256);
                }
                if (this.isUnescape(b)) {
                    bos.write(b);
                    continue;
                }
                bos.write(37);
                char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
                char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
                bos.write(hex1);
                bos.write(hex2);
            }
            String string = new String(bos.toByteArray(), "US-ASCII");
            return string;
        }
    }

    private boolean isUnescape(int ch) {
        if (ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90) {
            return true;
        }
        if (ch >= 48 && ch <= 57) {
            return true;
        }
        if (this.webApiService.getUnescapeFilenameCharacterInBinaryApi() != null) {
            return this.webApiService.getUnescapeFilenameCharacterInBinaryApi().indexOf(ch) >= 0;
        }
        return false;
    }

    private boolean isRejectMimeTypes(String type) {
        boolean isAccept = true;
        WebApiService service = (WebApiService)ServiceRegistry.getRegistry().getService(WebApiService.class);
        if (null != service.getAcceptMimeTypesPatternInBinaryApi()) {
            isAccept = service.getAcceptMimeTypesPatternInBinaryApi().matcher(type).matches();
        }
        return !isAccept;
    }
}

