/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi;

import java.util.List;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.definition.TypedDefinitionManager;
import org.iplass.mtp.impl.definition.AbstractTypedMetaDataService;
import org.iplass.mtp.impl.definition.DefinitionMetaDataTypeMap;
import org.iplass.mtp.impl.webapi.MetaEntityWebApi;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.webapi.definition.EntityWebApiDefinition;
import org.iplass.mtp.webapi.definition.EntityWebApiDefinitionManager;

public class EntityWebApiService
extends AbstractTypedMetaDataService<MetaEntityWebApi, MetaEntityWebApi.EntityWebApiHandler>
implements Service {
    public static final String META_PATH = "/entityWebapi/";
    private int maxLimit;
    private String csvDateTimeFormat;
    private String csvDateFormat;
    private String csvTimeFormat;
    private boolean enableNativeHint;
    private boolean csvListWithMappedByReference;
    private boolean listWithMappedByReference;
    private boolean loadWithMappedByReference;
    private boolean throwSearchResultLimitExceededException;
    private List<String> permitRolesToSpecifyOptions;

    public boolean isEnableNativeHint() {
        return this.enableNativeHint;
    }

    public boolean isThrowSearchResultLimitExceededException() {
        return this.throwSearchResultLimitExceededException;
    }

    public boolean isLoadWithMappedByReference() {
        return this.loadWithMappedByReference;
    }

    public boolean isCsvListWithMappedByReference() {
        return this.csvListWithMappedByReference;
    }

    public boolean isListWithMappedByReference() {
        return this.listWithMappedByReference;
    }

    public int getMaxLimit() {
        return this.maxLimit;
    }

    public String getCsvDateTimeFormat() {
        return this.csvDateTimeFormat;
    }

    public String getCsvDateFormat() {
        return this.csvDateFormat;
    }

    public String getCsvTimeFormat() {
        return this.csvTimeFormat;
    }

    public boolean isPermitRolesToSpecifyOptions() {
        AuthContext auth = AuthContext.getCurrentContext();
        if (auth.getUser().isAdmin()) {
            return true;
        }
        if (this.permitRolesToSpecifyOptions != null && !this.permitRolesToSpecifyOptions.isEmpty()) {
            for (String role : this.permitRolesToSpecifyOptions) {
                if (!auth.userInRole(role)) continue;
                return true;
            }
        }
        return false;
    }

    public void destroy() {
    }

    public void init(Config config) {
        this.enableNativeHint = (Boolean)config.getValue("enableNativeHint", Boolean.TYPE, (Object)Boolean.FALSE);
        this.maxLimit = (Integer)config.getValue("maxLimit", Integer.class, (Object)1000);
        this.csvDateTimeFormat = (String)config.getValue("csvDateTimeFormat", String.class, null);
        this.csvDateFormat = (String)config.getValue("csvDateFormat", String.class, null);
        this.csvTimeFormat = (String)config.getValue("csvTimeFormat", String.class, null);
        this.listWithMappedByReference = (Boolean)config.getValue("listWithMappedByReference", Boolean.TYPE, (Object)Boolean.FALSE);
        Boolean valOfCsvList = (Boolean)config.getValue("csvListWithMappedByReference", Boolean.TYPE);
        this.csvListWithMappedByReference = valOfCsvList != null ? valOfCsvList : this.listWithMappedByReference;
        this.loadWithMappedByReference = (Boolean)config.getValue("loadWithMappedByReference", Boolean.TYPE, (Object)Boolean.FALSE);
        this.throwSearchResultLimitExceededException = (Boolean)config.getValue("throwSearchResultLimitExceededException", Boolean.TYPE, (Object)Boolean.FALSE);
        this.permitRolesToSpecifyOptions = config.getValues("permitRolesToSpecifyOptions");
    }

    public static String getFixedPath() {
        return META_PATH;
    }

    public Class<MetaEntityWebApi> getMetaDataType() {
        return MetaEntityWebApi.class;
    }

    public Class<MetaEntityWebApi.EntityWebApiHandler> getRuntimeType() {
        return MetaEntityWebApi.EntityWebApiHandler.class;
    }

    public static class TypeMap
    extends DefinitionMetaDataTypeMap<EntityWebApiDefinition, MetaEntityWebApi> {
        public TypeMap() {
            super(EntityWebApiService.getFixedPath(), MetaEntityWebApi.class, EntityWebApiDefinition.class);
        }

        public TypedDefinitionManager<EntityWebApiDefinition> typedDefinitionManager() {
            return (TypedDefinitionManager)ManagerLocator.getInstance().getManager(EntityWebApiDefinitionManager.class);
        }

        public String toPath(String defName) {
            return this.pathPrefix + defName.replace('.', '/');
        }

        public String toDefName(String path) {
            return path.substring(this.pathPrefix.length()).replace("/", ".");
        }
    }
}

