/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.template;

import groovy.lang.MissingPropertyException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.codehaus.groovy.runtime.MethodClosure;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.RequestContextWrapper;
import org.iplass.mtp.command.SessionContext;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.script.template.GroovyTemplateBinding;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.WebUtil;
import org.iplass.mtp.impl.web.template.MetaTemplate;
import org.iplass.mtp.impl.web.template.groovy.WebGTmplBase;
import org.iplass.mtp.web.template.definition.GroovyTemplateDefinition;
import org.iplass.mtp.web.template.definition.TemplateDefinition;

public class MetaGroovyTemplate
extends MetaTemplate {
    private static final long serialVersionUID = -8575704321521962011L;
    private String source;
    private List<MetaLocalizedString> localizedSourceList = new ArrayList<MetaLocalizedString>();

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public List<MetaLocalizedString> getLocalizedSourceList() {
        return this.localizedSourceList;
    }

    public void setLocalizedSourceList(List<MetaLocalizedString> localizedSourceList) {
        this.localizedSourceList = localizedSourceList;
    }

    @Override
    public GroovyTemplateRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new GroovyTemplateRuntime();
    }

    @Override
    public void applyConfig(TemplateDefinition definition) {
        this.fillFrom(definition);
        GroovyTemplateDefinition def = (GroovyTemplateDefinition)definition;
        this.source = def.getSource();
        this.localizedSourceList = I18nUtil.toMeta(def.getLocalizedSourceList());
    }

    @Override
    public GroovyTemplateDefinition currentConfig() {
        GroovyTemplateDefinition definition = new GroovyTemplateDefinition();
        this.fillTo(definition);
        definition.setSource(this.source);
        definition.setLocalizedSourceList(I18nUtil.toDef(this.localizedSourceList));
        return definition;
    }

    private GroovyTemplate compileScript(String source) {
        if (source != null) {
            String templateName = "_" + this.getId().replace("-", "_").replace("/", "_").replace(".", "_");
            TenantContext tenantContext = ExecuteContext.getCurrentContext().getTenantContext();
            return GroovyTemplateCompiler.compile((String)source, (String)templateName, (String)WebGTmplBase.class.getName(), (GroovyScriptEngine)((GroovyScriptEngine)tenantContext.getScriptEngine()));
        }
        return null;
    }

    public static class WebGroovyTemplateBinding
    extends GroovyTemplateBinding {
        private RequestContext reqCon;
        private HttpServletRequest req;
        private HttpServletResponse res;
        private ServletContext application;
        private PageContext page;

        public WebGroovyTemplateBinding(RequestContext reqCon, HttpServletRequest req, HttpServletResponse res, ServletContext application, PageContext page) throws IOException {
            super((Writer)(page != null ? page.getOut() : res.getWriter()));
            this.reqCon = reqCon;
            this.req = req;
            this.res = res;
            this.application = application;
            this.page = page;
            this.setVariable("request", reqCon);
            this.setVariable("session", new LazySessionContext(reqCon));
            this.setVariable("include", new MethodClosure((Object)this, "include"));
            this.setVariable("includeTemplate", new MethodClosure((Object)this, "includeTemplate"));
            this.setVariable("renderContent", new MethodClosure((Object)this, "renderContent"));
        }

        public WebGroovyTemplateBinding(WebRequestStack requestStack) throws IOException {
            this(requestStack.getRequestContext(), requestStack.getRequest(), requestStack.getResponse(), requestStack.getServletContext(), requestStack.getPageContext());
        }

        public Object getVariable(String name) {
            try {
                return super.getVariable(name);
            }
            catch (MissingPropertyException e) {
                Object val = this.reqCon.getAttribute(name);
                if (val == null && this.reqCon.getSession(false) != null) {
                    val = this.reqCon.getSession(false).getAttribute(name);
                }
                if (val == null) {
                    throw e;
                }
                return val;
            }
        }

        public boolean hasVariable(String name) {
            boolean ret = super.hasVariable(name);
            if (!ret) {
                boolean bl = ret = this.reqCon.getAttribute(name) != null;
            }
            if (!ret && this.reqCon.getSession(false) != null) {
                ret = this.reqCon.getSession(false).getAttribute(name) != null;
            }
            return ret;
        }

        public Map getVariables() {
            return super.getVariables();
        }

        public void include(String path) throws ServletException, IOException {
            WebUtil.include(path, this.req, this.res, this.application, this.page);
        }

        public void include(String path, RequestContextWrapper request) throws ServletException, IOException {
            WebUtil.include(path, this.req, this.res, this.application, this.page, request);
        }

        public void includeTemplate(String templateName) throws ServletException, IOException {
            WebUtil.includeTemplate(templateName, this.req, this.res, this.application, this.page);
        }

        public void includeTemplate(String templateName, RequestContextWrapper request) throws ServletException, IOException {
            WebUtil.includeTemplate(templateName, this.req, this.res, this.application, this.page, request);
        }

        public void renderContent() throws IOException, ServletException {
            WebUtil.renderContent(this.req, this.res, this.application, this.page);
        }
    }

    private static class LazySessionContext
    implements SessionContext {
        private final RequestContext req;
        private SessionContext sess;

        private LazySessionContext(RequestContext req) {
            this.req = req;
        }

        private void initSess() {
            if (this.sess == null) {
                this.sess = this.req.getSession();
            }
        }

        public Object getAttribute(String name) {
            this.initSess();
            return this.sess.getAttribute(name);
        }

        public void setAttribute(String name, Object value) {
            this.initSess();
            this.sess.setAttribute(name, value);
        }

        public Iterator<String> getAttributeNames() {
            this.initSess();
            return this.sess.getAttributeNames();
        }

        public void removeAttribute(String name) {
            this.initSess();
            this.sess.removeAttribute(name);
        }

        public BinaryReference loadFromTemporary(long lobId) {
            this.initSess();
            return this.sess.loadFromTemporary(lobId);
        }
    }

    public class GroovyTemplateRuntime
    extends MetaTemplate.TemplateRuntime {
        private GroovyTemplate template;
        private Map<String, GroovyTemplate> templateMap;

        public GroovyTemplateRuntime() {
            super(MetaGroovyTemplate.this);
            this.templateMap = new HashMap<String, GroovyTemplate>();
            try {
                this.template = MetaGroovyTemplate.this.compileScript(MetaGroovyTemplate.this.source);
                if (MetaGroovyTemplate.this.localizedSourceList != null) {
                    for (MetaLocalizedString mls : MetaGroovyTemplate.this.localizedSourceList) {
                        this.templateMap.put(mls.getLocaleName(), MetaGroovyTemplate.this.compileScript(mls.getStringValue()));
                    }
                }
            }
            catch (RuntimeException e) {
                this.setIllegalStateException(e);
            }
        }

        @Override
        public MetaGroovyTemplate getMetaData() {
            return MetaGroovyTemplate.this;
        }

        @Override
        public void handleContent(WebRequestStack requestContext) throws IOException, ServletException {
            this.checkState();
            GroovyTemplate _template = this.template;
            String lang = ExecuteContext.getCurrentContext().getLanguage();
            if (this.templateMap.get(lang) != null) {
                _template = this.templateMap.get(lang);
            }
            if (_template != null) {
                WebGroovyTemplateBinding bind = new WebGroovyTemplateBinding(requestContext);
                _template.doTemplate((GroovyTemplateBinding)bind);
            }
        }
    }
}

