/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.fileupload;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.iplass.mtp.impl.util.CoreResourceBundleUtil;
import org.iplass.mtp.impl.web.fileupload.FileUploadTikaAdapter;
import org.iplass.mtp.impl.web.fileupload.MagicByteCheckApplicationException;
import org.iplass.mtp.impl.web.fileupload.MagicByteChecker;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TikaMagicByteChecker
implements MagicByteChecker {
    private static final String APPLICATION_OCTET_STERAM = "application/octet-stream";
    private static Logger LOG = LoggerFactory.getLogger(TikaMagicByteChecker.class);
    private FileUploadTikaAdapter tikaAdapter;
    private boolean isCheckExtension = true;
    private int readMagicLength = 65536;
    private boolean isThrowExceptionIfMimeTypeIsNull = false;
    private boolean isThrowExceptionIfFileCannotRead = false;
    private Map<String, String> substitutionMediaType = Collections.emptyMap();

    public void setFileUploadTikaAdapter(FileUploadTikaAdapter tikaAdapter) {
        this.tikaAdapter = tikaAdapter;
    }

    public void setCheckExtension(boolean isCheckExtension) {
        this.isCheckExtension = isCheckExtension;
    }

    public void setReadMagicLength(int readMagicLength) {
        this.readMagicLength = readMagicLength;
    }

    public void setThrowExceptionIfMimeTypeIsNull(boolean isThrowExceptionIfMimeTypeIsNull) {
        this.isThrowExceptionIfMimeTypeIsNull = isThrowExceptionIfMimeTypeIsNull;
    }

    public void setThrowExceptionIfFileCannotRead(boolean isThrowExceptionIfFileCannotRead) {
        this.isThrowExceptionIfFileCannotRead = isThrowExceptionIfFileCannotRead;
    }

    public void setSubstitutionMediaType(Map<String, String> substitutionMediaType) {
        this.substitutionMediaType = substitutionMediaType;
    }

    @Override
    public void checkMagicByte(File tempFile, String contentType, String fileName) {
        FileUploadTikaAdapter.TikaMimeType mimeType;
        LOG.info("Check magic bytes. Args is tempFile = {}, contentType = {}, fileName = {}.", new Object[]{tempFile.getAbsolutePath(), contentType, fileName});
        String targetContentType = contentType;
        if (this.substitutionMediaType.containsKey(contentType)) {
            targetContentType = this.substitutionMediaType.get(contentType);
            LOG.info("\"{}\" content type is checked by substituting \"{}\".", (Object)contentType, (Object)targetContentType);
        }
        if ((mimeType = this.tikaAdapter.getMimeType(targetContentType)) == null) {
            LOG.warn("Undefined MimeType. targetContentType = {}, filename = {}.", (Object)targetContentType, (Object)fileName);
            if (this.isThrowExceptionIfMimeTypeIsNull) {
                throw new MagicByteCheckApplicationException(this.getCheckExceptionMessage());
            }
            return;
        }
        if (this.isCheckExtension) {
            this.checkExtension(mimeType, fileName);
        }
        this.checkMagic(mimeType, fileName, tempFile);
    }

    private void checkExtension(FileUploadTikaAdapter.TikaMimeType mimeType, String fileName) {
        String extension = this.getExtension(fileName);
        ExtensionCheckStrategy strategy = ExtensionCheckStrategy.getStrategy(mimeType, extension);
        LOG.debug("ExtensionCheckStrategy = {}.", (Object)strategy);
        strategy.performCheck(mimeType, extension, fileName, this);
    }

    private void checkMagic(FileUploadTikaAdapter.TikaMimeType mimeType, String filename, File file) {
        block3: {
            try {
                byte[] magic = this.readMagic(file);
                boolean isSuccess = this.doCheckMagic(mimeType, magic, true);
                if (!isSuccess) {
                    LOG.error("Magic bytes did not match. ( filename = {}, MimeType = {} )", (Object)filename, (Object)mimeType.getName());
                    throw new MagicByteCheckApplicationException(this.getCheckExceptionMessage());
                }
            }
            catch (IOException e) {
                LOG.warn("Cannot read file. ( error message = {}, filename = {}, File = {} )", new Object[]{e.getMessage(), filename, file.getAbsolutePath()});
                if (!this.isThrowExceptionIfFileCannotRead) break block3;
                throw new MagicByteCheckApplicationException(this.getCheckExceptionMessage(), e);
            }
        }
    }

    private boolean doCheckMagic(FileUploadTikaAdapter.TikaMimeType mimeType, byte[] magic, boolean isNeverTested) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Check status of magic bytes. MimeType = {}, MimeType.hasMagic() = {}, isNeverTested = {}.", new Object[]{mimeType.getName(), mimeType.hasMagic(), isNeverTested});
        }
        if (mimeType.hasMagic() && mimeType.matchesMagic(magic)) {
            return true;
        }
        boolean thisMimeTypeIsNotTested = !mimeType.hasMagic();
        boolean isNeverTestedCurrent = isNeverTested && thisMimeTypeIsNotTested;
        FileUploadTikaAdapter.TikaMimeType parentMimeType = this.tikaAdapter.getParentMimeType(mimeType);
        if (null != parentMimeType) {
            if (parentMimeType.getName().equals(APPLICATION_OCTET_STERAM) && !this.tikaAdapter.hasChild(parentMimeType, mimeType)) {
                LOG.debug("Complete the check. MimeType \"{}\" is not defined as a child of \"{}\".", (Object)mimeType.getName(), (Object)parentMimeType.getName());
                return isNeverTestedCurrent;
            }
            LOG.debug("Check with the parent MimeType. current = {}, parent = {}.", (Object)mimeType.getName(), (Object)parentMimeType.getName());
            return this.doCheckMagic(parentMimeType, magic, isNeverTestedCurrent);
        }
        return isNeverTestedCurrent;
    }

    private byte[] readMagic(File file) throws FileNotFoundException, IOException {
        try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));){
            byte[] magic = new byte[this.readMagicLength];
            int read = ((InputStream)input).read(magic);
            if (-1 == read) {
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (read != magic.length) {
                byte[] readMagic = new byte[read];
                System.arraycopy(magic, 0, readMagic, 0, read);
                magic = readMagic;
            }
            byte[] byArray = magic;
            return byArray;
        }
    }

    private String getExtension(String filename) {
        int extPos = filename.lastIndexOf(46);
        if (0 > extPos) {
            return null;
        }
        return filename.substring(extPos);
    }

    private String getCheckExceptionMessage() {
        return CoreResourceBundleUtil.resourceString((String)"impl.web.fileupload.UploadFileHandleImpl.invalidFileMsg", (Object[])new Object[0]);
    }

    private static enum ExtensionCheckStrategy {
        EMPTY_MIMETYPE_EXTENSION_AND_NO_FILE_EXTENSION{

            @Override
            public void performCheck(FileUploadTikaAdapter.TikaMimeType mimeType, String extension, String fileName, TikaMagicByteChecker checker) {
            }
        }
        ,
        EMPTY_MIMETYPE_EXTENSION_AND_FILE_EXTENSION_EXIST{

            @Override
            public void performCheck(FileUploadTikaAdapter.TikaMimeType mimeType, String extension, String fileName, TikaMagicByteChecker checker) {
                LOG.info("The check was skipped because the extension to be checked does not exist in the MimeType. filename = {}, MimeType = {}.", (Object)fileName, (Object)mimeType.getName());
            }
        }
        ,
        MIMETYPE_EXTENSION_EXIST_AND_NO_FILE_EXTENSION{

            @Override
            public void performCheck(FileUploadTikaAdapter.TikaMimeType mimeType, String extension, String fileName, TikaMagicByteChecker checker) {
                LOG.warn("File inspection cannot be performed because the file name does not have an extension. filename = {}, MimeType = {}.", (Object)fileName, (Object)mimeType.getName());
            }
        }
        ,
        MIMETYPE_EXTENSION_EXIST_AND_FILE_EXTENSION_EXIST{

            @Override
            public void performCheck(FileUploadTikaAdapter.TikaMimeType mimeType, String extension, String fileName, TikaMagicByteChecker checker) {
                if (!mimeType.getExtensions().contains(extension)) {
                    LOG.error("Does not match the extension defined for the MimeType. filename = {}, extension = {}, MimeType = {}, defined extension settings = {}", new Object[]{fileName, extension, mimeType.getName(), mimeType.getExtensions()});
                    throw new MagicByteCheckApplicationException(checker.getCheckExceptionMessage());
                }
            }
        };


        abstract void performCheck(FileUploadTikaAdapter.TikaMimeType var1, String var2, String var3, TikaMagicByteChecker var4);

        public static ExtensionCheckStrategy getStrategy(FileUploadTikaAdapter.TikaMimeType mimeType, String extension) {
            return mimeType.getExtensions().isEmpty() ? (StringUtil.isEmpty((String)extension) ? EMPTY_MIMETYPE_EXTENSION_AND_NO_FILE_EXTENSION : EMPTY_MIMETYPE_EXTENSION_AND_FILE_EXTENSION_EXIST) : (StringUtil.isEmpty((String)extension) ? MIMETYPE_EXTENSION_EXIST_AND_NO_FILE_EXTENSION : MIMETYPE_EXTENSION_EXIST_AND_FILE_EXTENSION_EXIST);
        }
    }
}

