/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.fileupload;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.iplass.mtp.impl.web.fileupload.FileTypeDetector;
import org.iplass.mtp.impl.web.fileupload.FileUploadTikaAdapter;
import org.iplass.mtp.impl.web.fileupload.FileUploadTikaAdapterImpl;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceInitListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TikaFileTypeDetector
implements FileTypeDetector,
ServiceInitListener<Service> {
    private Logger logger = LoggerFactory.getLogger(TikaFileTypeDetector.class);
    private FileUploadTikaAdapter tikaAdapter;
    private boolean isCreateTikaAadpter = false;

    public void inited(Service service, Config config) {
        if (null == this.tikaAdapter) {
            FileUploadTikaAdapterImpl adapter = new FileUploadTikaAdapterImpl();
            adapter.inited(service, config);
            this.tikaAdapter = adapter;
            this.isCreateTikaAadpter = true;
        }
    }

    public void destroyed() {
        if (this.isCreateTikaAadpter) {
            ((FileUploadTikaAdapterImpl)this.tikaAdapter).destroyed();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String detect(File file, String fileName, String type) {
        try (FileInputStream in = new FileInputStream(file);){
            String string = this.detect(in, fileName, type);
            return string;
        }
        catch (IOException e) {
            this.logger.warn("Unable to retrieve media type.", (Throwable)e);
            return type;
        }
    }

    @Override
    public String detect(InputStream input, String fileName, String type) {
        try {
            return this.tikaAdapter.detect(input, fileName);
        }
        catch (IOException e) {
            this.logger.warn("Unable to retrieve media type.", (Throwable)e);
            return type;
        }
    }

    public void setFileUploadTikaAdapter(FileUploadTikaAdapter tikaAdapter) {
        this.tikaAdapter = tikaAdapter;
    }
}

