/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.csv;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.async.AsyncTaskManager;
import org.iplass.mtp.async.AsyncTaskOption;
import org.iplass.mtp.async.ExceptionHandlingMode;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.DeleteCondition;
import org.iplass.mtp.entity.DeleteOption;
import org.iplass.mtp.entity.DeleteTargetVersion;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityApplicationException;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.InsertOption;
import org.iplass.mtp.entity.TargetVersion;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.entity.bulkupdate.BulkUpdatable;
import org.iplass.mtp.entity.bulkupdate.BulkUpdateEntity;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.VersionControlType;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.condition.predicate.NotEquals;
import org.iplass.mtp.entity.query.hint.FetchSizeHint;
import org.iplass.mtp.entity.query.hint.Hint;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.csv.EntityCsvImportOption;
import org.iplass.mtp.impl.csv.EntityCsvImportResult;
import org.iplass.mtp.impl.csv.EntityCsvImportRuntimeException;
import org.iplass.mtp.impl.csv.EntityCsvImportTask;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.csv.EntityCsvException;
import org.iplass.mtp.impl.entity.csv.EntityCsvReader;
import org.iplass.mtp.impl.entity.property.MetaPrimitiveProperty;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.web.WebFrontendService;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.WebResourceBundleUtil;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityCsvImportService
implements Service {
    private static Logger logger = LoggerFactory.getLogger(EntityCsvImportService.class);
    private static Logger auditLogger = LoggerFactory.getLogger((String)"mtp.audit.porting.entity");
    private static Logger toolLogger = LoggerFactory.getLogger((String)"mtp.tools.entity");
    private static final String CSV_UPLOAD_QUEUE = "csvupload";
    public static final String ENTITY_LOB_DIR = "lobs/";
    private static Set<String> UN_UPDATABLE_PROPERTY = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("oid", "version", "createBy", "createDate", "updateBy", "updateDate")));
    private boolean canCreateUserWithSpecificPassword;
    private EntityManager em;
    private EntityDefinitionManager edm;

    public void init(Config config) {
        this.canCreateUserWithSpecificPassword = (Boolean)config.getValue("canCreateUserWithSpecificPassword", Boolean.class, (Object)false);
        this.em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
        this.edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
    }

    public void destroy() {
    }

    public void setCanCreateUserWithSpecificPassword(boolean canCreateUserWithSpecificPassword) {
        this.canCreateUserWithSpecificPassword = canCreateUserWithSpecificPassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EntityCsvImportResult importEntityData(String targetName, InputStream is, MetaDataEntry entry, EntityCsvImportOption condition, ZipFile zipFile, String importBinaryDataDir, List<String> excludeEntityNames) {
        block8: {
            EntityCsvImportService.toolLogger.info("start entity data import. {target:{}, entity:{}}", (Object)targetName, (Object)entry.getPath());
            result = new EntityCsvImportResult();
            try {
                if (excludeEntityNames != null && !excludeEntityNames.isEmpty()) {
                    for (String defName : excludeEntityNames) {
                        if (!defName.equals(entry.getMetaData().getName())) continue;
                        result.addMessages(this.rs("impl.csv.EntityCsvImportService.cantImportEntity", new Object[]{defName}));
                        var11_13 = result;
                        break block8;
                    }
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var12_14) {
                EntityCsvImportService.toolLogger.info("finish entity data import. {target:{}, entity:{}, result:{}}", new Object[]{targetName, entry.getPath(), result.isError() != false ? "failed" : "success"});
                throw var12_14;
            }
        }
        EntityCsvImportService.toolLogger.info("finish entity data import. {target:{}, entity:{}, result:{}}", new Object[]{targetName, entry.getPath(), result.isError() != false ? "failed" : "success"});
        return var11_13;
lbl-1000:
        // 1 sources

        {
            definition = this.edm.get(entry.getMetaData().getName());
            if (condition.isTruncate()) {
                EntityCsvImportService.toolLogger.info("start entity data truncate. {target:{}, entity:{}}", (Object)targetName, (Object)entry.getPath());
                delCount = this.truncateEntity(definition, condition, result);
                EntityCsvImportService.toolLogger.info("finish entity data truncate. {target:{}, entity:{}, count:{}}", new Object[]{targetName, entry.getPath(), delCount});
            }
            if (condition.isBulkUpdate()) {
                this.bulkImportCSV(is, definition, condition, zipFile, importBinaryDataDir, result);
            } else {
                this.sequenceImportCSV(is, definition, condition, zipFile, importBinaryDataDir, result);
            }
            var10_12 = result;
        }
        EntityCsvImportService.toolLogger.info("finish entity data import. {target:{}, entity:{}, result:{}}", new Object[]{targetName, entry.getPath(), result.isError() != false ? "failed" : "success"});
        return var10_12;
    }

    public void asyncImportEntityData(String targetName, InputStream is, String defName, EntityCsvImportOption option, List<String> excludeEntityNames) {
        Path destPath = this.copyUploadFile(is);
        EntityCsvImportTask task = new EntityCsvImportTask(destPath.toString(), defName, option, excludeEntityNames);
        AsyncTaskOption atOption = new AsyncTaskOption();
        atOption.setExceptionHandlingMode(ExceptionHandlingMode.ABORT);
        atOption.setGroupingKey(AuthContext.getCurrentContext().getUser().getOid());
        atOption.setQueue(CSV_UPLOAD_QUEUE);
        atOption.setReturnResult(true);
        ((AsyncTaskManager)ManagerLocator.manager(AsyncTaskManager.class)).execute(atOption, (Callable)task);
    }

    private Path copyUploadFile(InputStream is) {
        WebFrontendService webFront = (WebFrontendService)ServiceRegistry.getRegistry().getService(WebFrontendService.class);
        File tempDir = null;
        if (webFront.getTempFileDir() == null) {
            WebRequestStack reqStack = WebRequestStack.getCurrent();
            if (reqStack != null && reqStack.getRequest() != null) {
                tempDir = (File)reqStack.getRequest().getServletContext().getAttribute("javax.servlet.context.tempdir");
            }
        } else {
            tempDir = new File(webFront.getTempFileDir());
        }
        Path distFile = null;
        try {
            distFile = Files.createTempFile(tempDir.toPath(), "mtp", ".csv", new FileAttribute[0]);
            Files.copy(is, distFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException | RuntimeException e) {
            if (distFile != null) {
                try {
                    Files.deleteIfExists(distFile);
                }
                catch (IOException e1) {
                    logger.warn("Fail to delete a Temporary's File.", (Throwable)e1);
                }
            }
            throw new EntityCsvException((Throwable)e);
        }
        return distFile;
    }

    private int truncateEntity(final EntityDefinition definition, final EntityCsvImportOption cond, final EntityCsvImportResult result) {
        return (Integer)Transaction.requiresNew((Function)new Function<Transaction, Integer>(){
            private boolean isUserEntity = false;
            private int delCount = 0;

            @Override
            public Integer apply(Transaction transaction) {
                try {
                    ExecuteContext executeContext = ExecuteContext.getCurrentContext();
                    EntityContext entityContext = EntityContext.getCurrentContext();
                    EntityHandler entityHandler = entityContext.getHandlerByName(definition.getName());
                    auditLogger.info("deleteAll entity," + definition.getName());
                    boolean canDeleteAll = false;
                    if ("mtp.auth.User".equals(definition.getName())) {
                        this.isUserEntity = true;
                    } else {
                        canDeleteAll = entityHandler.canDeleteAll();
                    }
                    if (canDeleteAll) {
                        this.delCount = EntityCsvImportService.this.em.deleteAll(new DeleteCondition(definition.getName()));
                    } else {
                        Query query = new Query().select(new Object[]{"oid"}).from(definition.getName());
                        final DeleteOption option = new DeleteOption(false);
                        option.setPurge(true);
                        option.setCheckLockedByUser(false);
                        if (this.isUserEntity) {
                            query.where((Condition)new NotEquals("oid", (Object)executeContext.getClientId()));
                            option.setNotifyListeners(true);
                        } else {
                            option.setNotifyListeners(cond.isNotifyListeners());
                        }
                        EntityCsvImportService.this.em.searchEntity(query, (Predicate)new Predicate<Entity>(){

                            @Override
                            public boolean test(Entity entity) {
                                EntityCsvImportService.this.em.delete(entity, option);
                                delCount++;
                                return true;
                            }
                        });
                    }
                    result.addMessages(EntityCsvImportService.this.rs("impl.csv.EntityCsvImportService.truncateData", new Object[]{definition.getName(), this.delCount}));
                }
                catch (EntityApplicationException e) {
                    logger.error("An error occurred in the process of remove the data.", (Throwable)e);
                    transaction.setRollbackOnly();
                    result.setError(true);
                    result.addMessages(e.getMessage());
                }
                catch (EntityRuntimeException e) {
                    logger.error("An error occurred in the process of remove the data.", (Throwable)e);
                    transaction.setRollbackOnly();
                    result.setError(true);
                    result.addMessages(e.getMessage());
                }
                return this.delCount;
            }
        });
    }

    private int sequenceImportCSV(final InputStream is, final EntityDefinition definition, final EntityCsvImportOption condition, final ZipFile zipFile, final String importBinaryDataDir, final EntityCsvImportResult result) {
        return (Integer)Transaction.required((Function)new Function<Transaction, Integer>(){
            private int currentCount = 0;
            private int registCount = 0;

            @Override
            public Integer apply(Transaction transaction) {
                try (EntityCsvReader reader = new EntityCsvReader(definition, is);){
                    reader.withReferenceVersion(true).prefixOid(condition.getPrefixOid()).ignoreNotExistsProperty(condition.isIgnoreNotExistsProperty()).enableAuditPropertySpecification(condition.isInsertEnableAuditPropertySpecification());
                    if (definition.getName().equals("mtp.auth.User") && EntityCsvImportService.this.canCreateUserWithSpecificPassword) {
                        reader.setVirtualProperties(Arrays.asList("password"));
                    }
                    final Iterator iterator = reader.iterator();
                    final List headerProperties = reader.properties();
                    final boolean useCtrl = reader.isUseCtrl();
                    while (iterator.hasNext()) {
                        Transaction.requiresNew((Consumer)new Consumer<Transaction>(){
                            private int storeCount = 0;

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Override
                            public void accept(Transaction transaction) {
                                block6: while (true) {
                                    try {
                                        while (iterator.hasNext()) {
                                            String message;
                                            ++this.storeCount;
                                            if (condition.getCommitLimit() > 0 && this.storeCount % (condition.getCommitLimit() + 1) == 0) return;
                                            currentCount++;
                                            Entity entity = null;
                                            try {
                                                entity = (Entity)iterator.next();
                                                EntityCsvImportService.this.registBinaryReference(definition, entity, zipFile, importBinaryDataDir);
                                                if (!EntityCsvImportService.this.registEntity(condition, entity, definition, useCtrl, headerProperties, currentCount, result)) continue block6;
                                                registCount++;
                                                continue block6;
                                            }
                                            catch (EntityCsvImportRuntimeException e) {
                                                message = EntityCsvImportService.this.rs("impl.csv.EntityCsvImportService.updateErrMessage", new Object[]{definition.getName(), currentCount, e.getMessage(), EntityCsvImportService.this.getOidStatus(entity)});
                                                if (condition.isErrorSkip()) {
                                                    result.addMessages(message);
                                                    result.errored();
                                                    continue;
                                                }
                                                result.errored();
                                                throw new EntityCsvImportRuntimeException(message, (Throwable)((Object)e));
                                            }
                                            catch (EntityApplicationException e) {
                                                message = EntityCsvImportService.this.rs("impl.csv.EntityCsvImportService.updateErrMessage", new Object[]{definition.getName(), currentCount, e.getMessage(), EntityCsvImportService.this.getOidStatus(entity)});
                                                if (condition.isErrorSkip()) {
                                                    result.addMessages(message);
                                                    result.errored();
                                                    continue;
                                                }
                                                result.errored();
                                                throw new EntityCsvImportRuntimeException(message, e);
                                            }
                                            catch (EntityRuntimeException e) {
                                                message = EntityCsvImportService.this.rs("impl.csv.EntityCsvImportService.updateErrMessage", new Object[]{definition.getName(), currentCount, e.getMessage(), EntityCsvImportService.this.getOidStatus(entity)});
                                                if (condition.isErrorSkip()) {
                                                    result.addMessages(message);
                                                    result.errored();
                                                    continue;
                                                }
                                                result.errored();
                                                throw new EntityCsvImportRuntimeException(message, e);
                                                return;
                                            }
                                        }
                                    }
                                    catch (Throwable e) {
                                        logger.error("An error occurred in the process of import the entity data", e);
                                        transaction.setRollbackOnly();
                                        result.setError(true);
                                        if (e.getMessage() != null) {
                                            result.addMessages(e.getMessage());
                                            return;
                                        }
                                        result.addMessages(EntityCsvImportService.this.rs("impl.csv.EntityCsvImportService.importErrMessage", new Object[]{definition.getName(), e.getClass().getName()}));
                                        return;
                                    }
                                }
                            }
                        });
                        if (result.isError()) break;
                        if (logger.isDebugEnabled()) {
                            logger.debug("commit " + definition.getName() + " data. currentCount=" + this.currentCount);
                        }
                        result.addMessages(EntityCsvImportService.this.rs("impl.csv.EntityCsvImportService.commitData", new Object[]{definition.getName(), this.currentCount}));
                    }
                    if (result.getErrorCount() != 0L) {
                        result.setError(true);
                    }
                    String message = EntityCsvImportService.this.rs("impl.csv.EntityCsvImportService.resultInfo", new Object[]{definition.getName(), result.getInsertCount(), result.getUpdateCount(), result.getDeleteCount(), result.getErrorCount()});
                    if (condition.isNotifyListeners()) {
                        message = message + "(Listner)";
                    }
                    if (condition.isWithValidation()) {
                        message = message + "(Validation)";
                    }
                    result.addMessages(message);
                }
                catch (IOException | EntityCsvImportRuntimeException | EntityCsvException e) {
                    logger.error("An error occurred in the process of import the entity data", (Throwable)e);
                    transaction.setRollbackOnly();
                    result.setError(true);
                    if (((Throwable)e).getMessage() != null) {
                        result.addMessages(((Throwable)e).getMessage());
                    }
                    result.addMessages(EntityCsvImportService.this.rs("impl.csv.EntityCsvImportService.importErrMessage", new Object[]{definition.getName(), e.getClass().getName()}));
                }
                return this.registCount;
            }
        });
    }

    private void registBinaryReference(EntityDefinition definition, Entity entity, ZipFile zipFile, String importBinaryDataDir) {
        if (zipFile == null && StringUtil.isEmpty((String)importBinaryDataDir)) {
            return;
        }
        definition.getPropertyList().forEach(property -> {
            Object value = entity.getValue(property.getName());
            if (value != null) {
                if (value instanceof BinaryReference) {
                    BinaryReference br = this.registBinaryReference(definition, (BinaryReference)value, zipFile, importBinaryDataDir);
                    entity.setValue(property.getName(), (Object)br);
                } else if (value instanceof BinaryReference[]) {
                    BinaryReference[] brArray = (BinaryReference[])value;
                    for (int i = 0; i < brArray.length; ++i) {
                        brArray[i] = this.registBinaryReference(definition, brArray[i], zipFile, importBinaryDataDir);
                    }
                    entity.setValue(property.getName(), (Object)brArray);
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BinaryReference registBinaryReference(EntityDefinition definition, BinaryReference br, ZipFile zipFile, String importBinaryDataDir) {
        if (br == null) return br;
        String lobId = Long.toString(br.getLobId());
        String entryPath = ENTITY_LOB_DIR + definition.getName() + "." + lobId;
        if (zipFile != null) {
            ZipEntry zipEntry = zipFile.getEntry(entryPath);
            if (zipEntry == null) {
                logger.warn("Fail to find binary data. path = " + entryPath);
                return br;
            }
            try (InputStream is2 = zipFile.getInputStream(zipEntry);){
                BinaryReference binaryReference2 = this.em.createBinaryReference(br.getName(), br.getType(), is2);
                return binaryReference2;
            }
            catch (IOException e) {
                logger.warn("Fail to create binary data. path = " + entryPath);
                return br;
            }
        }
        if (!StringUtil.isNotEmpty((String)importBinaryDataDir)) return br;
        File lobFile = Paths.get(importBinaryDataDir, entryPath).toFile();
        try (FileInputStream is = new FileInputStream(lobFile);){
            BinaryReference binaryReference = this.em.createBinaryReference(br.getName(), br.getType(), (InputStream)is);
            return binaryReference;
        }
        catch (IOException e) {
            logger.warn("Fail to create binary data. path = " + lobFile.getName());
        }
        return br;
    }

    private boolean registEntity(EntityCsvImportOption cond, Entity entity, EntityDefinition definition, boolean useCtrl, List<String> headerProperties, int index, EntityCsvImportResult result) {
        String ctrlCode;
        ExecuteContext executeContext = ExecuteContext.getCurrentContext();
        EntityContext entityContext = EntityContext.getCurrentContext();
        EntityHandler entityHandler = entityContext.getHandlerByName(definition.getName());
        String uniqueKey = cond.getUniqueKey() != null ? cond.getUniqueKey() : "oid";
        String uniqueValue = (String)entity.getValue(uniqueKey);
        TargetVersion updateTargetVersion = null;
        DeleteTargetVersion deleteTargetVersion = null;
        InsertOption insertOption = null;
        if (StringUtil.isNotEmpty((String)uniqueValue)) {
            String storedOid;
            if (definition.getVersionControlType() != VersionControlType.NONE) {
                if (entity.getVersion() != null) {
                    storedOid = this.getVersionEntityOid(definition.getName(), uniqueKey, uniqueValue, entity.getVersion(), entityHandler);
                    if (StringUtil.isNotEmpty((String)storedOid)) {
                        updateTargetVersion = TargetVersion.SPECIFIC;
                        deleteTargetVersion = DeleteTargetVersion.SPECIFIC;
                        entity.setOid(storedOid);
                    } else {
                        insertOption = new InsertOption();
                        insertOption.setVersionSpecified(true);
                        storedOid = this.getNoneVersionEntityOid(definition.getName(), uniqueKey, uniqueValue, entityHandler);
                        if (StringUtil.isNotEmpty((String)storedOid)) {
                            entity.setOid(storedOid);
                        }
                    }
                } else {
                    storedOid = this.getNoneVersionEntityOid(definition.getName(), uniqueKey, uniqueValue, entityHandler);
                    if (StringUtil.isNotEmpty((String)storedOid)) {
                        updateTargetVersion = TargetVersion.NEW;
                        deleteTargetVersion = DeleteTargetVersion.ALL;
                        entity.setOid(storedOid);
                    }
                }
            } else {
                storedOid = this.getNoneVersionEntityOid(definition.getName(), uniqueKey, uniqueValue, entityHandler);
                if (StringUtil.isNotEmpty((String)storedOid)) {
                    updateTargetVersion = TargetVersion.CURRENT_VALID;
                    deleteTargetVersion = DeleteTargetVersion.ALL;
                    entity.setOid(storedOid);
                }
            }
        }
        if (entity.getOid() != null && "mtp.auth.User".equals(definition.getName()) && entity.getOid().equals(executeContext.getClientId())) {
            result.addMessages(this.rs("impl.csv.EntityCsvImportService.importUserSkipMessage", definition.getName(), index, entity.getOid(), entity.getValue("accountId")));
            return false;
        }
        if (useCtrl && StringUtil.isNotEmpty((String)(ctrlCode = (String)entity.getValue("_useCtrl")))) {
            if ("I".equals(ctrlCode)) {
                if (updateTargetVersion != null) {
                    throw new EntityCsvImportRuntimeException(this.rs("impl.csv.EntityCsvImportService.alreadyExists", definition.getName(), index, entity.getOid(), uniqueKey + "(" + uniqueValue + ")", ctrlCode));
                }
            } else if ("U".equals(ctrlCode)) {
                if (updateTargetVersion == null) {
                    throw new EntityCsvImportRuntimeException(this.rs("impl.csv.EntityCsvImportService.notExistsForUpdate", definition.getName(), index, entity.getOid(), uniqueKey + "(" + uniqueValue + ")", ctrlCode));
                }
            } else if ("D".equals(ctrlCode)) {
                if (deleteTargetVersion == null) {
                    throw new EntityCsvImportRuntimeException(this.rs("impl.csv.EntityCsvImportService.notExistsForDelete", definition.getName(), index, entity.getOid(), uniqueKey + "(" + uniqueValue + ")", ctrlCode));
                }
                DeleteOption option = new DeleteOption(false, deleteTargetVersion);
                option.setNotifyListeners(cond.isNotifyListeners());
                this.em.delete(entity, option);
                auditLogger.info("delete entity," + definition.getName() + ",oid:" + entity.getOid());
                if (logger.isDebugEnabled()) {
                    logger.debug("delete " + definition.getName() + " data. oid=" + entity.getOid() + ", csv line no=" + index);
                }
                result.deleted();
                return true;
            }
        }
        if (updateTargetVersion != null) {
            UpdateOption option = this.getUpdateOption(cond, headerProperties, updateTargetVersion, entityContext, entityHandler);
            this.em.update(entity, option);
            auditLogger.info("update entity," + definition.getName() + ",oid:" + entity.getOid() + " " + option);
            if (logger.isDebugEnabled()) {
                logger.debug("update " + definition.getName() + " data. oid=" + entity.getOid() + ", csv line no=" + index);
            }
            result.updated();
        } else {
            if (insertOption == null) {
                insertOption = new InsertOption();
            }
            insertOption.setRegenerateOid(false);
            insertOption.setRegenerateAutoNumber(false);
            insertOption.setEnableAuditPropertySpecification(cond.isInsertEnableAuditPropertySpecification());
            insertOption.setNotifyListeners(cond.isNotifyListeners());
            insertOption.setWithValidation(cond.isWithValidation());
            String oid = this.em.insert(entity, insertOption);
            auditLogger.info("insert entity," + definition.getName() + ",oid:" + oid + " " + insertOption);
            if (logger.isDebugEnabled()) {
                logger.debug("insert " + definition.getName() + " data. oid=" + oid + ", csv line no=" + index);
            }
            result.inserted();
        }
        return true;
    }

    private String getVersionEntityOid(String defName, String uniqueKey, String uniqueValue, Long version, EntityHandler entityHandler) {
        Query query = new Query().select(new Object[]{"oid"}).from(defName);
        query.where((Condition)new And(new Condition[]{new Equals(uniqueKey, (Object)uniqueValue), new Equals("version", (Object)version)}));
        query.versioned(true);
        query.getSelect().addHint((Hint)new FetchSizeHint(1));
        final String[] storedOid = new String[1];
        entityHandler.search(query, null, (Predicate)new Predicate<Object[]>(){

            @Override
            public boolean test(Object[] dataModel) {
                storedOid[0] = (String)dataModel[0];
                return false;
            }
        });
        return storedOid[0];
    }

    private String getNoneVersionEntityOid(String defName, String uniqueKey, String uniqueValue, EntityHandler entityHandler) {
        Query query = new Query().select(new Object[]{"oid"}).from(defName);
        query.where((Condition)new Equals(uniqueKey, (Object)uniqueValue));
        query.getSelect().addHint((Hint)new FetchSizeHint(1));
        final String[] storedOid = new String[1];
        entityHandler.search(query, null, (Predicate)new Predicate<Object[]>(){

            @Override
            public boolean test(Object[] dataModel) {
                storedOid[0] = (String)dataModel[0];
                return false;
            }
        });
        return storedOid[0];
    }

    private UpdateOption getUpdateOption(EntityCsvImportOption cond, List<String> headerProperties, TargetVersion updateTargetVersion, EntityContext entityContext, EntityHandler entityHandler) {
        UpdateOption option = new UpdateOption(false);
        option.setNotifyListeners(cond.isNotifyListeners());
        if (cond.isUpdateDisupdatableProperty()) {
            option.setWithValidation(false);
        } else {
            option.setWithValidation(cond.isWithValidation());
        }
        option.setUpdateProperties(this.getUpdateProperty(cond, headerProperties, entityContext, entityHandler));
        option.setTargetVersion(updateTargetVersion);
        option.setForceUpdate(cond.isFourceUpdate());
        return option;
    }

    private List<String> getUpdateProperty(EntityCsvImportOption cond, List<String> headerProperties, EntityContext entityContext, EntityHandler entityHandler) {
        ArrayList<String> updateProperties = new ArrayList<String>();
        for (String propName : headerProperties.stream().collect(Collectors.toSet())) {
            PropertyHandler ph = entityHandler.getProperty(propName, entityContext);
            if (ph == null) continue;
            if (cond.isUpdateDisupdatableProperty()) {
                if (UN_UPDATABLE_PROPERTY.contains(propName) || ph instanceof ReferencePropertyHandler && ((ReferencePropertyHandler)ph).getMetaData().getMappedByPropertyMetaDataId() != null || ph instanceof PrimitivePropertyHandler && ((MetaPrimitiveProperty)ph.getMetaData()).getType().isVirtual()) continue;
                updateProperties.add(propName);
                continue;
            }
            if (!ph.getMetaData().isUpdatable()) continue;
            updateProperties.add(propName);
        }
        return updateProperties;
    }

    private String getOidStatus(Entity entity) {
        return entity == null ? "UnRead" : (entity.getOid() != null ? entity.getOid() : "New");
    }

    private int bulkImportCSV(final InputStream is, final EntityDefinition definition, final EntityCsvImportOption condition, final ZipFile zipFile, final String importBinaryDataDir, final EntityCsvImportResult result) {
        return (Integer)Transaction.required((Function)new Function<Transaction, Integer>(){
            private int registCount = 0;

            @Override
            public Integer apply(Transaction transaction) {
                try (EntityCsvReader reader = new EntityCsvReader(definition, is);){
                    reader.withReferenceVersion(true).prefixOid(condition.getPrefixOid()).ignoreNotExistsProperty(condition.isIgnoreNotExistsProperty()).enableAuditPropertySpecification(condition.isInsertEnableAuditPropertySpecification());
                    final Iterator iterator = reader.iterator();
                    EntityContext entityContext = EntityContext.getCurrentContext();
                    EntityHandler entityHandler = entityContext.getHandlerByName(definition.getName());
                    final List updateProperties = EntityCsvImportService.this.getUpdateProperty(condition, reader.properties(), entityContext, entityHandler);
                    while (iterator.hasNext()) {
                        int count = (Integer)Transaction.requiresNew((Function)new Function<Transaction, Integer>(){

                            @Override
                            public Integer apply(Transaction transaction) {
                                try {
                                    PortingBulkUpdatable bulkUpdatable = new PortingBulkUpdatable(iterator, updateProperties, definition, condition, zipFile, importBinaryDataDir, result);
                                    EntityCsvImportService.this.em.bulkUpdate((BulkUpdatable)bulkUpdatable);
                                    return bulkUpdatable.getRegistCount();
                                }
                                catch (Throwable e) {
                                    logger.error("An error occurred in the process of import the entity data", e);
                                    transaction.setRollbackOnly();
                                    result.setError(true);
                                    if (e.getMessage() != null) {
                                        result.addMessages(e.getMessage());
                                    } else {
                                        result.addMessages(EntityCsvImportService.this.rs("impl.csv.EntityCsvImportService.importErrMessage", new Object[]{definition.getName(), e.getClass().getName()}));
                                    }
                                    return 0;
                                }
                            }
                        });
                        this.registCount += count;
                        if (result.isError()) break;
                        if (logger.isDebugEnabled()) {
                            logger.debug("commit " + definition.getName() + " data. currentCount=" + count);
                        }
                        result.addMessages(EntityCsvImportService.this.rs("impl.csv.EntityCsvImportService.commitData", new Object[]{definition.getName(), count}));
                    }
                    if (result.getErrorCount() != 0L) {
                        result.setError(true);
                    }
                    String message = EntityCsvImportService.this.rs("impl.csv.EntityCsvImportService.bulkResultInfo", new Object[]{definition.getName(), result.getInsertCount(), result.getUpdateCount(), result.getDeleteCount(), result.getMergeCount()});
                    result.addMessages(message);
                }
                catch (IOException | EntityCsvImportRuntimeException | EntityCsvException e) {
                    logger.error("An error occurred in the process of import the entity data", (Throwable)e);
                    transaction.setRollbackOnly();
                    result.setError(true);
                    if (((Throwable)e).getMessage() != null) {
                        result.addMessages(((Throwable)e).getMessage());
                    }
                    result.addMessages(EntityCsvImportService.this.rs("impl.csv.EntityCsvImportService.importErrMessage", new Object[]{definition.getName(), e.getClass().getName()}));
                }
                return this.registCount;
            }
        });
    }

    private String rs(String key, Object ... args) {
        return WebResourceBundleUtil.resourceString(key, args);
    }

    private class BulkIterator
    implements Iterator<BulkUpdateEntity> {
        private Iterator<Entity> internal;
        private EntityDefinition definition;
        private EntityCsvImportOption condition;
        private ZipFile zipFile;
        private String importBinaryDataDir;
        private int storeCount = 0;

        private BulkIterator(Iterator<Entity> internal, EntityDefinition definition, EntityCsvImportOption condition, ZipFile zipFile, String importBinaryDataDir) {
            this.internal = internal;
            this.definition = definition;
            this.condition = condition;
            this.zipFile = zipFile;
            this.importBinaryDataDir = importBinaryDataDir;
        }

        @Override
        public boolean hasNext() {
            if (this.internal.hasNext()) {
                ++this.storeCount;
                return this.condition.getCommitLimit() <= 0 || this.storeCount % (this.condition.getCommitLimit() + 1) != 0;
            }
            return false;
        }

        @Override
        public BulkUpdateEntity next() {
            Entity entity = this.internal.next();
            String ctrl = (String)entity.getValue("_useCtrl");
            if (this.condition.isTruncate()) {
                ctrl = "I";
            } else if (ctrl == null) {
                ctrl = entity.getValue("oid") == null ? "I" : "M";
            }
            EntityCsvImportService.this.registBinaryReference(this.definition, entity, this.zipFile, this.importBinaryDataDir);
            switch (ctrl) {
                case "D": {
                    return new BulkUpdateEntity(BulkUpdateEntity.UpdateMethod.DELETE, entity);
                }
                case "I": {
                    return new BulkUpdateEntity(BulkUpdateEntity.UpdateMethod.INSERT, entity);
                }
                case "M": {
                    return new BulkUpdateEntity(BulkUpdateEntity.UpdateMethod.MERGE, entity);
                }
                case "U": {
                    return new BulkUpdateEntity(BulkUpdateEntity.UpdateMethod.UPDATE, entity);
                }
            }
            throw new IllegalArgumentException("unsupprot controll flag");
        }
    }

    private class PortingBulkUpdatable
    implements BulkUpdatable {
        private Iterator<Entity> internal;
        private List<String> updateProperties;
        private EntityDefinition definition;
        private EntityCsvImportOption condition;
        private ZipFile zipFile;
        String importBinaryDataDir;
        private EntityCsvImportResult result;
        private int registCount = 0;

        public PortingBulkUpdatable(Iterator<Entity> internal, List<String> updateProperties, EntityDefinition definition, EntityCsvImportOption condition, ZipFile zipFile, String importBinaryDataDir, EntityCsvImportResult result) {
            this.internal = internal;
            this.updateProperties = updateProperties;
            this.definition = definition;
            this.condition = condition;
            this.zipFile = zipFile;
            this.importBinaryDataDir = importBinaryDataDir;
            this.result = result;
        }

        public Iterator<BulkUpdateEntity> iterator() {
            return new BulkIterator(this.internal, this.definition, this.condition, this.zipFile, this.importBinaryDataDir);
        }

        public String getDefinitionName() {
            return this.definition.getName();
        }

        public List<String> getUpdateProperties() {
            return this.updateProperties;
        }

        public boolean isEnableAuditPropertySpecification() {
            return this.condition.isInsertEnableAuditPropertySpecification();
        }

        public void updated(BulkUpdateEntity updatedEntity) {
            this.registCount = this.getRegistCount() + 1;
            switch (updatedEntity.getMethod()) {
                case DELETE: {
                    this.result.deleted();
                    break;
                }
                case INSERT: {
                    this.result.inserted();
                    break;
                }
                case UPDATE: {
                    this.result.updated();
                    break;
                }
                case MERGE: {
                    this.result.merged();
                    break;
                }
            }
        }

        public int getRegistCount() {
            return this.registCount;
        }
    }
}

