/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.cluster.channel.http.servlet;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.iplass.mtp.impl.cluster.ClusterService;
import org.iplass.mtp.impl.cluster.Message;
import org.iplass.mtp.impl.cluster.channel.MessageChannel;
import org.iplass.mtp.impl.cluster.channel.http.HttpMessageChannel;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterMessageChannelServlet
extends HttpServlet {
    private static final long serialVersionUID = 8940534146769969242L;
    private static Logger logger = LoggerFactory.getLogger(ClusterMessageChannelServlet.class);
    private HttpMessageChannel messageChannel;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ClusterService cs = (ClusterService)ServiceRegistry.getRegistry().getService(ClusterService.class);
        MessageChannel mc = cs.getMessageChannel();
        if (mc instanceof HttpMessageChannel) {
            this.messageChannel = (HttpMessageChannel)mc;
        }
    }

    private Message toMessage(HttpServletRequest req) {
        String eventName = req.getParameter("en");
        if (eventName != null) {
            Message msg = new Message(eventName);
            Enumeration e = req.getParameterNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                msg.addParameter(key, req.getParameter(key));
            }
            msg.removeParameter("certKey");
            msg.removeParameter("en");
            return msg;
        }
        return null;
    }

    private void doMessage(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.messageChannel != null) {
            try {
                String certKey = req.getParameter("certKey");
                Message msg = this.toMessage(req);
                if (msg != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("receive message :" + msg);
                    }
                    this.messageChannel.doReceiveMessage(msg, certKey);
                }
            }
            catch (RuntimeException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doMessage(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doMessage(req, resp);
    }
}

