/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.introspectors;

import java.util.Map;
import org.iplass.mtp.auth.oauth.CustomTokenIntrospector;
import org.iplass.mtp.auth.oauth.definition.CustomTokenIntrospectorDefinition;
import org.iplass.mtp.auth.oauth.definition.introspectors.JavaClassCustomTokenIntrospectorDefinition;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.impl.auth.oauth.MetaCustomTokenIntrospector;
import org.iplass.mtp.impl.auth.oauth.token.AccessToken;
import org.iplass.mtp.impl.metadata.MetaDataRuntimeException;

public class MetaJavaClassCustomTokenIntrospector
extends MetaCustomTokenIntrospector {
    private static final long serialVersionUID = 3535843225458827L;
    private String className;

    public MetaJavaClassCustomTokenIntrospector() {
    }

    public MetaJavaClassCustomTokenIntrospector(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public void applyConfig(CustomTokenIntrospectorDefinition def) {
        this.className = ((JavaClassCustomTokenIntrospectorDefinition)def).getClassName();
    }

    @Override
    public CustomTokenIntrospectorDefinition currentConfig() {
        JavaClassCustomTokenIntrospectorDefinition def = new JavaClassCustomTokenIntrospectorDefinition();
        def.setClassName(this.className);
        return def;
    }

    @Override
    public MetaCustomTokenIntrospector.CustomTokenIntrospectorRuntime createRuntime(String metaId, int index) {
        return new JavaClassCustomTokenIntrospectorRuntime();
    }

    public class JavaClassCustomTokenIntrospectorRuntime
    extends MetaCustomTokenIntrospector.CustomTokenIntrospectorRuntime {
        private CustomTokenIntrospector customTokenIntrospector;

        private JavaClassCustomTokenIntrospectorRuntime() {
            super(MetaJavaClassCustomTokenIntrospector.this);
            try {
                this.customTokenIntrospector = (CustomTokenIntrospector)Class.forName(MetaJavaClassCustomTokenIntrospector.this.className).newInstance();
            }
            catch (InstantiationException e) {
                throw new MetaDataRuntimeException("can not instantiate " + MetaJavaClassCustomTokenIntrospector.this.className, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new MetaDataRuntimeException("can not instantiate " + MetaJavaClassCustomTokenIntrospector.this.className, (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new MetaDataRuntimeException("class not found:" + MetaJavaClassCustomTokenIntrospector.this.className, (Throwable)e);
            }
        }

        @Override
        public boolean handle(Map<String, Object> response, RequestContext request, AccessToken token) {
            return this.customTokenIntrospector.handle(response, request, token.getUser());
        }

        @Override
        public MetaCustomTokenIntrospector getMetaData() {
            return MetaJavaClassCustomTokenIntrospector.this;
        }
    }
}

