/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.consents;

import java.util.Collections;
import java.util.List;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.oauth.definition.ClientType;
import org.iplass.mtp.auth.oauth.definition.ConsentTypeDefinition;
import org.iplass.mtp.auth.oauth.definition.consents.ScriptingConsentTypeDefinition;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.oauth.MetaConsentType;
import org.iplass.mtp.impl.auth.oauth.token.AccessToken;
import org.iplass.mtp.impl.command.RequestContextBinding;
import org.iplass.mtp.impl.command.SessionBinding;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptEngine;

public class MetaScriptingConsentType
extends MetaConsentType {
    private static final long serialVersionUID = 7627301483098333747L;
    private static final String AUTH_CONTEXT_BINDING_NAME = "auth";
    private static final String USER_BINDING_NAME = "user";
    private static final String REQUEST_BINDING_NAME = "request";
    private static final String SESSION_BINDING_NAME = "session";
    private static final String REQUIRED_SCOPES_BINDING_NAME = "requiredScopes";
    private static final String GRANTED_SCOPES_BINDING_NAME = "grantedScopes";
    private String script;

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    @Override
    public ScriptingConsentTypeRuntime createRuntime(String metaId, ClientType ct) {
        return new ScriptingConsentTypeRuntime(metaId, ct);
    }

    @Override
    public void applyConfig(ConsentTypeDefinition consentType) {
        this.script = ((ScriptingConsentTypeDefinition)consentType).getScript();
    }

    @Override
    public ConsentTypeDefinition currentConfig() {
        ScriptingConsentTypeDefinition def = new ScriptingConsentTypeDefinition();
        def.setScript(this.script);
        return def;
    }

    public class ScriptingConsentTypeRuntime
    extends MetaConsentType.ConsentTypeRuntime {
        private static final String SCRIPT_PREFIX = "ScriptingConsentType_script";
        private Script scriptRuntime;

        public ScriptingConsentTypeRuntime(String metaId, ClientType ct) {
            TenantContext tc = ExecuteContext.getCurrentContext().getTenantContext();
            this.scriptRuntime = tc.getScriptEngine().createScript(MetaScriptingConsentType.this.script, "ScriptingConsentType_script_" + metaId + "_" + (Object)((Object)ct));
        }

        @Override
        public boolean needConsent(RequestContext request, List<String> scopes, AccessToken currentToken) {
            Boolean ret;
            ExecuteContext ex = ExecuteContext.getCurrentContext();
            TenantContext tc = ex.getTenantContext();
            ScriptEngine scriptEngine = tc.getScriptEngine();
            ScriptContext sc = scriptEngine.newScriptContext();
            sc.setAttribute(MetaScriptingConsentType.REQUEST_BINDING_NAME, (Object)RequestContextBinding.newRequestContextBinding());
            sc.setAttribute(MetaScriptingConsentType.SESSION_BINDING_NAME, (Object)SessionBinding.newSessionBinding());
            sc.setAttribute(MetaScriptingConsentType.USER_BINDING_NAME, (Object)AuthContextHolder.getAuthContext().newUserBinding());
            sc.setAttribute(MetaScriptingConsentType.AUTH_CONTEXT_BINDING_NAME, (Object)AuthContext.getCurrentContext());
            sc.setAttribute(MetaScriptingConsentType.REQUIRED_SCOPES_BINDING_NAME, Collections.unmodifiableList(scopes));
            if (currentToken != null) {
                sc.setAttribute(MetaScriptingConsentType.GRANTED_SCOPES_BINDING_NAME, Collections.unmodifiableList(currentToken.getGrantedScopes()));
            }
            return (ret = (Boolean)this.scriptRuntime.eval(sc)) != null && ret != false;
        }
    }
}

