/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.command;

import java.util.HashMap;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthAuthorization;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthClient;
import org.iplass.mtp.impl.auth.oauth.OAuthApplicationException;
import org.iplass.mtp.impl.auth.oauth.OAuthTokens;
import org.iplass.mtp.impl.auth.oauth.command.CommandUtil;
import org.iplass.mtp.impl.auth.oauth.idtoken.IdToken;
import org.iplass.mtp.impl.auth.oauth.token.AccessToken;
import org.iplass.mtp.impl.auth.oauth.util.OAuthEndpointConstants;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.webapi.definition.CacheControlType;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;
import org.iplass.mtp.webapi.definition.StateType;

@WebApi(name="oauth/token", accepts={RequestType.REST_FORM}, methods={MethodType.POST}, checkXRequestedWithHeader=false, privileged=true, state=StateType.STATELESS, cacheControlType=CacheControlType.NO_CACHE, responseType="application/json")
@CommandClass(name="mtp/oauth/TokenCommand", displayName="OAuth2.0 Token Endpoint")
public class TokenCommand
implements Command,
OAuthEndpointConstants {
    static final String STAT_SUCCESS = "SUCCESS";

    public String execute(RequestContext request) {
        MetaOAuthClient.OAuthClientRuntime clientRuntime = CommandUtil.validateClient(request, true);
        String grantType = StringUtil.stripToNull((String)request.getParam("grant_type"));
        if ("authorization_code".equals(grantType)) {
            return this.authorizationCode(request, clientRuntime);
        }
        if ("refresh_token".equals(grantType)) {
            return this.refreshToken(request, clientRuntime);
        }
        throw new WebApplicationException(CommandUtil.buildErrorResponse("unsupported_grant_type", null, null));
    }

    private String authorizationCode(RequestContext request, MetaOAuthClient.OAuthClientRuntime clientRuntime) {
        String codeStr = StringUtil.stripToNull((String)request.getParam("code"));
        if (codeStr == null) {
            throw new WebApplicationException(CommandUtil.buildErrorResponse("invalid_request", "code must specify", null));
        }
        String redirectUri = StringUtil.stripToNull((String)request.getParam("redirect_uri"));
        String codeVerifier = StringUtil.stripToNull((String)request.getParam("code_verifier"));
        try {
            MetaOAuthAuthorization.OAuthAuthorizationRuntime authRuntime = clientRuntime.getAuthorizationServer();
            OAuthTokens tokens = authRuntime.exchangeCodeToToken(codeStr, redirectUri, codeVerifier, clientRuntime);
            Response.ResponseBuilder res = Response.ok().type(MediaType.APPLICATION_JSON_TYPE.withCharset("UTF-8")).entity(this.toResponseEntity(tokens.getAccessToken(), tokens.getIdToken(), request, authRuntime));
            request.setAttribute("result", (Object)res);
            return STAT_SUCCESS;
        }
        catch (OAuthApplicationException e) {
            throw new WebApplicationException(CommandUtil.buildErrorResponse(e.getCode(), e.getDescription(), null));
        }
    }

    private Object toResponseEntity(AccessToken accessToken, IdToken idToken, RequestContext request, MetaOAuthAuthorization.OAuthAuthorizationRuntime authServer) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("access_token", accessToken.getTokenEncoded());
        res.put("token_type", "Bearer");
        res.put("expires_in", accessToken.getExpiresIn());
        if (accessToken.getGrantedScopes() != null) {
            res.put("scope", String.join((CharSequence)" ", accessToken.getGrantedScopes()));
        }
        if (accessToken.getRefreshToken() != null) {
            res.put("refresh_token", accessToken.getRefreshToken().getTokenEncoded());
            res.put("refresh_token_expires_in", accessToken.getRefreshToken().getExpiresIn());
        }
        if (idToken != null) {
            res.put("id_token", idToken.getTokenEncoded(authServer.issuerId(request)));
        }
        return res;
    }

    private String refreshToken(RequestContext request, MetaOAuthClient.OAuthClientRuntime clientRuntime) {
        String refreshToken = StringUtil.stripToNull((String)request.getParam("refresh_token"));
        if (refreshToken == null) {
            throw new WebApplicationException(CommandUtil.buildErrorResponse("invalid_request", "refresh_token must specify", null));
        }
        try {
            MetaOAuthAuthorization.OAuthAuthorizationRuntime authRuntime = clientRuntime.getAuthorizationServer();
            AccessToken token = authRuntime.refreshToken(refreshToken, clientRuntime);
            Response.ResponseBuilder res = Response.ok().type(MediaType.APPLICATION_JSON_TYPE.withCharset("UTF-8")).entity(this.toResponseEntity(token, null, null, authRuntime));
            request.setAttribute("result", (Object)res);
            return STAT_SUCCESS;
        }
        catch (OAuthApplicationException e) {
            throw new WebApplicationException(CommandUtil.buildErrorResponse(e.getCode(), e.getDescription(), null));
        }
    }
}

