/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.command;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.IdPasswordCredential;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.impl.auth.authenticate.builtin.web.WWWAuthenticateException;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthAuthorization;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthClient;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthResourceServer;
import org.iplass.mtp.impl.auth.oauth.OAuthAuthorizationService;
import org.iplass.mtp.impl.auth.oauth.OAuthClientService;
import org.iplass.mtp.impl.auth.oauth.OAuthResourceServerService;
import org.iplass.mtp.impl.auth.oauth.command.CommandUtil;
import org.iplass.mtp.impl.auth.oauth.token.AccessToken;
import org.iplass.mtp.impl.auth.oauth.util.OAuthEndpointConstants;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;
import org.iplass.mtp.webapi.definition.StateType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebApi(name="oauth/introspect", accepts={RequestType.REST_FORM}, methods={MethodType.POST}, checkXRequestedWithHeader=false, privileged=true, state=StateType.STATELESS, responseType="application/json")
@CommandClass(name="mtp/oauth/IntrospectCommand", displayName="OAuth2.0 Introspection Endpoint")
public class IntrospectCommand
implements Command,
OAuthEndpointConstants {
    static final String STAT_SUCCESS = "SUCCESS";
    private static Logger logger = LoggerFactory.getLogger(IntrospectCommand.class);
    private OAuthAuthorizationService authService = (OAuthAuthorizationService)ServiceRegistry.getRegistry().getService(OAuthAuthorizationService.class);
    private OAuthClientService clientService = (OAuthClientService)ServiceRegistry.getRegistry().getService(OAuthClientService.class);
    private OAuthResourceServerService rsService = (OAuthResourceServerService)ServiceRegistry.getRegistry().getService(OAuthResourceServerService.class);

    public String execute(RequestContext request) {
        MetaOAuthResourceServer.OAuthResourceServerRuntime resourceServer = this.validateResourceServer(request);
        String token = request.getParam("token");
        Object entity = this.introspect(request, token, resourceServer);
        Response.ResponseBuilder res = Response.ok().type(MediaType.APPLICATION_JSON_TYPE.withCharset("UTF-8")).entity(entity);
        request.setAttribute("result", (Object)res);
        return STAT_SUCCESS;
    }

    private Object introspect(RequestContext request, String tokenStr, MetaOAuthResourceServer.OAuthResourceServerRuntime resourceServer) {
        try {
            AccessToken accessToken = this.authService.getAccessTokenStore().getAccessToken(tokenStr);
            if (accessToken == null) {
                return this.inactiveResponseEntity();
            }
            if (accessToken.getExpiresIn() <= 0L) {
                return this.inactiveResponseEntity();
            }
            MetaOAuthClient.OAuthClientRuntime client = (MetaOAuthClient.OAuthClientRuntime)this.clientService.getRuntimeByName(accessToken.getClientId());
            if (client == null) {
                return this.inactiveResponseEntity();
            }
            MetaOAuthAuthorization.OAuthAuthorizationRuntime server = client.getAuthorizationServer();
            if (server == null) {
                return this.inactiveResponseEntity();
            }
            Map<String, Object> res = resourceServer.toResponseMap(request, accessToken, server);
            if (res == null) {
                return this.inactiveResponseEntity();
            }
            return res;
        }
        catch (RuntimeException e) {
            if (logger.isDebugEnabled()) {
                logger.error(e.toString(), (Throwable)e);
            } else {
                logger.error(e.toString());
            }
            return this.inactiveResponseEntity();
        }
    }

    private MetaOAuthResourceServer.OAuthResourceServerRuntime validateResourceServer(RequestContext request) {
        IdPasswordCredential clientCredential = CommandUtil.clientCredential(request);
        if (clientCredential == null) {
            throw new WebApplicationException(CommandUtil.buildErrorResponse("invalid_client", null, null));
        }
        MetaOAuthResourceServer.OAuthResourceServerRuntime resourceServer = (MetaOAuthResourceServer.OAuthResourceServerRuntime)this.rsService.getRuntimeByName(clientCredential.getId());
        if (resourceServer == null || !resourceServer.validateCredential((Credential)clientCredential)) {
            if (clientCredential.getAuthenticationFactor("Basic") != null) {
                throw new WWWAuthenticateException("Basic", null, CommandUtil.errorMsg("invalid_client", null, null));
            }
            throw new WebApplicationException(CommandUtil.buildErrorResponse("invalid_client", null, null));
        }
        return resourceServer;
    }

    private Object inactiveResponseEntity() {
        HashMap<String, Boolean> res = new HashMap<String, Boolean>();
        res.put("active", false);
        return res;
    }
}

