/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.command;

import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthAuthorization;
import org.iplass.mtp.impl.auth.oauth.OAuthAuthorizationService;
import org.iplass.mtp.impl.auth.oauth.code.AuthorizationCode;
import org.iplass.mtp.impl.auth.oauth.code.AuthorizationRequest;
import org.iplass.mtp.impl.auth.oauth.command.AuthorizeCommand;
import org.iplass.mtp.spi.ServiceRegistry;

@ActionMapping(name="oauth/consent", clientCacheType=ActionMapping.ClientCacheType.NO_CACHE, synchronizeOnSession=true, result={@Result(status="SUCCESS_REDIRECT", type=Result.Type.REDIRECT, allowExternalLocation=true, value="redirectPath"), @Result(status="SUCCESS_POST", type=Result.Type.TEMPLATE, value="oauth/OAuthPost"), @Result(status="ERROR_REDIRECT", type=Result.Type.REDIRECT, allowExternalLocation=true, value="redirectPath")})
@CommandClass(name="mtp/oauth/ConsentCommand", displayName="OAuth2.0 Consent Processing")
public class ConsentCommand
implements Command {
    public static final String PARAM_REQUEST_ID = "requestId";
    public static final String PARAM_SUBMIT = "submit";
    public static final String SUBMIT_CANCEL = "cancel";
    public static final String SUBMIT_ACCEPT = "accept";
    private AuthorizeCommand authorizeCommand = new AuthorizeCommand();
    private OAuthAuthorizationService authorizationService = (OAuthAuthorizationService)ServiceRegistry.getRegistry().getService(OAuthAuthorizationService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(RequestContext request) {
        AuthorizationRequest authReq = null;
        String requestId = request.getParam(PARAM_REQUEST_ID);
        String submit = request.getParam(PARAM_SUBMIT);
        try {
            authReq = (AuthorizationRequest)request.getSession().getAttribute("org.iplass.mtp.oauth.authorizationRequest");
            if (authReq == null) {
                throw new ApplicationException("Invalid OAuth authorization flow.");
            }
            if (!authReq.getRequestId().equals(requestId)) {
                throw new ApplicationException("Invalid OAuth authorization flow.");
            }
        }
        finally {
            request.getSession().removeAttribute("org.iplass.mtp.oauth.authorizationRequest");
        }
        MetaOAuthAuthorization.OAuthAuthorizationRuntime authRuntime = (MetaOAuthAuthorization.OAuthAuthorizationRuntime)this.authorizationService.getRuntimeByName(authReq.getAuthorizationServerId());
        if (SUBMIT_ACCEPT.equals(submit)) {
            AuthorizationCode code = authRuntime.generateCode(authReq);
            return this.authorizeCommand.success(request, code, authRuntime.issuerId(request));
        }
        return this.authorizeCommand.error(request, "access_denied", "User canceled OAuth request.", authReq, authRuntime.issuerId(request));
    }
}

