/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.command;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.IdPasswordCredential;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.impl.auth.authenticate.builtin.web.BasicAuthUtil;
import org.iplass.mtp.impl.auth.authenticate.builtin.web.WWWAuthenticateException;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthClient;
import org.iplass.mtp.impl.auth.oauth.OAuthClientService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CommandUtil {
    private static Logger logger = LoggerFactory.getLogger(CommandUtil.class);
    private static OAuthClientService clientService = (OAuthClientService)ServiceRegistry.getRegistry().getService(OAuthClientService.class);

    CommandUtil() {
    }

    static IdPasswordCredential clientCredential(RequestContext request) {
        String clientId = StringUtil.stripToNull((String)request.getParam("client_id"));
        String clientSecret = null;
        if (clientId != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("get client credential from parameter. clientId:" + clientId);
            }
            clientSecret = StringUtil.stripToNull((String)request.getParam("client_secret"));
            return new IdPasswordCredential(clientId, clientSecret);
        }
        IdPasswordCredential cre = BasicAuthUtil.decodeFromHeader(request);
        if (cre != null && logger.isDebugEnabled()) {
            logger.debug("get client credential from header. clientId:" + cre.getId());
        }
        cre.setAuthenticationFactor("Basic", (Object)true);
        return cre;
    }

    static MetaOAuthClient.OAuthClientRuntime validateClient(RequestContext request, boolean allowPublicClient) {
        IdPasswordCredential clientCredential = CommandUtil.clientCredential(request);
        if (clientCredential == null) {
            throw new WebApplicationException(CommandUtil.buildErrorResponse("invalid_client", null, null));
        }
        MetaOAuthClient.OAuthClientRuntime clientRuntime = (MetaOAuthClient.OAuthClientRuntime)clientService.getRuntimeByName(clientCredential.getId());
        if (clientRuntime == null || clientRuntime.getAuthorizationServer() == null || !clientRuntime.validateCredential((Credential)clientCredential, allowPublicClient)) {
            if (clientCredential.getAuthenticationFactor("Basic") != null) {
                throw new WWWAuthenticateException("Basic", null, CommandUtil.errorMsg("invalid_client", null, null));
            }
            throw new WebApplicationException(CommandUtil.buildErrorResponse("invalid_client", null, null));
        }
        return clientRuntime;
    }

    static Response buildErrorResponse(String error, String errorDescription, String errorUri) {
        String msg = CommandUtil.errorMsg(error, errorDescription, errorUri);
        int statCode = 400;
        if ("invalid_client".equals(error)) {
            statCode = 401;
        }
        return Response.status((int)statCode).header("Content-Type", (Object)"application/json").entity((Object)msg).build();
    }

    static String errorMsg(String error, String errorDescription, String errorUri) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\"error\":");
        sb.append("\"").append(StringUtil.escapeJavaScript((String)error)).append("\"");
        if (errorDescription != null) {
            sb.append(",\"error_description\":");
            sb.append("\"").append(StringUtil.escapeJavaScript((String)errorDescription)).append("\"");
        }
        if (errorUri != null) {
            sb.append(",\"errorUri\":");
            sb.append("\"").append(StringUtil.escapeJavaScript((String)errorUri)).append("\"");
        }
        sb.append("}");
        return sb.toString();
    }
}

